/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class ServiceResolver
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;
    int count = 0;
    private String type;

    public ServiceResolver(JmDNSImpl jmDNSImpl, String type) {
        this.jmDNSImpl = jmDNSImpl;
        this.type = type;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    public void run() {
        try {
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this.count++ < 3) {
                    long now = System.currentTimeMillis();
                    DNSOutgoing out = new DNSOutgoing(0);
                    out.addQuestion(new DNSQuestion(this.type, 12, 1));
                    Iterator s = this.jmDNSImpl.getServices().values().iterator();
                    while (s.hasNext()) {
                        ServiceInfoImpl info = (ServiceInfoImpl)s.next();
                        try {
                            out.addAnswer(new DNSRecord.Pointer(info.getType(), 12, 1, 3600, info.getQualifiedName()), now);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    this.jmDNSImpl.send(out);
                } else {
                    this.cancel();
                }
            } else if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            this.jmDNSImpl.recover();
        }
    }
}

