/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.ConnectionConfiguration;

class ServerTrustManager
implements X509TrustManager {
    private ConnectionConfiguration configuration;
    private String server;
    private KeyStore trustStore;

    public ServerTrustManager(String server, ConnectionConfiguration configuration) {
        this.configuration = configuration;
        this.server = server;
        try {
            this.trustStore = KeyStore.getInstance(configuration.getTruststoreType());
            this.trustStore.load(new FileInputStream(configuration.getTruststorePath()), configuration.getTruststorePassword().toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            configuration.setVerifyRootCAEnabled(false);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String arg1) throws CertificateException {
        int nSize = x509Certificates.length;
        String peerIdentity = ServerTrustManager.getPeerIdentity(x509Certificates[0]);
        if (this.configuration.isVerifyChainEnabled()) {
            Principal principalLast = null;
            int i = nSize - 1;
            while (i >= 0) {
                X509Certificate x509certificate = x509Certificates[i];
                Principal principalIssuer = x509certificate.getIssuerDN();
                Principal principalSubject = x509certificate.getSubjectDN();
                if (principalLast != null) {
                    if (principalIssuer.equals(principalLast)) {
                        try {
                            PublicKey publickey = x509Certificates[i + 1].getPublicKey();
                            x509Certificates[i].verify(publickey);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CertificateException("signature verification failed of " + peerIdentity);
                        }
                    } else {
                        throw new CertificateException("subject/issuer verification failed of " + peerIdentity);
                    }
                }
                principalLast = principalSubject;
                --i;
            }
        }
        if (this.configuration.isVerifyRootCAEnabled()) {
            boolean trusted = false;
            try {
                boolean bl = trusted = this.trustStore.getCertificateAlias(x509Certificates[nSize - 1]) != null;
                if (!trusted && nSize == 1 && this.configuration.isSelfSignedCertificateEnabled()) {
                    System.out.println("Accepting self-signed certificate of remote server: " + peerIdentity);
                    trusted = true;
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            if (!trusted) {
                throw new CertificateException("root certificate not trusted of " + peerIdentity);
            }
        }
        if (this.configuration.isNotMatchingDomainCheckEnabled() && (peerIdentity.startsWith("*.") ? !this.server.endsWith(peerIdentity = peerIdentity.substring(2)) : !this.server.equals(peerIdentity))) {
            throw new CertificateException("target verification failed of " + peerIdentity);
        }
        if (this.configuration.isExpiredCertificatesCheckEnabled()) {
            Date date = new Date();
            int i = 0;
            while (i < nSize) {
                try {
                    x509Certificates[i].checkValidity(date);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertificateException("invalid date of " + this.server);
                }
                ++i;
            }
        }
    }

    public static String getPeerIdentity(X509Certificate x509Certificate) {
        Principal principalSubject = x509Certificate.getSubjectDN();
        String name = principalSubject.getName();
        if (name.startsWith("CN=")) {
            name = name.substring(3);
        }
        return name;
    }
}

