/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription;

public class RemoteServiceEndpointDescriptionImpl
extends RemoteServiceEndpointDescription {
    private final ID endpointId;
    private final IServiceID serviceId;
    private ID targetId = null;

    public RemoteServiceEndpointDescriptionImpl(IServiceInfo serviceInfo) {
        super(((ServiceProperties)serviceInfo.getServiceProperties()).asProperties());
        this.serviceId = serviceInfo.getServiceID();
        IServiceProperties serviceProperties = serviceInfo.getServiceProperties();
        byte[] endpointBytes = serviceProperties.getPropertyBytes("ecf.sp.cid");
        if (endpointBytes == null) {
            throw new IDCreateException("ServiceEndpointDescription endpointBytes cannot be null");
        }
        String endpointStr = new String(endpointBytes);
        String namespaceStr = serviceProperties.getPropertyString("ecf.sp.cns");
        if (namespaceStr == null) {
            throw new IDCreateException("ServiceEndpointDescription namespaceStr cannot be null");
        }
        this.endpointId = IDFactory.getDefault().createID(namespaceStr, endpointStr);
        byte[] targetBytes = serviceProperties.getPropertyBytes("ecf.sp.tid");
        if (targetBytes != null) {
            String targetStr = new String(endpointBytes);
            String targetNamespaceStr = serviceProperties.getPropertyString("ecf.sp.tns");
            if (targetNamespaceStr == null) {
                targetNamespaceStr = namespaceStr;
            }
            this.targetId = IDFactory.getDefault().createID(targetNamespaceStr, targetStr);
        }
    }

    public ID getEndpointAsID() throws IDCreateException {
        return this.endpointId;
    }

    public ID getConnectTargetID() {
        return this.targetId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServiceEndpointDescriptionImpl other = (RemoteServiceEndpointDescriptionImpl)obj;
        return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals((Object)other.serviceId));
    }

    public IServiceID getServiceID() {
        return this.serviceId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServiceEndpointDescriptionImpl[");
        sb.append(";providedinterfaces=").append(this.getProvidedInterfaces());
        sb.append(";location=").append(this.getLocation());
        sb.append(";serviceid=").append(this.getServiceID());
        sb.append(";osgiEndpointID=").append(this.getEndpointID());
        sb.append(";ecfEndpointID=").append(this.getEndpointAsID());
        sb.append(";ecfTargetID=").append(this.getConnectTargetID());
        sb.append(";ecfFilter=").append(this.getRemoteServicesFilter());
        sb.append(";props=").append(this.getProperties()).append("]");
        return sb.toString();
    }
}

