/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.IRemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.distribution.AbstractContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;

public class DefaultProxyContainerFinder
extends AbstractContainerFinder
implements IProxyContainerFinder {
    protected IContainer[] getContainers(IServiceID serviceID, IRemoteServiceEndpointDescription endpointDescription) {
        IContainer[] allContainers = this.getAllContainers();
        if (allContainers == null) {
            return null;
        }
        ArrayList<IContainer> results = new ArrayList<IContainer>();
        int i = 0;
        while (i < allContainers.length) {
            ID containerID = allContainers[i].getID();
            if (containerID != null && !containerID.equals((Object)endpointDescription.getEndpointAsID()) && this.includeContainerWithConnectNamespace(allContainers[i], (String)endpointDescription.getProperty("ecf.sp.cns"))) {
                results.add(allContainers[i]);
            }
            ++i;
        }
        return results.toArray(new IContainer[0]);
    }

    protected IRemoteServiceContainer[] getRemoteServiceContainers(IServiceID serviceID, IRemoteServiceEndpointDescription endpointDescription) {
        IContainer[] containers = this.getContainers(serviceID, endpointDescription);
        if (containers == null) {
            return null;
        }
        return this.getRemoteServiceContainers(containers);
    }

    public IRemoteServiceContainer[] findProxyContainers(IServiceID serviceID, IRemoteServiceEndpointDescription endpointDescription, IProgressMonitor monitor) {
        IRemoteServiceContainer[] connectedContainers;
        this.trace("findProxyContainers", "serviceID=" + serviceID + " endpointDescription=" + endpointDescription);
        IRemoteServiceContainer[] rsContainers = this.getRemoteServiceContainers(serviceID, endpointDescription);
        if (rsContainers == null) {
            this.logWarning("findProxyContainers", "No remote service containers found");
            return EMPTY_REMOTE_SERVICE_CONTAINER_ARRAY;
        }
        this.trace("findProxyContainers", "getRemoteServiceContainers.length=" + rsContainers.length);
        ID connectTargetID = endpointDescription.getConnectTargetID();
        IRemoteServiceContainer[] iRemoteServiceContainerArray = connectedContainers = connectTargetID == null ? rsContainers : this.connectRemoteServiceContainers(rsContainers, connectTargetID, monitor);
        if (connectedContainers == null) {
            this.logWarning("findProxyContainers", "No remote service containers found after connect");
            return EMPTY_REMOTE_SERVICE_CONTAINER_ARRAY;
        }
        this.trace("findProxyContainers", "connectRemoteServiceContainers.length=" + rsContainers.length);
        return connectedContainers;
    }

    protected IConnectContext getConnectContext(IRemoteServiceContainer rsContainer, ID connectTargetID) {
        return null;
    }

    protected IRemoteServiceContainer[] connectRemoteServiceContainers(IRemoteServiceContainer[] rsContainers, ID connectTargetID, IProgressMonitor monitor) {
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        int i = 0;
        while (i < rsContainers.length) {
            IContainer c = rsContainers[i].getContainer();
            try {
                if (c.getConnectedID() == null) {
                    this.connectContainer(c, connectTargetID, this.getConnectContext(rsContainers[i], connectTargetID));
                }
                results.add(rsContainers[i]);
            }
            catch (ContainerConnectException e) {
                this.logError("connectRemoteServiceContainers", "Exception connecting container=" + c.getID() + " to connectTargetID=" + connectTargetID, e);
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }
}

