/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.bittorrent;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.ContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.internal.provider.bittorrent.BitTorrentMessages;
import org.eclipse.ecf.internal.provider.bittorrent.BitTorrentProviderPlugin;
import org.eclipse.ecf.internal.provider.bittorrent.TorrentFileTransfer;
import org.eclipse.ecf.internal.provider.bittorrent.TorrentID;
import org.eclipse.ecf.protocol.bittorrent.Torrent;
import org.eclipse.ecf.protocol.bittorrent.TorrentFactory;
import org.eclipse.ecf.protocol.bittorrent.TorrentFile;
import org.eclipse.osgi.util.NLS;

public final class BitTorrentContainer
implements IContainer,
IRetrieveFileTransfer {
    private final List containerListeners;
    private final ID id = IDFactory.getDefault().createGUID();

    public BitTorrentContainer() throws IDCreateException {
        this.containerListeners = new ArrayList();
        BitTorrentProviderPlugin.getDefault().setConfigurationPath();
    }

    public void connect(ID targetID, IConnectContext connectContext) throws ContainerConnectException {
    }

    public void disconnect() {
    }

    public void dispose() {
        this.fireContainerEvent((IContainerEvent)new ContainerDisposeEvent(this.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainerEvent(IContainerEvent event) {
        List list = this.containerListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.containerListeners.size()) {
                IContainerListener icl = (IContainerListener)this.containerListeners.get(i);
                icl.handleEvent(event);
                ++i;
            }
        }
    }

    public Object getAdapter(Class serviceType) {
        return serviceType.isInstance(this) ? this : null;
    }

    public Namespace getConnectNamespace() {
        return null;
    }

    public ID getConnectedID() {
        return null;
    }

    public ID getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IContainerListener listener) {
        List list = this.containerListeners;
        synchronized (list) {
            if (!this.containerListeners.contains(listener)) {
                this.containerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IContainerListener listener) {
        List list = this.containerListeners;
        synchronized (list) {
            this.containerListeners.remove(listener);
        }
    }

    public void sendRetrieveRequest(final IFileID remoteFileReference, final IFileTransferListener transferListener, Map options) throws IncomingFileTransferException {
        Assert.isNotNull((Object)remoteFileReference, (String)NLS.bind((String)BitTorrentMessages.BitTorrentContainer_NullParameter, (Object)"remoteFileReference"));
        Assert.isLegal((boolean)(remoteFileReference instanceof TorrentID), (String)NLS.bind((String)BitTorrentMessages.BitTorrentContainer_ReferenceNotTorrentID, (Object)"remoteFileReference"));
        Assert.isNotNull((Object)transferListener, (String)NLS.bind((String)BitTorrentMessages.BitTorrentContainer_NullParameter, (Object)"transferListener"));
        transferListener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveStartEvent(){
            private static final long serialVersionUID = 5195806924769910246L;
            private IIncomingFileTransfer transfer;
            private boolean cancelled = false;

            public IIncomingFileTransfer receive(File localFileToSave) throws IOException {
                if (this.cancelled) {
                    throw new RuntimeException((Throwable)new UserCancelledException());
                }
                Assert.isNotNull((Object)localFileToSave, (String)NLS.bind((String)BitTorrentMessages.BitTorrentContainer_NullParameter, (Object)"localFileToSave"));
                if (localFileToSave.exists() && !localFileToSave.canWrite()) {
                    throw new IOException(NLS.bind((String)BitTorrentMessages.BitTorrentContainer_CannotWriteToFile, (Object)localFileToSave.getAbsolutePath()));
                }
                TorrentFile file = new TorrentFile(((TorrentID)remoteFileReference).getFile());
                file.setTargetFile(localFileToSave);
                Torrent torrent = TorrentFactory.createTorrent((TorrentFile)file);
                this.transfer = new TorrentFileTransfer((ID)remoteFileReference, transferListener, torrent);
                return this.transfer;
            }

            public IIncomingFileTransfer receive(File localFileToSave, FileTransferJob fileTransferJob) throws IOException {
                if (this.cancelled) {
                    throw new RuntimeException((Throwable)new UserCancelledException());
                }
                Assert.isNotNull((Object)localFileToSave, (String)NLS.bind((String)BitTorrentMessages.BitTorrentContainer_NullParameter, (Object)"localFileToSave"));
                if (localFileToSave.exists() && !localFileToSave.canWrite()) {
                    throw new IOException(NLS.bind((String)BitTorrentMessages.BitTorrentContainer_CannotWriteToFile, (Object)localFileToSave.getAbsolutePath()));
                }
                TorrentFile file = new TorrentFile(((TorrentID)remoteFileReference).getFile());
                file.setTargetFile(localFileToSave);
                Torrent torrent = TorrentFactory.createTorrent((TorrentFile)file);
                this.transfer = new TorrentFileTransfer((ID)remoteFileReference, transferListener, torrent);
                return this.transfer;
            }

            public void cancel() {
                if (this.transfer != null) {
                    this.transfer.cancel();
                    this.cancelled = true;
                }
            }

            public IFileID getFileID() {
                return remoteFileReference;
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore) throws IOException {
                throw new UnsupportedOperationException(BitTorrentMessages.BitTorrentContainer_CannotWriteToStream);
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore, FileTransferJob fileTransferJob) throws IOException {
                throw new UnsupportedOperationException(BitTorrentMessages.BitTorrentContainer_CannotWriteToStream);
            }

            public IIncomingFileTransfer getSource() {
                return this.transfer;
            }
        });
    }

    public Namespace getRetrieveNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.bittorrent");
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
    }

    public void setProxy(Proxy proxy) {
    }

    public void sendRetrieveRequest(IFileID remoteFileID, IFileRangeSpecification rangeSpecification, IFileTransferListener transferListener, Map options) throws IncomingFileTransferException {
        throw new InvalidFileRangeSpecificationException("not supported", rangeSpecification);
    }
}

