/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class Announcer
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;
    DNSState taskState = DNSState.ANNOUNCING_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Announcer(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
        if (this.jmDNSImpl.getState() == DNSState.ANNOUNCING_1) {
            this.jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this.jmDNSImpl;
        synchronized (jmDNSImpl2) {
            Iterator s = this.jmDNSImpl.getServices().values().iterator();
            while (s.hasNext()) {
                ServiceInfoImpl info = (ServiceInfoImpl)s.next();
                if (info.getState() != DNSState.ANNOUNCING_1) continue;
                info.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this.jmDNSImpl.getTask() == this) {
            this.jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            Iterator i = this.jmDNSImpl.getServices().values().iterator();
            while (i.hasNext()) {
                ServiceInfoImpl info = (ServiceInfoImpl)i.next();
                if (info.getTask() != this) continue;
                info.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DNSOutgoing out = null;
        try {
            ArrayList list;
            if (this.jmDNSImpl.getState() == this.taskState) {
                if (out == null) {
                    out = new DNSOutgoing(33792);
                }
                this.jmDNSImpl.getLocalHost().addAddressRecords(out, false);
                this.jmDNSImpl.advanceState();
            }
            JmDNSImpl jmDNSImpl = this.jmDNSImpl;
            synchronized (jmDNSImpl) {
                list = new ArrayList(this.jmDNSImpl.getServices().values());
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ServiceInfoImpl info;
                ServiceInfoImpl serviceInfoImpl = info = (ServiceInfoImpl)i.next();
                synchronized (serviceInfoImpl) {
                    if (info.getState() == this.taskState && info.getTask() == this) {
                        info.advanceState();
                        if (out == null) {
                            out = new DNSOutgoing(33792);
                        }
                        info.addAnswers(out, 3600, this.jmDNSImpl.getLocalHost());
                    }
                }
            }
            if (out != null) {
                this.jmDNSImpl.send(out);
            } else {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            this.jmDNSImpl.recover();
        }
        this.taskState = this.taskState.advance();
        if (!this.taskState.isAnnouncing()) {
            this.cancel();
            this.jmDNSImpl.startRenewer();
        }
    }
}

