/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.Base64;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;

public class ServicePropertiesAdapter {
    private static final String ECLIPSE_ENTERPRISE_NUMBER = "28392";
    private static final String SERVICE_ID_NAME = "x-28392-SERVICEIDNAME";
    private static final String PRIORITY = "x-28392-PRIORITY";
    private static final String WEIGHT = "x-28392-WEIGHT";
    private static final String SLP_BYTE_PREFIX = "\\FF";
    private final IServiceProperties serviceProperties;
    private String serviceName;
    private int priority = 0;
    private int weight = 0;

    public ServicePropertiesAdapter(List aList) {
        Assert.isNotNull((Object)aList);
        this.serviceProperties = new ServiceProperties();
        Iterator itr = aList.iterator();
        while (itr.hasNext()) {
            String[] str = StringUtils.split((String)((String)itr.next()), (String)"=");
            if (str.length != 2) {
                Trace.trace((String)"org.eclipse.ecf.provider.jslp", (String)"/debug/methods/tracing", this.getClass(), (String)"ServicePropertiesAdapter(List)", (String)("Skipped broken service attribute " + str));
                continue;
            }
            String key = str[0].substring(1);
            String value = str[1].substring(0, str[1].length() - 1);
            if (key.equalsIgnoreCase(SERVICE_ID_NAME)) {
                this.serviceName = value;
                continue;
            }
            if (key.equalsIgnoreCase(PRIORITY)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase(WEIGHT)) {
                this.weight = Integer.parseInt(value);
                continue;
            }
            if (value.startsWith(SLP_BYTE_PREFIX)) {
                String[] strs = StringUtils.split((String)value.substring(4), (String)"\\");
                byte[] b = new byte[strs.length];
                int i = 0;
                while (i < strs.length) {
                    byte parseInt;
                    b[i] = parseInt = (byte)Integer.parseInt(strs[i], 16);
                    ++i;
                }
                this.serviceProperties.setPropertyBytes(key, Base64.decodeFromCharArray((byte[])b));
                continue;
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.serviceProperties.setProperty(key, (Object)Boolean.valueOf(value));
                continue;
            }
            if (this.isInteger(value)) {
                this.serviceProperties.setProperty(key, (Object)Integer.valueOf(value));
                continue;
            }
            this.serviceProperties.setProperty(key, (Object)value);
        }
    }

    public ServicePropertiesAdapter(IServiceInfo sInfo) {
        Assert.isNotNull((Object)sInfo);
        IServiceID sID = sInfo.getServiceID();
        Assert.isNotNull((Object)sID);
        IServiceProperties sp = sInfo.getServiceProperties();
        Assert.isNotNull((Object)sp);
        this.serviceProperties = new ServiceProperties(sp);
        if (sInfo.getPriority() >= 0) {
            this.serviceProperties.setPropertyString(PRIORITY, Integer.toString(sInfo.getPriority()));
        }
        if (sInfo.getWeight() >= 0) {
            this.serviceProperties.setPropertyString(WEIGHT, Integer.toString(sInfo.getWeight()));
        }
        if (sID.getServiceName() != null) {
            this.serviceProperties.setPropertyString(SERVICE_ID_NAME, sID.getServiceName());
        }
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public IServiceProperties toServiceProperties() {
        return this.serviceProperties;
    }

    public Dictionary toProperties() {
        Properties dict = new Properties();
        Enumeration propertyNames = this.serviceProperties.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            byte[] propertyBytes = this.serviceProperties.getPropertyBytes(key);
            if (propertyBytes != null) {
                byte[] encode = Base64.encodeToCharArray((byte[])propertyBytes);
                StringBuffer buf = new StringBuffer();
                buf.append(SLP_BYTE_PREFIX);
                int i = 0;
                while (i < encode.length) {
                    buf.append('\\');
                    buf.append(Integer.toHexString(encode[i]));
                    ++i;
                }
                ((Dictionary)dict).put(key, buf.toString());
                continue;
            }
            ((Dictionary)dict).put(key, this.serviceProperties.getProperty(key).toString());
        }
        return dict;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

