/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.Messages;
import org.eclipse.ecf.provider.comm.tcp.Client;
import org.eclipse.ecf.provider.comm.tcp.ConnectRequestMessage;
import org.eclipse.ecf.provider.comm.tcp.ConnectResultMessage;
import org.eclipse.ecf.provider.comm.tcp.ISocketAcceptHandler;
import org.eclipse.ecf.provider.comm.tcp.Server;
import org.eclipse.ecf.provider.generic.SOContainerGroup;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public class TCPServerSOContainerGroup
extends SOContainerGroup
implements ISocketAcceptHandler {
    public static final String INVALID_CONNECT = Messages.TCPServerSOContainerGroup_Invalid_Connect_Request;
    public static final String DEFAULT_GROUP_NAME;
    private int port;
    private Server listener;
    private boolean isOnTheAir = false;
    private final ThreadGroup threadGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_GROUP_NAME = clazz.getName();
    }

    public TCPServerSOContainerGroup(String name, ThreadGroup group, int port) {
        super(name);
        this.threadGroup = group;
        this.port = port;
    }

    public TCPServerSOContainerGroup(String name, int port) {
        this(name, null, port);
    }

    public TCPServerSOContainerGroup(int port) {
        this(DEFAULT_GROUP_NAME, null, port);
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)msg);
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", (Class)clazz, (String)msg, (Throwable)e);
    }

    public synchronized void putOnTheAir() throws IOException {
        this.trace("TCPServerSOContainerGroup at port " + this.port + " on the air");
        this.listener = new Server(this.threadGroup, this.port, this);
        this.port = this.listener.getLocalPort();
        this.isOnTheAir = true;
    }

    public synchronized boolean isOnTheAir() {
        return this.isOnTheAir;
    }

    private void setSocketOptions(Socket aSocket) throws SocketException {
        aSocket.setTcpNoDelay(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAccept(Socket aSocket) throws Exception {
        Client newClient;
        this.setSocketOptions(aSocket);
        ObjectOutputStream oStream = new ObjectOutputStream(aSocket.getOutputStream());
        oStream.flush();
        ObjectInputStream iStream = new ObjectInputStream(aSocket.getInputStream());
        ConnectRequestMessage req = (ConnectRequestMessage)iStream.readObject();
        if (req == null) {
            throw new InvalidObjectException(String.valueOf(INVALID_CONNECT) + Messages.TCPServerSOContainerGroup_Exception_Connect_Request_Null);
        }
        URI uri = req.getTarget();
        if (uri == null) {
            throw new InvalidObjectException(String.valueOf(INVALID_CONNECT) + Messages.TCPServerSOContainerGroup_Target_Null);
        }
        String path = uri.getPath();
        if (path == null) {
            throw new InvalidObjectException(String.valueOf(INVALID_CONNECT) + Messages.TCPServerSOContainerGroup_Target_Path_Null);
        }
        TCPServerSOContainer srs = (TCPServerSOContainer)this.get(path);
        if (srs == null) {
            throw new InvalidObjectException(String.valueOf(Messages.TCPServerSOContainerGroup_Container_For_Target) + path + Messages.TCPServerSOContainerGroup_Not_Found);
        }
        Client client = newClient = new Client(aSocket, iStream, oStream, srs.getReceiver());
        synchronized (client) {
            Serializable resp = srs.handleConnectRequest(aSocket, path, req.getData(), newClient);
            oStream.writeObject(new ConnectResultMessage(resp));
            oStream.flush();
        }
    }

    public synchronized void takeOffTheAir() {
        if (this.listener != null) {
            this.trace("Taking " + this.getName() + " off the air.");
            try {
                this.listener.close();
            }
            catch (IOException e) {
                this.traceStack("Exception in closeListener", e);
            }
            this.listener = null;
        }
        this.isOnTheAir = false;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ";port:" + this.port;
    }
}

