/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.r_osgi.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSID;

public class R_OSGiWSNamespace
extends R_OSGiNamespace {
    private static final long serialVersionUID = -3460085239213524498L;
    public static final String NAME_WS = "ecf.namespace.r_osgi.ws";
    private static final String NAMESPACE_SCHEME_WS = "r-osgi.ws";
    private static Namespace instance;

    public static Namespace getDefault() {
        if (instance == null) {
            new R_OSGiWSNamespace();
        }
        return instance;
    }

    public R_OSGiWSNamespace() {
        super(NAME_WS, "R-OSGi Http Namespace");
        instance = this;
    }

    public ID createInstance(Object[] parameters) throws IDCreateException {
        try {
            String uriString = (String)parameters[0];
            if (uriString == null) {
                throw new NullPointerException("URI parameter is null");
            }
            if (!uriString.startsWith(NAMESPACE_SCHEME_WS) && !uriString.startsWith("http")) {
                throw new URISyntaxException(uriString, "URI must have r-osgi.ws as protocol");
            }
            URI uri = new URI(uriString);
            return new R_OSGiWSID(false, uri.getHost(), uri.getPort());
        }
        catch (Exception e) {
            throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", (Throwable)e);
        }
    }

    public String getScheme() {
        return NAMESPACE_SCHEME_WS;
    }

    public String[] getSupportedSchemes() {
        return new String[]{NAMESPACE_SCHEME_WS};
    }
}

