/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.AsyncRemoteCallCallback;
import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.AsyncCallback;
import ch.ethz.iks.r_osgi.impl.ProxyGenerator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceReferenceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceRegistration;
import ch.ethz.iks.r_osgi.impl.TimeOffset;
import ch.ethz.iks.r_osgi.messages.DeliverBundlesMessage;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import ch.ethz.iks.r_osgi.messages.LeaseMessage;
import ch.ethz.iks.r_osgi.messages.LeaseUpdateMessage;
import ch.ethz.iks.r_osgi.messages.RemoteCallMessage;
import ch.ethz.iks.r_osgi.messages.RemoteCallResultMessage;
import ch.ethz.iks.r_osgi.messages.RemoteEventMessage;
import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.r_osgi.messages.RequestBundleMessage;
import ch.ethz.iks.r_osgi.messages.RequestDependenciesMessage;
import ch.ethz.iks.r_osgi.messages.RequestServiceMessage;
import ch.ethz.iks.r_osgi.messages.StreamRequestMessage;
import ch.ethz.iks.r_osgi.messages.StreamResultMessage;
import ch.ethz.iks.r_osgi.messages.TimeOffsetMessage;
import ch.ethz.iks.r_osgi.streams.InputStreamHandle;
import ch.ethz.iks.r_osgi.streams.InputStreamProxy;
import ch.ethz.iks.r_osgi.streams.OutputStreamHandle;
import ch.ethz.iks.r_osgi.streams.OutputStreamProxy;
import ch.ethz.iks.util.CollectionUtils;
import ch.ethz.iks.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.remoteservice.asyncproxy.AsyncReturnUtil;
import org.objectweb.asm.Type;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public final class ChannelEndpointImpl
implements ChannelEndpoint {
    int usageCounter = 1;
    protected NetworkChannel networkChannel;
    private Map remoteServices = new HashMap(0);
    private List remoteTopics = new ArrayList(0);
    private TimeOffset timeOffset;
    private static final int TIMEOUT = Integer.parseInt(System.getProperty("ch.ethz.iks.r_osgi.channelEndpointImpl.timeout", "120000"));
    protected final Map callbacks = new HashMap(0);
    private final HashMap localServices = new HashMap(2);
    private final HashMap proxiedServices = new HashMap(0);
    protected final HashMap proxyBundles = new HashMap(0);
    private final HashMap streams = new HashMap(0);
    private short nextStreamID = 0;
    private ServiceRegistration handlerReg = null;
    private static final String NO_LOOPS = "(&(!(sender.uri=*))(!(event.topics=org/osgi/service/remoteserviceadmin/*)))";
    private ArrayList workQueue = new ArrayList();
    boolean hasRedundantLinks = false;
    boolean traceChannelEndpoint = new Boolean(System.getProperty("ch.ethz.iks.r_osgi.impl.traceChannelEndpoint", "false"));
    private long startTime;
    public static final String TRACE_TIME_PROP = System.getProperty("ch.ethz.iks.r_osgi.traceSendMessageTime");
    private static boolean TRACE_TIME = false;
    private static boolean USE_LOG_SERVICE = true;
    private static final SimpleDateFormat sdf;

    static {
        if (TRACE_TIME_PROP != null) {
            if (TRACE_TIME_PROP.equalsIgnoreCase("logservice") || TRACE_TIME_PROP.equalsIgnoreCase("true")) {
                TRACE_TIME = true;
            } else if (TRACE_TIME_PROP.equalsIgnoreCase("systemout")) {
                TRACE_TIME = true;
                USE_LOG_SERVICE = false;
            }
        }
        sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    }

    void trace(String message) {
        this.trace(message, null);
    }

    void trace(String message, Throwable t) {
        if (!this.traceChannelEndpoint) {
            return;
        }
        if (message != null) {
            System.out.println("ChannelEndpoint;" + message);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    ChannelEndpointImpl(NetworkChannelFactory factory, URI endpointAddress) throws RemoteOSGiException, IOException {
        this.trace("<init>(factory=" + factory + ",endpointAddress=" + endpointAddress + ")");
        this.networkChannel = factory.getConnection(this, endpointAddress);
        if (RemoteOSGiServiceImpl.DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "opening new channel " + this.getRemoteAddress());
        }
        this.initThreadPool();
        RemoteOSGiServiceImpl.registerChannelEndpoint(this);
    }

    ChannelEndpointImpl(NetworkChannel channel) {
        this.trace("<init>(channel=" + channel + ";remoteAddress=" + channel.getRemoteAddress() + ";localAddress=" + channel.getLocalAddress() + ")");
        this.networkChannel = channel;
        channel.bind(this);
        this.initThreadPool();
        RemoteOSGiServiceImpl.registerChannelEndpoint(this);
    }

    private void initThreadPool() {
        ThreadGroup threadPool = new ThreadGroup("WorkerThreads" + this.toString());
        threadPool.setDaemon(true);
        int i = 0;
        while (i < RemoteOSGiServiceImpl.MAX_THREADS_PER_ENDPOINT) {
            Thread t = new Thread(threadPool, "r-OSGi ChannelWorkerThread" + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (!this.isInterrupted()) {
                            Runnable r;
                            ArrayList arrayList = ChannelEndpointImpl.this.workQueue;
                            synchronized (arrayList) {
                                while (ChannelEndpointImpl.this.workQueue.isEmpty()) {
                                    ChannelEndpointImpl.this.workQueue.wait();
                                }
                                r = (Runnable)ChannelEndpointImpl.this.workQueue.remove(0);
                            }
                            r.run();
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            };
            t.start();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedMessage(final RemoteOSGiMessage msg) {
        WaitingCallback callback;
        if (msg == null) {
            this.dispose();
            return;
        }
        Integer xid = msg.getXID();
        Map map = this.callbacks;
        synchronized (map) {
            callback = (WaitingCallback)this.callbacks.remove(xid);
        }
        if (callback != null) {
            callback.result(msg);
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RemoteOSGiMessage reply = ChannelEndpointImpl.this.handleMessage(msg);
                if (reply != null) {
                    try {
                        ChannelEndpointImpl.this.trace("reply(msg=" + reply + ";remoteAddress=" + ChannelEndpointImpl.this.networkChannel.getRemoteAddress() + ")");
                        ChannelEndpointImpl.this.networkChannel.sendMessage(reply);
                    }
                    catch (NotSerializableException nse) {
                        throw new RemoteOSGiException("Error sending " + reply, nse);
                    }
                    catch (NullPointerException nse) {
                    }
                    catch (IOException e) {
                        ChannelEndpointImpl.this.dispose();
                    }
                }
            }
        };
        ArrayList arrayList = this.workQueue;
        synchronized (arrayList) {
            this.workQueue.add(r);
            this.workQueue.notify();
        }
    }

    @Override
    public Object invokeMethod(String service, String methodSignature, Object[] args) throws Throwable {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof InputStream) {
                args[i] = this.getInputStreamPlaceholder((InputStream)args[i]);
            } else if (args[i] instanceof OutputStream) {
                args[i] = this.getOutputStreamPlaceholder((OutputStream)args[i]);
            }
            ++i;
        }
        RemoteCallMessage invokeMsg = new RemoteCallMessage();
        invokeMsg.setServiceID(URI.create(service).getFragment());
        invokeMsg.setMethodSignature(methodSignature);
        invokeMsg.setArgs(args);
        try {
            RemoteCallResultMessage resultMsg = (RemoteCallResultMessage)this.sendAndWait(invokeMsg);
            if (resultMsg.causedException()) {
                throw resultMsg.getException();
            }
            Object result = resultMsg.getResult();
            if (result instanceof InputStreamHandle) {
                return this.getInputStreamProxy((InputStreamHandle)result);
            }
            if (result instanceof OutputStreamHandle) {
                return this.getOutputStreamProxy((OutputStreamHandle)result);
            }
            if (result != null) {
                String returnType = Type.getReturnType((String)methodSignature).getClassName();
                RemoteServiceReferenceImpl refImpl = this.getRemoteReference(URI.create(service).toString());
                if (refImpl != null && refImpl.isOSGiAsync() && AsyncReturnUtil.isAsyncType((String)returnType)) {
                    return AsyncReturnUtil.convertReturnToAsync((Object)result, (String)returnType);
                }
            }
            return result;
        }
        catch (RemoteOSGiException e) {
            throw new RemoteOSGiException("Method invocation of " + service + " " + methodSignature + " failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncRemoteCall(String fragment, String methodSignature, Object[] args, final AsyncRemoteCallCallback callback) {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof InputStream) {
                args[i] = this.getInputStreamPlaceholder((InputStream)args[i]);
            } else if (args[i] instanceof OutputStream) {
                args[i] = this.getOutputStreamPlaceholder((OutputStream)args[i]);
            }
            ++i;
        }
        Integer xid = RemoteOSGiServiceImpl.nextXid();
        Map map = this.callbacks;
        synchronized (map) {
            this.callbacks.put(xid, new AsyncCallback(){

                @Override
                public void result(RemoteOSGiMessage msg) {
                    Object result;
                    RemoteCallResultMessage resultMsg = (RemoteCallResultMessage)msg;
                    if (resultMsg.causedException()) {
                        callback.remoteCallResult(false, resultMsg.getException());
                    }
                    Object res = (result = resultMsg.getResult()) instanceof InputStreamHandle ? ChannelEndpointImpl.this.getInputStreamProxy((InputStreamHandle)result) : (result instanceof OutputStreamHandle ? ChannelEndpointImpl.this.getOutputStreamProxy((OutputStreamHandle)result) : result);
                    callback.remoteCallResult(true, res);
                }
            });
        }
        RemoteCallMessage invokeMsg = new RemoteCallMessage();
        invokeMsg.setServiceID(fragment);
        invokeMsg.setMethodSignature(methodSignature);
        invokeMsg.setArgs(args);
        invokeMsg.setXID(xid.shortValue());
        try {
            this.send(invokeMsg);
        }
        catch (RemoteOSGiException e) {
            this.callbacks.remove(xid);
            callback.remoteCallResult(false, new RemoteOSGiException("Method invocation of " + this.getRemoteAddress() + "#" + fragment + " " + methodSignature + " failed.", e));
        }
    }

    @Override
    public Dictionary getProperties(String serviceID) {
        return this.getRemoteReference(serviceID).getProperties();
    }

    @Override
    public Dictionary getPresentationProperties(String serviceID) {
        Hashtable<String, Object> attribs = new Hashtable<String, Object>();
        ((Dictionary)attribs).put("service.uri", serviceID);
        ((Dictionary)attribs).put("service.presentation", this.getRemoteReference(serviceID).getProperty("service.presentation"));
        return attribs;
    }

    @Override
    public void trackRegistration(String serviceID, ServiceRegistration reg) {
        this.proxiedServices.put(serviceID, reg);
    }

    @Override
    public void untrackRegistration(String serviceID) {
        this.proxiedServices.remove(serviceID);
    }

    public TimeOffset getOffset() throws RemoteOSGiException {
        if (this.timeOffset == null) {
            TimeOffsetMessage timeMsg = new TimeOffsetMessage();
            int i = 0;
            while (i < 4) {
                timeMsg.timestamp();
                timeMsg = (TimeOffsetMessage)this.sendAndWait(timeMsg);
                ++i;
            }
            this.timeOffset = new TimeOffset(timeMsg.getTimeSeries());
        } else if (this.timeOffset.isExpired()) {
            TimeOffsetMessage timeMsg = new TimeOffsetMessage();
            int i = 0;
            while (i < this.timeOffset.seriesLength()) {
                timeMsg.timestamp();
                timeMsg = (TimeOffsetMessage)this.sendAndWait(timeMsg);
                i += 2;
            }
            this.timeOffset.update(timeMsg.getTimeSeries());
        }
        return this.timeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.networkChannel == null) {
            return;
        }
        if (RemoteOSGiServiceImpl.DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "DISPOSING ENDPOINT " + this.getRemoteAddress());
        }
        RemoteOSGiServiceImpl.unregisterChannelEndpoint(this.getRemoteAddress().toString());
        if (this.handlerReg != null) {
            this.handlerReg.unregister();
        }
        NetworkChannel oldchannel = this.networkChannel;
        this.networkChannel = null;
        try {
            oldchannel.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (!this.hasRedundantLinks) {
            RemoteServiceReference[] refs = this.remoteServices.values().toArray(new RemoteServiceReference[this.remoteServices.size()]);
            int i = 0;
            while (i < refs.length) {
                RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(4, refs[i]));
                ++i;
            }
            Bundle[] proxies = this.proxyBundles.values().toArray(new Bundle[this.proxyBundles.size()]);
            int i2 = 0;
            while (i2 < proxies.length) {
                try {
                    if (proxies[i2].getState() != 1) {
                        proxies[i2].uninstall();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i2;
            }
        }
        this.remoteServices = null;
        this.remoteTopics = null;
        this.timeOffset = null;
        this.callbacks.clear();
        this.localServices.clear();
        this.proxiedServices.clear();
        this.closeStreams();
        this.streams.clear();
        this.handlerReg = null;
        Map map = this.callbacks;
        synchronized (map) {
            this.callbacks.notifyAll();
        }
    }

    public boolean isConnected() {
        return this.networkChannel != null;
    }

    public String toString() {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        return "ChannelEndpoint(" + this.networkChannel.toString() + ")";
    }

    public int readStream(short streamID) throws IOException {
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)0);
        requestMsg.setStreamID(streamID);
        StreamResultMessage resultMsg = this.doStreamOp(requestMsg);
        return resultMsg.getResult();
    }

    public int readStream(short streamID, byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)1);
        requestMsg.setStreamID(streamID);
        requestMsg.setLenOrVal(len);
        StreamResultMessage resultMsg = this.doStreamOp(requestMsg);
        int length = resultMsg.getLen();
        if (length > 0) {
            byte[] readdata = resultMsg.getData();
            System.arraycopy(readdata, 0, b, off, length);
        }
        return length;
    }

    public void writeStream(short streamID, int b) throws IOException {
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)2);
        requestMsg.setStreamID(streamID);
        requestMsg.setLenOrVal(b);
        this.doStreamOp(requestMsg);
    }

    public void writeStream(short streamID, byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)3);
        requestMsg.setStreamID(streamID);
        requestMsg.setData(data);
        requestMsg.setLenOrVal(len);
        this.doStreamOp(requestMsg);
    }

    @Override
    public URI getRemoteAddress() {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        return this.networkChannel.getRemoteAddress();
    }

    URI getLocalAddress() {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        return this.networkChannel.getLocalAddress();
    }

    RemoteServiceReference[] sendLease(RemoteServiceRegistration[] myServices, String[] myTopics) {
        LeaseMessage l = new LeaseMessage();
        this.populateLease(l, myServices, myTopics);
        LeaseMessage lease = (LeaseMessage)this.sendAndWait(l);
        return this.processLease(lease);
    }

    void sendLeaseUpdate(LeaseUpdateMessage msg) {
        this.send(msg);
    }

    boolean isActive(String uri) {
        return this.remoteServices.get(uri) != null;
    }

    void getProxyBundle(RemoteServiceReference ref) throws IOException, RemoteOSGiException {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed.");
        }
        RequestServiceMessage req = new RequestServiceMessage();
        req.setServiceID(ref.getURI().getFragment());
        DeliverServiceMessage deliv = (DeliverServiceMessage)this.sendAndWait(req);
        InputStream in = new ProxyGenerator().generateProxyBundle(ref.getURI(), deliv);
        this.installResolveAndStartBundle(ref, in, true);
    }

    private void installResolveAndStartBundle(RemoteServiceReference ref, InputStream in, boolean isProxy) {
        try {
            Bundle bundle = RemoteOSGiActivator.getActivator().getContext().installBundle(ref.getURI().toString(), in);
            this.retrieveDependencies((String)bundle.getHeaders().get("Import-Package"), (String)bundle.getHeaders().get("Export-Package"));
            if (isProxy) {
                this.proxyBundles.put(ref.getURI().getFragment(), bundle);
            }
            bundle.start();
        }
        catch (BundleException e) {
            Throwable nested = e.getNestedException() == null ? e : e.getNestedException();
            throw new RemoteOSGiException("Could not install the generated bundle " + ref.toString(), nested);
        }
    }

    void getCloneBundle(RemoteServiceReference ref) {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed.");
        }
        RequestBundleMessage req = new RequestBundleMessage();
        req.setServiceID(ref.getURI().getFragment());
        DeliverBundlesMessage deliv = (DeliverBundlesMessage)this.sendAndWait(req);
        byte[] bundleBytes = deliv.getDependencies()[0];
        this.installResolveAndStartBundle(ref, new ByteArrayInputStream(bundleBytes), false);
    }

    private String[] getTokens(String str) {
        ArrayList<String> result = new ArrayList<String>();
        String[] tokens = StringUtils.stringToArray(str, ",");
        int i = 0;
        while (i < tokens.length) {
            String pkg;
            int pos = tokens[i].indexOf(";");
            String string = pkg = pos > -1 ? tokens[i].substring(0, pos).trim() : tokens[i].trim();
            if (!RemoteOSGiServiceImpl.checkPackageImport(pkg)) {
                result.add(pkg);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private void retrieveDependencies(String importString, String exportString) {
        HashSet<String> exports = new HashSet<String>(Arrays.asList(this.getTokens(exportString)));
        HashSet<String> imports = new HashSet<String>(Arrays.asList(this.getTokens(importString)));
        String[] missing = CollectionUtils.rightDifference(imports, exports).toArray(new String[0]);
        if (missing.length > 0) {
            RequestDependenciesMessage req = new RequestDependenciesMessage();
            req.setPackages(missing);
            DeliverBundlesMessage deps = (DeliverBundlesMessage)this.sendAndWait(req);
            byte[][] depBytes = deps.getDependencies();
            int i = 0;
            while (i < depBytes.length) {
                try {
                    RemoteOSGiActivator.getActivator().getContext().installBundle("r-osgi://dep/" + missing[i], (InputStream)new ByteArrayInputStream(depBytes[i]));
                }
                catch (BundleException be) {
                    be.printStackTrace();
                }
                ++i;
            }
        }
    }

    RemoteServiceReferenceImpl getRemoteReference(String uri) {
        return (RemoteServiceReferenceImpl)this.remoteServices.get(uri);
    }

    RemoteServiceReference[] getAllRemoteReferences(Filter filter) {
        ArrayList<RemoteServiceReference> result = new ArrayList<RemoteServiceReference>();
        RemoteServiceReference[] refs = this.remoteServices.values().toArray(new RemoteServiceReferenceImpl[this.remoteServices.size()]);
        if (filter == null) {
            return refs.length > 0 ? refs : null;
        }
        int i = 0;
        while (i < refs.length) {
            if (filter.match(((RemoteServiceReferenceImpl)refs[i]).getProperties())) {
                result.add(refs[i]);
            }
            ++i;
        }
        RemoteServiceReference[] refs2 = result.toArray(new RemoteServiceReferenceImpl[result.size()]);
        return refs2.length > 0 ? refs2 : null;
    }

    void ungetRemoteService(URI uri) {
        try {
            Bundle bundle = (Bundle)this.proxyBundles.remove(uri.getFragment());
            if (bundle != null) {
                bundle.uninstall();
            } else {
                RemoteOSGiServiceImpl.log.log(2, "failed to uninstall non-existant bundle " + uri.getFragment());
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    void startTiming(String message) {
        if (TRACE_TIME) {
            this.startTime = System.currentTimeMillis();
            StringBuffer buf = new StringBuffer("TIMING.START;");
            buf.append(sdf.format(new Date(this.startTime))).append(";");
            buf.append(message == null ? "" : message);
            LogService logService = RemoteOSGiServiceImpl.log;
            if (logService != null && USE_LOG_SERVICE) {
                logService.log(3, buf.toString());
            } else {
                System.out.println(buf.toString());
            }
        }
    }

    void stopTiming(String message, Throwable exception) {
        if (TRACE_TIME) {
            StringBuffer buf = new StringBuffer("TIMING.END;");
            buf.append(sdf.format(new Date(this.startTime))).append(";");
            buf.append(message == null ? "" : message);
            buf.append(";duration(ms)=").append(System.currentTimeMillis() - this.startTime);
            LogService logService = RemoteOSGiServiceImpl.log;
            if (logService != null && USE_LOG_SERVICE) {
                if (exception != null) {
                    logService.log(1, buf.toString(), exception);
                } else {
                    logService.log(3, buf.toString());
                }
            } else {
                System.out.println(buf.toString());
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
            this.startTime = 0L;
        }
    }

    void send(RemoteOSGiMessage msg) {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Channel is closed");
        }
        if (msg.getXID() == 0) {
            msg.setXID(RemoteOSGiServiceImpl.nextXid());
        }
        RemoteOSGiException t = null;
        String timingMsg = "sendMessage;funcId=" + msg.getFuncID() + ";xid=" + msg.getXID();
        this.startTiming(timingMsg);
        try {
            this.trace("send(msg=" + msg + ";remoteAddress=" + this.networkChannel.getRemoteAddress() + ")");
            this.networkChannel.sendMessage(msg);
            this.stopTiming(timingMsg, t);
            return;
        }
        catch (IOException ioe) {
            try {
                try {
                    if (msg instanceof TimeOffsetMessage) {
                        ((TimeOffsetMessage)msg).restamp(RemoteOSGiServiceImpl.nextXid());
                        this.networkChannel.sendMessage(msg);
                    } else {
                        this.networkChannel.sendMessage(msg);
                    }
                }
                catch (NotSerializableException nse) {
                    t = new RemoteOSGiException("Error sending " + msg, nse);
                    throw t;
                }
                catch (IOException ioe2) {
                    this.dispose();
                    t = new RemoteOSGiException("Network error", ioe2);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.stopTiming(timingMsg, t);
                throw throwable;
            }
        }
        this.stopTiming(timingMsg, t);
    }

    RemoteOSGiMessage handleMessage(RemoteOSGiMessage msg) throws RemoteOSGiException {
        this.trace("handleMessage(msg=" + msg + ";remoteAddress=" + this.networkChannel.getRemoteAddress() + ")");
        switch (msg.getFuncID()) {
            case 1: {
                LeaseMessage lease = (LeaseMessage)msg;
                this.processLease(lease);
                this.populateLease(lease, RemoteOSGiServiceImpl.getServices(this.networkChannel.getProtocol()), RemoteOSGiServiceImpl.getTopics());
                return lease;
            }
            case 2: {
                RequestServiceMessage reqSrv = (RequestServiceMessage)msg;
                String serviceID = reqSrv.getServiceID();
                RemoteServiceRegistration reg = this.getServiceRegistration(serviceID);
                DeliverServiceMessage m = reg.getDeliverServiceMessage();
                m.setXID(reqSrv.getXID());
                m.setServiceID(reqSrv.getServiceID());
                return m;
            }
            case 9: {
                LeaseUpdateMessage suMsg = (LeaseUpdateMessage)msg;
                String serviceID = suMsg.getServiceID();
                short stateUpdate = suMsg.getType();
                String serviceURI = this.getRemoteAddress().resolve("#" + serviceID).toString();
                switch (stateUpdate) {
                    case 0: {
                        String[] topicsRemoved;
                        String[] topicsAdded = suMsg.getPayload()[0];
                        if (topicsAdded instanceof List) {
                            topicsAdded = ((List)topicsAdded).toArray(new String[0]);
                        }
                        if ((topicsRemoved = suMsg.getPayload()[1]) instanceof List) {
                            topicsRemoved = ((List)topicsRemoved).toArray(new String[0]);
                        }
                        this.updateTopics(topicsAdded, topicsRemoved);
                        return null;
                    }
                    case 1: {
                        Dictionary properties = (Dictionary)suMsg.getPayload()[1];
                        this.sanitizeServiceProperties(properties, serviceURI);
                        RemoteServiceReferenceImpl ref = new RemoteServiceReferenceImpl((String[])suMsg.getPayload()[0], serviceID, properties, this);
                        this.remoteServices.put(serviceURI, ref);
                        RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(1, ref));
                        return null;
                    }
                    case 2: {
                        RemoteServiceReferenceImpl ref;
                        Dictionary properties = (Dictionary)suMsg.getPayload()[1];
                        this.sanitizeServiceProperties(properties, serviceURI);
                        ServiceRegistration reg = (ServiceRegistration)this.proxiedServices.get(serviceID);
                        if (reg != null) {
                            reg.setProperties(properties);
                        }
                        if ((ref = this.getRemoteReference(serviceURI)) == null && reg == null) {
                            return null;
                        }
                        ref.setProperties(properties);
                        RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(2, ref));
                        return null;
                    }
                    case 3: {
                        Bundle bundle;
                        if (this.networkChannel == null) {
                            return null;
                        }
                        RemoteServiceReference ref = (RemoteServiceReference)this.remoteServices.remove(serviceURI);
                        if (ref != null) {
                            RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(4, ref));
                        }
                        if ((bundle = (Bundle)this.proxyBundles.remove(serviceID)) != null) {
                            try {
                                bundle.uninstall();
                            }
                            catch (BundleException be) {
                                be.printStackTrace();
                            }
                            this.proxiedServices.remove(serviceID);
                            this.remoteServices.remove(serviceURI);
                        }
                        return null;
                    }
                }
                return null;
            }
            case 5: {
                RemoteCallMessage invMsg = (RemoteCallMessage)msg;
                try {
                    RemoteServiceRegistration serv = (RemoteServiceRegistration)this.localServices.get(invMsg.getServiceID());
                    if (serv == null) {
                        RemoteServiceRegistration reg = this.getServiceRegistration(invMsg.getServiceID());
                        if (reg == null) {
                            throw new IllegalStateException(String.valueOf(this.toString()) + "Could not get " + invMsg.getServiceID() + ", known services " + this.localServices);
                        }
                        serv = reg;
                    }
                    Object[] arguments = invMsg.getArgs();
                    int i = 0;
                    while (i < arguments.length) {
                        if (arguments[i] instanceof InputStreamHandle) {
                            arguments[i] = this.getInputStreamProxy((InputStreamHandle)arguments[i]);
                        } else if (arguments[i] instanceof OutputStreamHandle) {
                            arguments[i] = this.getOutputStreamProxy((OutputStreamHandle)arguments[i]);
                        }
                        ++i;
                    }
                    Method method = serv.getMethod(invMsg.getMethodSignature());
                    try {
                        Object result = method.invoke(serv.getServiceObject(), arguments);
                        RemoteCallResultMessage m = new RemoteCallResultMessage();
                        m.setXID(invMsg.getXID());
                        Class<?> returnType = method.getReturnType();
                        if (result instanceof InputStream) {
                            m.setResult(this.getInputStreamPlaceholder((InputStream)result));
                        } else if (result instanceof OutputStream) {
                            m.setResult(this.getOutputStreamPlaceholder((OutputStream)result));
                        } else if (serv.isOSGiAsync() && AsyncReturnUtil.isAsyncType(returnType)) {
                            m.setResult(AsyncReturnUtil.convertAsyncToReturn((Object)result, returnType, (long)serv.getOSGiTimeout()));
                        } else {
                            m.setResult(result);
                        }
                        return m;
                    }
                    catch (InvocationTargetException t) {
                        t.printStackTrace();
                        throw t.getTargetException();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    RemoteCallResultMessage m = new RemoteCallResultMessage();
                    m.setXID(invMsg.getXID());
                    m.setException(t);
                    return m;
                }
            }
            case 7: {
                RemoteEventMessage eventMsg = (RemoteEventMessage)msg;
                Dictionary properties = eventMsg.getProperties();
                Long remoteTs = (Long)properties.get("timestamp");
                if (remoteTs != null) {
                    properties.put("timestamp", this.getOffset().transform(remoteTs));
                }
                Event event = new Event(eventMsg.getTopic(), properties);
                if (RemoteOSGiServiceImpl.eventAdminTracker.getTrackingCount() > 0) {
                    ((EventAdmin)RemoteOSGiServiceImpl.eventAdminTracker.getService()).postEvent(event);
                } else {
                    System.err.println("Could not deliver received event: " + event + ". No EventAdmin available.");
                }
                return null;
            }
            case 8: {
                ((TimeOffsetMessage)msg).timestamp();
                return msg;
            }
            case 10: {
                StreamRequestMessage reqMsg = (StreamRequestMessage)msg;
                try {
                    Object stream = this.streams.get(reqMsg.getStreamID());
                    if (stream == null) {
                        throw new IllegalStateException("Could not get stream with ID " + reqMsg.getStreamID());
                    }
                    switch (reqMsg.getOp()) {
                        case 0: {
                            int result = ((InputStream)stream).read();
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)result);
                            return m;
                        }
                        case 1: {
                            byte[] b = new byte[reqMsg.getLenOrVal()];
                            int len = ((InputStream)stream).read(b, 0, reqMsg.getLenOrVal());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-2);
                            m.setLen(len);
                            if (len > 0) {
                                m.setData(b);
                            }
                            return m;
                        }
                        case 2: {
                            ((OutputStream)stream).write(reqMsg.getLenOrVal());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-4);
                            return m;
                        }
                        case 3: {
                            ((OutputStream)stream).write(reqMsg.getData());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-4);
                            return m;
                        }
                    }
                    throw new RemoteOSGiException("Unimplemented op code for stream request " + msg);
                }
                catch (IOException e) {
                    StreamResultMessage m = new StreamResultMessage();
                    m.setXID(reqMsg.getXID());
                    m.setResult((short)-3);
                    m.setException(e);
                    return m;
                }
            }
            case 13: {
                RequestBundleMessage reqB = (RequestBundleMessage)msg;
                try {
                    String serviceID = reqB.getServiceID();
                    RemoteServiceRegistration reg = this.getServiceRegistration(serviceID);
                    byte[] bytes = RemoteOSGiServiceImpl.getBundle(reg.getReference().getBundle());
                    DeliverBundlesMessage delB = new DeliverBundlesMessage();
                    delB.setXID(reqB.getXID());
                    delB.setDependencies(new byte[][]{bytes});
                    return delB;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }
            case 12: {
                RequestDependenciesMessage reqDeps = (RequestDependenciesMessage)msg;
                try {
                    byte[][] bundleBytes = RemoteOSGiServiceImpl.getBundlesForPackages(reqDeps.getPackages());
                    DeliverBundlesMessage delDeps = new DeliverBundlesMessage();
                    delDeps.setXID(reqDeps.getXID());
                    delDeps.setDependencies(bundleBytes);
                    return delDeps;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }
        }
        throw new RemoteOSGiException("Unimplemented message " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteOSGiMessage sendAndWait(RemoteOSGiMessage msg) {
        if (msg.getXID() == 0) {
            msg.setXID(RemoteOSGiServiceImpl.nextXid());
        }
        Integer xid = msg.getXID();
        WaitingCallback blocking = new WaitingCallback();
        Object object = this.callbacks;
        synchronized (object) {
            this.callbacks.put(xid, blocking);
        }
        this.send(msg);
        object = blocking;
        synchronized (object) {
            long timeout = System.currentTimeMillis() + (long)TIMEOUT;
            RemoteOSGiMessage result = blocking.getResult();
            try {
                while (result == null && this.networkChannel != null && System.currentTimeMillis() < timeout) {
                    blocking.wait(TIMEOUT);
                    result = blocking.getResult();
                }
            }
            catch (InterruptedException ie) {
                throw new RemoteOSGiException("Interrupted while waiting for callback", ie);
            }
            if (result != null) {
                return result;
            }
            if (this.networkChannel == null) {
                throw new RemoteOSGiException("Channel is closed");
            }
            throw new RemoteOSGiException("Method Invocation failed, timeout exceeded.");
        }
    }

    private RemoteServiceRegistration getServiceRegistration(String serviceID) {
        RemoteServiceRegistration reg = RemoteOSGiServiceImpl.getServiceRegistration(serviceID);
        this.localServices.put(serviceID, reg);
        return reg;
    }

    private void populateLease(LeaseMessage lease, RemoteServiceRegistration[] regs, String[] topics) {
        String[] serviceIDs = new String[regs.length];
        String[][] serviceInterfaces = new String[regs.length][];
        Dictionary[] serviceProperties = new Dictionary[regs.length];
        int i = 0;
        while (i < regs.length) {
            serviceIDs[i] = String.valueOf(regs[i].getServiceID());
            serviceInterfaces[i] = regs[i].getInterfaceNames();
            serviceProperties[i] = regs[i].getProperties();
            i = (short)(i + 1);
        }
        lease.setServiceIDs(serviceIDs);
        lease.setServiceInterfaces(serviceInterfaces);
        lease.setServiceProperties(serviceProperties);
        lease.setTopics(topics);
    }

    private RemoteServiceReference[] processLease(LeaseMessage lease) {
        String[] serviceIDs = lease.getServiceIDs();
        String[][] serviceInterfaces = lease.getServiceInterfaces();
        Dictionary[] serviceProperties = lease.getServiceProperties();
        RemoteServiceReference[] refs = new RemoteServiceReferenceImpl[serviceIDs.length];
        int i = 0;
        while (i < serviceIDs.length) {
            String serviceID = serviceIDs[i];
            String serviceURI = this.getRemoteAddress().resolve("#" + serviceID).toString();
            Dictionary properties = serviceProperties[i];
            this.sanitizeServiceProperties(properties, serviceURI);
            refs[i] = new RemoteServiceReferenceImpl(serviceInterfaces[i], serviceID, properties, this);
            this.remoteServices.put(((RemoteServiceReferenceImpl)refs[i]).getURI().toString(), refs[i]);
            RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(1, refs[i]));
            i = (short)(i + 1);
        }
        this.updateTopics(lease.getTopics(), new String[0]);
        return refs;
    }

    private void sanitizeServiceProperties(Dictionary properties, String serviceURI) {
        properties.put("service.uri", serviceURI);
        properties.remove("service.pid");
        properties.remove("service.remote.registration");
        properties.remove("org.eclipse.ecf.serviceRegistrationRemote");
    }

    private StreamResultMessage doStreamOp(StreamRequestMessage requestMsg) throws IOException {
        try {
            StreamResultMessage result = (StreamResultMessage)this.sendAndWait(requestMsg);
            if (result.causedException()) {
                throw result.getException();
            }
            return result;
        }
        catch (RemoteOSGiException e) {
            throw new RemoteOSGiException("Invocation of operation " + requestMsg.getOp() + " on stream " + requestMsg.getStreamID() + " failed.", e);
        }
    }

    private void updateTopics(String[] topicsAdded, String[] topicsRemoved) {
        if (this.handlerReg == null) {
            if (topicsAdded != null && topicsAdded.length > 0) {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                ((Dictionary)properties).put("event.topics", topicsAdded);
                ((Dictionary)properties).put("event.filter", NO_LOOPS);
                ((Dictionary)properties).put("internal", Boolean.TRUE);
                this.handlerReg = RemoteOSGiActivator.getActivator().getContext().registerService(EventHandler.class.getName(), (Object)new EventForwarder(), properties);
                this.remoteTopics.addAll(Arrays.asList(topicsAdded));
            }
        } else {
            if (topicsRemoved != null) {
                this.remoteTopics.removeAll(Arrays.asList(topicsRemoved));
            }
            if (topicsAdded != null) {
                this.remoteTopics.addAll(Arrays.asList(topicsAdded));
            }
            if (this.remoteTopics.size() == 0) {
                this.handlerReg.unregister();
                this.handlerReg = null;
            } else {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                ((Dictionary)properties).put("event.topics", this.remoteTopics.toArray(new String[this.remoteTopics.size()]));
                ((Dictionary)properties).put("event.filter", NO_LOOPS);
                ((Dictionary)properties).put("internal", Boolean.TRUE);
                this.handlerReg.setProperties(properties);
            }
        }
        if (RemoteOSGiServiceImpl.MSG_DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "NEW REMOTE TOPIC SPACE for " + this.getRemoteAddress() + " is " + this.remoteTopics);
        }
    }

    private InputStreamHandle getInputStreamPlaceholder(InputStream origIS) {
        InputStreamHandle sp = new InputStreamHandle(this.nextStreamID());
        this.streams.put(Integer.valueOf(sp.getStreamID()), origIS);
        return sp;
    }

    private InputStream getInputStreamProxy(InputStreamHandle placeholder) {
        return new InputStreamProxy(placeholder.getStreamID(), this);
    }

    private OutputStreamHandle getOutputStreamPlaceholder(OutputStream origOS) {
        OutputStreamHandle sp = new OutputStreamHandle(this.nextStreamID());
        this.streams.put(Integer.valueOf(sp.getStreamID()), origOS);
        return sp;
    }

    private OutputStream getOutputStreamProxy(OutputStreamHandle placeholder) {
        return new OutputStreamProxy(placeholder.getStreamID(), this);
    }

    private synchronized short nextStreamID() {
        if (this.nextStreamID == -1) {
            this.nextStreamID = 0;
        }
        this.nextStreamID = (short)(this.nextStreamID + 1);
        return this.nextStreamID;
    }

    private void closeStreams() {
        Object[] s = this.streams.values().toArray();
        try {
            int i = 0;
            while (i < s.length) {
                if (s[i] instanceof InputStream) {
                    ((InputStream)s[i]).close();
                } else if (s[i] instanceof OutputStream) {
                    ((OutputStream)s[i]).close();
                } else {
                    RemoteOSGiServiceImpl.log.log(2, "Object in input streams map was not an instance of a stream.");
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final class EventForwarder
    implements EventHandler {
        EventForwarder() {
        }

        public void handleEvent(Event event) {
            try {
                RemoteEventMessage msg = new RemoteEventMessage();
                msg.setTopic(event.getTopic());
                String[] propertyNames = event.getPropertyNames();
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                int i = 0;
                while (i < propertyNames.length) {
                    ((Dictionary)props).put(propertyNames[i], event.getProperty(propertyNames[i]));
                    ++i;
                }
                ((Dictionary)props).put("sender.uri", ChannelEndpointImpl.this.networkChannel.getLocalAddress());
                msg.setProperties(props);
                ChannelEndpointImpl.this.send(msg);
                if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                    RemoteOSGiServiceImpl.log.log(4, "Forwarding Event " + event);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class WaitingCallback
    implements AsyncCallback {
        private RemoteOSGiMessage result;

        WaitingCallback() {
        }

        @Override
        public synchronized void result(RemoteOSGiMessage msg) {
            this.result = msg;
            this.notifyAll();
        }

        synchronized RemoteOSGiMessage getResult() {
            return this.result;
        }
    }
}

