/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.EndpointDescriptionParser;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionReader
implements IEndpointDescriptionReader {
    @Override
    public org.osgi.service.remoteserviceadmin.EndpointDescription[] readEndpointDescriptions(InputStream input) throws IOException {
        return this.readAndMergeEndpointDescriptions(input, null);
    }

    public org.osgi.service.remoteserviceadmin.EndpointDescription[] readAndMergeEndpointDescriptions(InputStream ins, Map<String, Object> mergeProperties) throws IOException {
        EndpointDescriptionParser parser = new EndpointDescriptionParser();
        parser.parse(ins);
        List<EndpointDescriptionParser.EndpointDescription> parsedDescriptions = parser.getEndpointDescriptions();
        ArrayList<EndpointDescription> results = new ArrayList<EndpointDescription>();
        for (EndpointDescriptionParser.EndpointDescription ed : parsedDescriptions) {
            Map<String, Object> parsedProperties = ed.getProperties();
            Map<String, Object> mergedProperties = null;
            mergedProperties = mergeProperties != null ? this.mergeWithParsed(parsedProperties, mergeProperties) : parsedProperties;
            try {
                results.add(new EndpointDescription(mergedProperties));
            }
            catch (Exception e) {
                LogUtility.logError("readEndpointDescriptions", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionreader", this.getClass(), "Exception parsing endpoint description properties", e);
                throw new IOException("Error creating endpoint description: " + e.getMessage());
            }
        }
        return results.toArray(new EndpointDescription[results.size()]);
    }

    protected Map<String, Object> mergeWithParsed(Map<String, Object> parsedProperties, Map<String, Object> mergeProperties) {
        return PropertiesUtil.mergeProperties(parsedProperties, mergeProperties);
    }
}

