/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DiscoveredEndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DiscoveredEndpointDescriptionFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EDEFProperties;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IDiscoveredEndpointDescriptionFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ServiceInfoFactory;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EndpointDescriptionLocator
implements IEndpointDescriptionLocator {
    private static final String LOCAL_PROPERTIES_PROFILE = String.valueOf(EndpointDescriptionLocator.class.getName()) + ".localPropertiesProfile";
    private static final String DEFAULT_PROPERTIES_FILE = System.getProperty(String.valueOf(EndpointDescriptionLocator.class.getName()) + ".defaultPropertiesFilename", "default.properties");
    private static final String DEFAULT_PROPERTIES_URL = System.getProperty(String.valueOf(EndpointDescriptionLocator.class.getName()) + ".defaultPropertiesUrl");
    private BundleContext context;
    private IExecutor executor;
    private ServiceInfoFactory serviceInfoFactory;
    private ServiceRegistration defaultServiceInfoFactoryRegistration;
    private Object serviceInfoFactoryTrackerLock = new Object();
    private ServiceTracker serviceInfoFactoryTracker;
    private DiscoveredEndpointDescriptionFactory defaultEndpointDescriptionFactory;
    private ServiceRegistration defaultEndpointDescriptionFactoryRegistration;
    private Object endpointDescriptionFactoryTrackerLock = new Object();
    private ServiceTracker endpointDescriptionFactoryTracker;
    private ServiceRegistration defaultEndpointDescriptionReaderRegistration;
    private EventManager eventManager;
    private ListenerQueue eventQueue;
    private ServiceTracker locatorServiceTracker;
    private Map<IDiscoveryLocator, LocatorServiceListener> locatorListeners;
    private ServiceTracker endpointListenerTracker;
    private ServiceTracker endpointEventListenerTracker;
    private ServiceTracker advertiserTracker;
    private Object advertiserTrackerLock = new Object();
    private BundleTracker bundleTracker;
    private EndpointDescriptionBundleTrackerCustomizer bundleTrackerCustomizer;
    private String frameworkUUID;
    private ServiceRegistration<IEndpointDescriptionLocator> endpointLocatorReg;
    private Object endpointListenerServiceTrackerLock = new Object();
    private Object endpointEventListenerServiceTrackerLock = new Object();
    private Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> edToServiceIDMap = new HashMap<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID>();

    private String getFrameworkUUID() {
        return this.frameworkUUID;
    }

    public EndpointDescriptionLocator(BundleContext context) {
        this.context = context;
        this.executor = new ThreadsExecutor();
        this.frameworkUUID = Activator.getDefault().getFrameworkUUID();
    }

    public void start() {
        Properties properties = new Properties();
        properties.put("service.ranking", (Object)Integer.MIN_VALUE);
        this.serviceInfoFactory = new ServiceInfoFactory();
        this.defaultServiceInfoFactoryRegistration = this.context.registerService(IServiceInfoFactory.class.getName(), (Object)this.serviceInfoFactory, (Dictionary)properties);
        this.defaultEndpointDescriptionFactory = new DiscoveredEndpointDescriptionFactory();
        this.defaultEndpointDescriptionFactoryRegistration = this.context.registerService(IDiscoveredEndpointDescriptionFactory.class.getName(), (Object)this.defaultEndpointDescriptionFactory, (Dictionary)properties);
        this.defaultEndpointDescriptionReaderRegistration = this.context.registerService(IEndpointDescriptionReader.class.getName(), (Object)new EndpointDescriptionReader(), (Dictionary)properties);
        ThreadGroup eventGroup = new ThreadGroup("RSA EndpointDescriptionLocator ThreadGroup");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("RSA EndpointDescriptionLocator Dispatcher", eventGroup);
        this.eventQueue = new ListenerQueue(this.eventManager);
        CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
        listeners.put((Object)this, (Object)this);
        this.eventQueue.queueListeners(listeners.entrySet(), new EventDispatcher(){

            public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
                block12: {
                    String logMethodName = "dispatchEvent";
                    if (eventObject instanceof EndpointListenerEvent) {
                        EndpointListenerEvent event = (EndpointListenerEvent)eventObject;
                        EndpointListener endpointListener = event.getEndpointListener();
                        org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription = event.getEndointDescription();
                        String matchingFilter = event.getMatchingFilter();
                        try {
                            boolean discovered = event.isDiscovered();
                            EndpointDescriptionLocator.this.trace("endpointListener.discovered=" + discovered + " ", "fwk=" + EndpointDescriptionLocator.this.getFrameworkUUID() + ", endpointListener=" + endpointListener + ", endpointDescription=" + endpointDescription + ", matchingFilter=" + matchingFilter);
                            if (discovered) {
                                endpointListener.endpointAdded(endpointDescription, matchingFilter);
                                break block12;
                            }
                            endpointListener.endpointRemoved(endpointDescription, matchingFilter);
                        }
                        catch (Exception e) {
                            String message = "Exception in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                        }
                        catch (LinkageError e) {
                            String message = "LinkageError in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                        }
                        catch (AssertionError e) {
                            String message = "AssertionError in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, (Throwable)((Object)e));
                        }
                    } else if (eventObject instanceof EndpointEventListenerEvent) {
                        EndpointEventListenerEvent event = (EndpointEventListenerEvent)eventObject;
                        EndpointEventListener endpointEventListener = event.getEndpointEventListener();
                        EndpointEvent endpointEvent = event.getEndpointEvent();
                        String matchingFilter = event.getMatchingFilter();
                        try {
                            EndpointDescriptionLocator.this.trace("endpointEventListener.discovered=" + EndpointDescriptionLocator.this.getEndpointEventTypeAsString(endpointEvent.getType()) + " ", "fwk=" + EndpointDescriptionLocator.this.getFrameworkUUID() + ", endpointEventListener=" + endpointEventListener + ", endpointEvent=" + endpointEvent + ", matchingFilter=" + matchingFilter);
                            endpointEventListener.endpointChanged(endpointEvent, matchingFilter);
                        }
                        catch (Exception e) {
                            String message = "Exception in EndpointEventListener listener=" + endpointEventListener + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                        }
                        catch (LinkageError e) {
                            String message = "LinkageError in EndpointEventListener listener=" + endpointEventListener + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                        }
                        catch (AssertionError e) {
                            String message = "AssertionError in EndpointEventListener listener=" + endpointEventListener + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                            EndpointDescriptionLocator.this.logError("dispatchEvent", message, (Throwable)((Object)e));
                        }
                    }
                }
            }
        });
        this.endpointListenerTracker = new ServiceTracker(this.context, EndpointListener.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                if (EndpointDescriptionLocator.this.context == null) {
                    return null;
                }
                EndpointListener listener = (EndpointListener)EndpointDescriptionLocator.this.context.getService(reference);
                if (listener == null) {
                    return null;
                }
                Set<org.osgi.service.remoteserviceadmin.EndpointDescription> allDiscoveredEndpointDescriptions = EndpointDescriptionLocator.this.getEDs();
                for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : allDiscoveredEndpointDescriptions) {
                    EndpointListenerHolder[] endpointListenerHolders = EndpointDescriptionLocator.this.getMatchingEndpointListenerHolders(new ServiceReference[]{reference}, ed);
                    if (endpointListenerHolders == null) continue;
                    int i = 0;
                    while (i < endpointListenerHolders.length) {
                        EndpointDescriptionLocator.this.queueEndpointDescription(endpointListenerHolders[i].getListener(), endpointListenerHolders[i].getDescription(), endpointListenerHolders[i].getMatchingFilter(), true);
                        ++i;
                    }
                }
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
            }
        });
        this.endpointListenerTracker.open();
        this.endpointEventListenerTracker = new ServiceTracker(this.context, EndpointEventListener.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                if (EndpointDescriptionLocator.this.context == null) {
                    return null;
                }
                EndpointEventListener listener = (EndpointEventListener)EndpointDescriptionLocator.this.context.getService(reference);
                if (listener == null) {
                    return null;
                }
                Set<org.osgi.service.remoteserviceadmin.EndpointDescription> allDiscoveredEndpointDescriptions = EndpointDescriptionLocator.this.getEDs();
                for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : allDiscoveredEndpointDescriptions) {
                    EndpointEventListenerHolder[] endpointEventListenerHolders = EndpointDescriptionLocator.this.getMatchingEndpointEventListenerHolders(new ServiceReference[]{reference}, ed, 1);
                    if (endpointEventListenerHolders == null) continue;
                    int i = 0;
                    while (i < endpointEventListenerHolders.length) {
                        EndpointDescriptionLocator.this.queueEndpointDescription(endpointEventListenerHolders[i].getListener(), endpointEventListenerHolders[i].getDescription(), endpointEventListenerHolders[i].getMatchingFilter(), endpointEventListenerHolders[i].getType());
                        ++i;
                    }
                }
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
            }
        });
        this.endpointEventListenerTracker.open();
        this.locatorListeners = new HashMap<IDiscoveryLocator, LocatorServiceListener>();
        this.locatorServiceTracker = new ServiceTracker(this.context, IDiscoveryLocator.class.getName(), (ServiceTrackerCustomizer)new LocatorTrackerCustomizer());
        this.locatorServiceTracker.open();
        this.bundleTrackerCustomizer = new EndpointDescriptionBundleTrackerCustomizer();
        this.bundleTracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)this.bundleTrackerCustomizer);
        this.bundleTracker.open();
        this.endpointLocatorReg = this.context.registerService(IEndpointDescriptionLocator.class, (Object)this, null);
    }

    private void logError(String methodName, String message, Throwable e) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message, e);
    }

    private void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.endpointLocatorReg != null) {
            this.endpointLocatorReg.unregister();
            this.endpointLocatorReg = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.bundleTrackerCustomizer != null) {
            this.bundleTrackerCustomizer.close();
            this.bundleTrackerCustomizer = null;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            for (IDiscoveryLocator l : this.locatorListeners.keySet()) {
                LocatorServiceListener locatorListener = this.locatorListeners.get(l);
                if (locatorListener == null) continue;
                l.removeServiceListener((IServiceListener)locatorListener);
                locatorListener.close();
            }
            this.locatorListeners.clear();
        }
        Object[] locators = this.locatorServiceTracker.getServices();
        if (locators != null) {
            int i = 0;
            while (i < locators.length) {
                this.shutdownLocator((IDiscoveryLocator)locators[i]);
                ++i;
            }
        }
        if (this.endpointListenerTracker != null) {
            this.endpointListenerTracker.close();
            this.endpointListenerTracker = null;
        }
        if (this.endpointEventListenerTracker != null) {
            this.endpointEventListenerTracker.close();
            this.endpointEventListenerTracker = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map2 = this.endpointDescriptionFactoryTrackerLock;
        synchronized (map2) {
            if (this.endpointDescriptionFactoryTracker != null) {
                this.endpointDescriptionFactoryTracker.close();
                this.endpointDescriptionFactoryTracker = null;
            }
        }
        if (this.defaultEndpointDescriptionFactoryRegistration != null) {
            this.defaultEndpointDescriptionFactoryRegistration.unregister();
            this.defaultEndpointDescriptionFactoryRegistration = null;
        }
        if (this.defaultEndpointDescriptionFactory != null) {
            this.defaultEndpointDescriptionFactory.close();
            this.defaultEndpointDescriptionFactory = null;
        }
        map2 = this.serviceInfoFactoryTrackerLock;
        synchronized (map2) {
            if (this.serviceInfoFactoryTracker != null) {
                this.serviceInfoFactoryTracker.close();
                this.serviceInfoFactoryTracker = null;
            }
        }
        if (this.defaultServiceInfoFactoryRegistration != null) {
            this.defaultServiceInfoFactoryRegistration.unregister();
            this.defaultServiceInfoFactoryRegistration = null;
        }
        if (this.serviceInfoFactory != null) {
            this.serviceInfoFactory.close();
            this.serviceInfoFactory = null;
        }
        if (this.defaultEndpointDescriptionReaderRegistration != null) {
            this.defaultEndpointDescriptionReaderRegistration.unregister();
            this.defaultEndpointDescriptionReaderRegistration = null;
        }
        if (this.locatorServiceTracker != null) {
            this.locatorServiceTracker.close();
            this.locatorServiceTracker = null;
        }
        map2 = this.advertiserTrackerLock;
        synchronized (map2) {
            if (this.advertiserTracker != null) {
                this.advertiserTracker.close();
                this.advertiserTracker = null;
            }
        }
        map2 = this.edToServiceIDMap;
        synchronized (map2) {
            this.edToServiceIDMap.clear();
        }
        this.executor = null;
        this.context = null;
    }

    public IDiscoveryAdvertiser[] getDiscoveryAdvertisers() {
        return AccessController.doPrivileged(new PrivilegedAction<IDiscoveryAdvertiser[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDiscoveryAdvertiser[] run() {
                Object object = EndpointDescriptionLocator.this.advertiserTrackerLock;
                synchronized (object) {
                    if (EndpointDescriptionLocator.this.advertiserTracker == null) {
                        EndpointDescriptionLocator.this.advertiserTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IDiscoveryAdvertiser.class.getName(), null);
                        EndpointDescriptionLocator.this.advertiserTracker.open();
                    }
                }
                ServiceReference[] advertiserRefs = EndpointDescriptionLocator.this.advertiserTracker.getServiceReferences();
                if (advertiserRefs == null) {
                    return null;
                }
                ArrayList<IDiscoveryAdvertiser> results = new ArrayList<IDiscoveryAdvertiser>();
                int i = 0;
                while (i < advertiserRefs.length) {
                    results.add((IDiscoveryAdvertiser)EndpointDescriptionLocator.this.context.getService(advertiserRefs[i]));
                    ++i;
                }
                return results.toArray(new IDiscoveryAdvertiser[results.size()]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLocator(IDiscoveryLocator locator) {
        if (this.context == null) {
            return;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            LocatorServiceListener locatorListener = new LocatorServiceListener(locator);
            this.locatorListeners.put(locator, locatorListener);
            this.processInitialLocatorServices(locator, locatorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownLocator(IDiscoveryLocator locator) {
        if (locator == null || this.context == null) {
            return;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            LocatorServiceListener locatorListener = this.locatorListeners.remove(locator);
            if (locatorListener != null) {
                locatorListener.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEndpointDescription(EndpointEventListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchingFilter, int eventType) {
        if (this.eventQueue == null) {
            return;
        }
        ListenerQueue listenerQueue = this.eventQueue;
        synchronized (listenerQueue) {
            this.eventQueue.dispatchEventAsynchronous(0, (Object)new EndpointEventListenerEvent(listener, new EndpointEvent(eventType, endpointDescription), matchingFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEndpointDescription(EndpointListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchingFilters, boolean discovered) {
        if (this.eventQueue == null) {
            return;
        }
        ListenerQueue listenerQueue = this.eventQueue;
        synchronized (listenerQueue) {
            this.eventQueue.dispatchEventAsynchronous(0, (Object)new EndpointListenerEvent(listener, endpointDescription, matchingFilters, discovered));
        }
    }

    void queueEndpointEvent(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, int type) {
        EndpointEventListenerHolder[] endpointEventListenerHolders = this.getMatchingEndpointEventListenerHolders(endpointDescription, type);
        if (endpointEventListenerHolders != null) {
            int i = 0;
            while (i < endpointEventListenerHolders.length) {
                this.queueEndpointDescription(endpointEventListenerHolders[i].getListener(), endpointEventListenerHolders[i].getDescription(), endpointEventListenerHolders[i].getMatchingFilter(), endpointEventListenerHolders[i].getType());
                ++i;
            }
        } else {
            LogUtility.logWarning("queueEndpointDescription", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "No matching EndpointEventListeners found for event type" + this.getEndpointEventTypeAsString(type) + " endpointDescription=" + endpointDescription);
        }
    }

    String getEndpointEventTypeAsString(int eventType) {
        if (eventType == 1) {
            return "added";
        }
        if (eventType == 4) {
            return "modified";
        }
        if (eventType == 8) {
            return "modified endmatch";
        }
        if (eventType == 2) {
            return "removed";
        }
        return "unknown";
    }

    void queueEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean discovered) {
        EndpointListenerHolder[] endpointListenerHolders = this.getMatchingEndpointListenerHolders(endpointDescription);
        if (endpointListenerHolders != null) {
            int i = 0;
            while (i < endpointListenerHolders.length) {
                this.queueEndpointDescription(endpointListenerHolders[i].getListener(), endpointListenerHolders[i].getDescription(), endpointListenerHolders[i].getMatchingFilter(), discovered);
                ++i;
            }
        }
    }

    private void processInitialLocatorServices(final IDiscoveryLocator locator, final LocatorServiceListener locatorListener) {
        IProgressRunnable runnable = new IProgressRunnable(){

            public Object run(IProgressMonitor arg0) throws Exception {
                IServiceInfo[] serviceInfos = null;
                try {
                    serviceInfos = locator.getServices();
                }
                catch (Exception e) {
                    EndpointDescriptionLocator.this.logError("processInitialLocatorServices", "Exception in locator.getServices()", e);
                }
                if (serviceInfos != null) {
                    int i = 0;
                    while (i < serviceInfos.length) {
                        locatorListener.handleService(serviceInfos[i], true);
                        ++i;
                    }
                }
                return null;
            }
        };
        this.executor.execute(runnable, null);
    }

    void shutdownLocators() {
        Object[] locators = this.locatorServiceTracker.getServices();
        if (locators != null) {
            int i = 0;
            while (i < locators.length) {
                this.shutdownLocator((IDiscoveryLocator)locators[i]);
                ++i;
            }
        }
    }

    public IServiceInfoFactory getServiceInfoFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<IServiceInfoFactory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IServiceInfoFactory run() {
                Object object = EndpointDescriptionLocator.this.serviceInfoFactoryTrackerLock;
                synchronized (object) {
                    if (EndpointDescriptionLocator.this.serviceInfoFactoryTracker == null) {
                        EndpointDescriptionLocator.this.serviceInfoFactoryTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IServiceInfoFactory.class.getName(), null);
                        EndpointDescriptionLocator.this.serviceInfoFactoryTracker.open();
                    }
                }
                return (IServiceInfoFactory)EndpointDescriptionLocator.this.serviceInfoFactoryTracker.getService();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDiscoveredEndpointDescriptionFactory getDiscoveredEndpointDescriptionFactory() {
        Object object = this.endpointDescriptionFactoryTrackerLock;
        synchronized (object) {
            block5: {
                if (this.context != null) break block5;
                return null;
            }
            if (this.endpointDescriptionFactoryTracker == null) {
                this.endpointDescriptionFactoryTracker = new ServiceTracker(this.context, IDiscoveredEndpointDescriptionFactory.class.getName(), null);
                this.endpointDescriptionFactoryTracker.open();
            }
            return (IDiscoveredEndpointDescriptionFactory)this.endpointDescriptionFactoryTracker.getService();
        }
    }

    protected EndpointListenerHolder[] getMatchingEndpointListenerHolders(final org.osgi.service.remoteserviceadmin.EndpointDescription description) {
        return AccessController.doPrivileged(new PrivilegedAction<EndpointListenerHolder[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EndpointListenerHolder[] run() {
                Object object = EndpointDescriptionLocator.this.endpointListenerServiceTrackerLock;
                synchronized (object) {
                    return EndpointDescriptionLocator.this.getMatchingEndpointListenerHolders(EndpointDescriptionLocator.this.endpointListenerTracker.getServiceReferences(), description);
                }
            }
        });
    }

    protected EndpointEventListenerHolder[] getMatchingEndpointEventListenerHolders(final org.osgi.service.remoteserviceadmin.EndpointDescription description, final int type) {
        return AccessController.doPrivileged(new PrivilegedAction<EndpointEventListenerHolder[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EndpointEventListenerHolder[] run() {
                Object object = EndpointDescriptionLocator.this.endpointEventListenerServiceTrackerLock;
                synchronized (object) {
                    return EndpointDescriptionLocator.this.getMatchingEndpointEventListenerHolders(EndpointDescriptionLocator.this.endpointEventListenerTracker.getServiceReferences(), description, type);
                }
            }
        });
    }

    public EndpointEventListenerHolder[] getMatchingEndpointEventListenerHolders(ServiceReference[] refs, org.osgi.service.remoteserviceadmin.EndpointDescription description, int type) {
        if (refs == null) {
            return null;
        }
        ArrayList<EndpointEventListenerHolder> results = new ArrayList<EndpointEventListenerHolder>();
        int i = 0;
        while (i < refs.length) {
            String matchingFilter;
            List filters;
            EndpointEventListener listener = (EndpointEventListener)this.context.getService(refs[i]);
            if (listener != null && (filters = PropertiesUtil.getStringPlusProperty(this.getMapFromProperties(refs[i]), "endpoint.listener.scope")).size() > 0 && (matchingFilter = this.isMatch(description, filters)) != null) {
                results.add(new EndpointEventListenerHolder(listener, description, matchingFilter, type));
            }
            ++i;
        }
        return results.toArray(new EndpointEventListenerHolder[results.size()]);
    }

    public EndpointListenerHolder[] getMatchingEndpointListenerHolders(ServiceReference[] refs, org.osgi.service.remoteserviceadmin.EndpointDescription description) {
        if (refs == null) {
            return null;
        }
        ArrayList<EndpointListenerHolder> results = new ArrayList<EndpointListenerHolder>();
        int i = 0;
        while (i < refs.length) {
            String matchingFilter;
            List filters;
            EndpointListener listener = (EndpointListener)this.context.getService(refs[i]);
            if (listener != null && (filters = PropertiesUtil.getStringPlusProperty(this.getMapFromProperties(refs[i]), "endpoint.listener.scope")).size() > 0 && (matchingFilter = this.isMatch(description, filters)) != null) {
                results.add(new EndpointListenerHolder(listener, description, matchingFilter));
            }
            ++i;
        }
        return results.toArray(new EndpointListenerHolder[results.size()]);
    }

    private String isMatch(org.osgi.service.remoteserviceadmin.EndpointDescription description, List<String> filters) {
        for (String filter : filters) {
            if (filter == null || "".equals(filter)) continue;
            try {
                if (!description.matches(filter)) continue;
                return filter;
            }
            catch (IllegalArgumentException e) {
                this.logError("isMatch", "invalid endpoint listener filter=" + filters, e);
            }
        }
        return null;
    }

    private Map getMapFromProperties(ServiceReference ref) {
        TreeMap<String, Object> results = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] keys = ref.getPropertyKeys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                results.put(keys[i], ref.getProperty(keys[i]));
                ++i;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<org.osgi.service.remoteserviceadmin.EndpointDescription> getEDs() {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            return this.edToServiceIDMap.keySet();
        }
    }

    protected URL getPropsURLFromEDFileURL(URL edFileURL) {
        int dotIndex;
        String localPropertiesProfile = System.getProperty(LOCAL_PROPERTIES_PROFILE);
        String profileSuffix = localPropertiesProfile != null ? "-" + localPropertiesProfile : "";
        String edFile = edFileURL.getFile();
        int slashIndex = edFile.lastIndexOf(47);
        String parentPath = "";
        if (slashIndex > -1) {
            parentPath = String.valueOf(edFile.substring(0, slashIndex)) + "/";
            edFile = edFile.substring(slashIndex + 1);
        }
        if ((dotIndex = edFile.lastIndexOf(46)) > 0) {
            edFile = edFile.substring(0, dotIndex);
        }
        try {
            return new URL(edFileURL.getProtocol(), edFileURL.getHost(), edFileURL.getPort(), String.valueOf(parentPath) + edFile + profileSuffix + ".properties");
        }
        catch (MalformedURLException e) {
            LogUtility.logError("getPropsURLFromEDFileURL", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "URL could not be used to load properties file");
            return null;
        }
    }

    protected URL getDefaultPropsURLFromEDFileURL(URL edFileURL) {
        try {
            URL url = null;
            if (DEFAULT_PROPERTIES_URL != null) {
                url = new URL(DEFAULT_PROPERTIES_URL);
            } else {
                String edFile = edFileURL.getFile();
                int slashIndex = edFile.lastIndexOf(47);
                String parentPath = "";
                if (slashIndex > -1) {
                    parentPath = String.valueOf(edFile.substring(0, slashIndex)) + "/";
                }
                url = new URL(edFileURL.getProtocol(), edFileURL.getHost(), edFileURL.getPort(), String.valueOf(parentPath) + DEFAULT_PROPERTIES_FILE);
            }
            return url;
        }
        catch (MalformedURLException e) {
            LogUtility.logError("getDefaultPropsURLFromEDFileURL", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "URL could not be used to load properties file");
            return null;
        }
    }

    protected EDEFProperties loadProperties(URL url) throws IOException {
        EDEFProperties result = new EDEFProperties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream ins = url.openStream();){
            result.load(ins);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    protected Map<String, Object> processProperties(EDEFProperties props) {
        return props.getEDEFPropertiesAsMap();
    }

    protected Map<String, Object> loadDefaultProperties(Map<String, Object> props, URL url) {
        try {
            props = PropertiesUtil.mergePropertiesRaw(props, this.processProperties(this.loadProperties(url)));
            this.trace("loadDefaultProperties", "loaded default.properties file=" + url.getFile() + " loaded properties=" + props);
        }
        catch (IOException e) {
            LogUtility.logWarning("findOverrideProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "Could not load default properties=" + url);
        }
        return props;
    }

    protected Map<String, Object> loadAllDefaultProperties(URL url) {
        Map<String, Object> props = new TreeMap<String, Object>();
        URL rootUrl = null;
        try {
            rootUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
        }
        catch (MalformedURLException e) {
            LogUtility.logError("loadAllDefaultProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "MalformedUrlException creating rootUrl from url=" + url);
            return props;
        }
        String pathSegment = "";
        Iterator<Path> pathIterator = Paths.get(url.getPath(), new String[0]).iterator();
        do {
            String newPath = String.valueOf(pathSegment) + "/" + DEFAULT_PROPERTIES_FILE;
            try {
                props = this.loadDefaultProperties(props, new URL(rootUrl, newPath));
            }
            catch (MalformedURLException e) {
                LogUtility.logError("loadAllDefaultProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "MalformedUrlException creating rootUrl from url=" + url);
                return props;
            }
            pathSegment = String.valueOf(pathSegment) + "/" + pathIterator.next();
        } while (pathIterator.hasNext());
        return props;
    }

    protected Map<String, Object> findOverrideProperties(Bundle bundle, URL fileURL) {
        Map<String, Object> defaultProperties = this.loadAllDefaultProperties(fileURL);
        this.trace("findOverrideProperties", "merged default.properties=" + defaultProperties);
        Map<String, Object> overrideProps = new HashMap<String, Object>();
        URL propsFileURL = this.getPropsURLFromEDFileURL(fileURL);
        if (propsFileURL != null) {
            this.trace("handleEndpointDescriptionFile", "Attemping to load <file>.properties.  BundleId=" + bundle.getBundleId() + " propsFileURL=" + propsFileURL);
            try {
                overrideProps = PropertiesUtil.mergePropertiesRaw(defaultProperties, this.processProperties(this.loadProperties(propsFileURL)));
                this.trace("findOverrideProperties", "loaded override properties file=" + fileURL.getFile() + " merged Properties=" + overrideProps);
            }
            catch (IOException e) {
                LogUtility.logWarning("findOverrideProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "Could not load properties fileUrl=" + propsFileURL + ",fileUrl=" + fileURL.getFile());
            }
        }
        return !overrideProps.isEmpty() ? overrideProps : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    org.osgi.service.remoteserviceadmin.EndpointDescription findED(IServiceID serviceID) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : this.getEDs()) {
                IServiceID sid = this.edToServiceIDMap.get(ed);
                if (sid == null || !sid.getLocation().equals(serviceID.getLocation())) continue;
                return ed;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateED(org.osgi.service.remoteserviceadmin.EndpointDescription existing, org.osgi.service.remoteserviceadmin.EndpointDescription update, IServiceID updateServiceID) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            this.edToServiceIDMap.remove(existing);
            this.edToServiceIDMap.put(update, updateServiceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addED(org.osgi.service.remoteserviceadmin.EndpointDescription ed, IServiceID serviceID) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            this.edToServiceIDMap.put(ed, serviceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeED(org.osgi.service.remoteserviceadmin.EndpointDescription ed) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            this.edToServiceIDMap.remove(ed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsED(org.osgi.service.remoteserviceadmin.EndpointDescription ed) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            return this.getEDs().contains(ed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<org.osgi.service.remoteserviceadmin.EndpointDescription> getEDsForNamespace(Namespace namespace) {
        HashSet<org.osgi.service.remoteserviceadmin.EndpointDescription> results = new HashSet<org.osgi.service.remoteserviceadmin.EndpointDescription>();
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : this.edToServiceIDMap.keySet()) {
                IServiceID svcID = this.edToServiceIDMap.get(ed);
                if (svcID == null || !svcID.getNamespace().getName().equals(namespace.getName())) continue;
                results.add(ed);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServiceID getNetworkDiscoveredServiceID(EndpointDescription endpointDescription) {
        Map<org.osgi.service.remoteserviceadmin.EndpointDescription, IServiceID> map = this.edToServiceIDMap;
        synchronized (map) {
            return this.edToServiceIDMap.get((Object)endpointDescription);
        }
    }

    void handleEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean discovered) {
        if (discovered) {
            this.queueEndpointEvent(endpointDescription, 1);
            this.queueEndpointDescription(endpointDescription, discovered);
        } else {
            this.queueEndpointEvent(endpointDescription, 2);
            this.queueEndpointDescription(endpointDescription, discovered);
        }
    }

    @Override
    public void discoverEndpoint(EndpointDescription endpointDescription) {
        this.addED(endpointDescription, null);
        this.queueEndpointEvent(endpointDescription, 1);
    }

    @Override
    public void updateEndpoint(EndpointDescription endpointDescription) {
        this.updateED(endpointDescription, endpointDescription, null);
        this.queueEndpointEvent(endpointDescription, 4);
    }

    @Override
    public void undiscoverEndpoint(EndpointDescription endpointDescription) {
        this.removeED(endpointDescription);
        this.queueEndpointEvent(endpointDescription, 2);
    }

    @Override
    public EndpointDescription[] getDiscoveredEndpoints() {
        ArrayList<EndpointDescription> results = new ArrayList<EndpointDescription>();
        for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : this.getEDs()) {
            if (!(ed instanceof EndpointDescription)) continue;
            results.add((EndpointDescription)ed);
        }
        return results.toArray(new EndpointDescription[results.size()]);
    }

    class EndpointDescriptionBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private static final String REMOTESERVICE_MANIFESTHEADER = "Remote-Service";
        private static final String XML_FILE_PATTERN = "*.xml";
        private Map<Long, Collection<org.osgi.service.remoteserviceadmin.EndpointDescription>> bundleDescriptionMap = Collections.synchronizedMap(new HashMap());
        private Object endpointDescriptionReaderTrackerLock = new Object();
        private ServiceTracker endpointDescriptionReaderTracker;

        EndpointDescriptionBundleTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IEndpointDescriptionReader getEndpointDescriptionReader() {
            Object object = this.endpointDescriptionReaderTrackerLock;
            synchronized (object) {
                if (this.endpointDescriptionReaderTracker == null) {
                    this.endpointDescriptionReaderTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IEndpointDescriptionReader.class.getName(), null);
                    this.endpointDescriptionReaderTracker.open();
                }
            }
            return (IEndpointDescriptionReader)this.endpointDescriptionReaderTracker.getService();
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            String[] paths;
            String remoteServicesHeaderValue;
            if (EndpointDescriptionLocator.this.context != null && (remoteServicesHeaderValue = (String)bundle.getHeaders().get(REMOTESERVICE_MANIFESTHEADER)) != null && (paths = remoteServicesHeaderValue.split(",")) != null) {
                int i = 0;
                while (i < paths.length) {
                    this.handleEndpointDescriptionPath(bundle, paths[i].trim());
                    ++i;
                }
            }
            return bundle;
        }

        protected void handleEndpointDescriptionPath(Bundle bundle, String remoteServicesHeaderValue) {
            if ("".equals(remoteServicesHeaderValue)) {
                return;
            }
            Enumeration e = null;
            if (remoteServicesHeaderValue.endsWith("/")) {
                e = bundle.findEntries(remoteServicesHeaderValue, XML_FILE_PATTERN, false);
            } else {
                int lastSlashIndex = remoteServicesHeaderValue.lastIndexOf(47);
                if (lastSlashIndex == -1) {
                    e = bundle.findEntries("/", remoteServicesHeaderValue, false);
                } else {
                    String path = remoteServicesHeaderValue.substring(0, lastSlashIndex);
                    if ("".equals(path)) {
                        path = "/";
                    }
                    String filePattern = remoteServicesHeaderValue.substring(lastSlashIndex + 1);
                    e = bundle.findEntries(path, filePattern, false);
                }
            }
            ArrayList<org.osgi.service.remoteserviceadmin.EndpointDescription> endpointDescriptions = new ArrayList<org.osgi.service.remoteserviceadmin.EndpointDescription>();
            if (e != null) {
                while (e.hasMoreElements()) {
                    org.osgi.service.remoteserviceadmin.EndpointDescription[] eps = this.handleEndpointDescriptionFile(bundle, (URL)e.nextElement());
                    if (eps == null) continue;
                    int i = 0;
                    while (i < eps.length) {
                        endpointDescriptions.add(eps[i]);
                        ++i;
                    }
                }
            } else {
                this.logError("handleEndpointDescriptionPath", "EDEF file(s) not found.  The EDEF files given by Remote-Service header value='" + remoteServicesHeaderValue + "' in bundle='" + bundle.getSymbolicName() + "' cannot be found for remote services discovery", new FileNotFoundException("name=" + remoteServicesHeaderValue));
            }
            if (endpointDescriptions.size() > 0) {
                this.bundleDescriptionMap.put(bundle.getBundleId(), endpointDescriptions);
                for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : endpointDescriptions) {
                    EndpointDescriptionLocator.this.addED(ed, null);
                    EndpointDescriptionLocator.this.handleEndpointDescription(ed, true);
                }
            }
        }

        protected org.osgi.service.remoteserviceadmin.EndpointDescription[] handleEndpointDescriptionFile(Bundle bundle, URL fileURL) {
            EndpointDescriptionLocator.this.trace("handleEndpointDescriptionFile", "edef file detected.  BundleId=" + bundle.getBundleId() + " fileURL=" + fileURL + " found");
            InputStream ins = null;
            Map<String, Object> mergeProperties = EndpointDescriptionLocator.this.findOverrideProperties(bundle, fileURL);
            try {
                IEndpointDescriptionReader endpointDescriptionReader = this.getEndpointDescriptionReader();
                if (endpointDescriptionReader == null) {
                    throw new NullPointerException("No endpointDescriptionReader available for handleEndpointDescriptionFile fileURL=" + fileURL);
                }
                ins = fileURL.openStream();
                org.osgi.service.remoteserviceadmin.EndpointDescription[] endpointDescriptionArray = endpointDescriptionReader.readEndpointDescriptions(ins, mergeProperties);
                return endpointDescriptionArray;
            }
            catch (Throwable e) {
                this.logError("handleEndpointDescriptionFile", "Exception creating endpoint descriptions from fileURL=" + fileURL, e);
                return null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.logError("handleEndpointDescriptionFile", "Exception closing endpointDescription input fileURL=" + fileURL, e);
                    }
                }
            }
        }

        private void logError(String method, String message, Throwable t) {
            LogUtility.logError(method, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), (IStatus)new Status(4, "org.eclipse.ecf.osgi.services.remoteserviceadmin", 4, message, t));
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            this.handleRemovedBundle(bundle);
        }

        private void handleRemovedBundle(Bundle bundle) {
            Collection<org.osgi.service.remoteserviceadmin.EndpointDescription> endpointDescriptions = this.bundleDescriptionMap.remove(bundle.getBundleId());
            if (endpointDescriptions != null) {
                for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : endpointDescriptions) {
                    EndpointDescriptionLocator.this.removeED(ed);
                    EndpointDescriptionLocator.this.handleEndpointDescription(ed, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.endpointDescriptionReaderTrackerLock;
            synchronized (object) {
                if (this.endpointDescriptionReaderTracker != null) {
                    this.endpointDescriptionReaderTracker.close();
                    this.endpointDescriptionReaderTracker = null;
                }
            }
            this.bundleDescriptionMap.clear();
        }
    }

    private class EndpointEventListenerEvent {
        private EndpointEventListener endpointEventListener;
        private EndpointEvent event;
        private String matchingFilter;

        public EndpointEventListenerEvent(EndpointEventListener endpointEventListener, EndpointEvent event, String matchingFilter) {
            this.endpointEventListener = endpointEventListener;
            this.event = event;
            this.matchingFilter = matchingFilter;
        }

        public EndpointEventListener getEndpointEventListener() {
            return this.endpointEventListener;
        }

        public EndpointEvent getEndpointEvent() {
            return this.event;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }
    }

    public class EndpointEventListenerHolder {
        private EndpointEventListener listener;
        private org.osgi.service.remoteserviceadmin.EndpointDescription description;
        private String matchingFilter;
        private int type;

        public EndpointEventListenerHolder(EndpointEventListener l, org.osgi.service.remoteserviceadmin.EndpointDescription d, String f, int t) {
            this.listener = l;
            this.description = d;
            this.matchingFilter = f;
            this.type = t;
        }

        public EndpointEventListener getListener() {
            return this.listener;
        }

        public org.osgi.service.remoteserviceadmin.EndpointDescription getDescription() {
            return this.description;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }

        public int getType() {
            return this.type;
        }
    }

    private class EndpointListenerEvent {
        private EndpointListener endpointListener;
        private org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription;
        private String matchingFilter;
        private boolean discovered;

        public EndpointListenerEvent(EndpointListener endpointListener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchingFilter, boolean discovered) {
            this.endpointListener = endpointListener;
            this.endpointDescription = endpointDescription;
            this.matchingFilter = matchingFilter;
            this.discovered = discovered;
        }

        public EndpointListener getEndpointListener() {
            return this.endpointListener;
        }

        public org.osgi.service.remoteserviceadmin.EndpointDescription getEndointDescription() {
            return this.endpointDescription;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }

        public boolean isDiscovered() {
            return this.discovered;
        }
    }

    public class EndpointListenerHolder {
        private EndpointListener listener;
        private org.osgi.service.remoteserviceadmin.EndpointDescription description;
        private String matchingFilter;

        public EndpointListenerHolder(EndpointListener l, org.osgi.service.remoteserviceadmin.EndpointDescription d, String f) {
            this.listener = l;
            this.description = d;
            this.matchingFilter = f;
        }

        public EndpointListener getListener() {
            return this.listener;
        }

        public org.osgi.service.remoteserviceadmin.EndpointDescription getDescription() {
            return this.description;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }
    }

    class LocatorServiceListener
    implements IServiceListener {
        private IDiscoveryLocator locator;

        public LocatorServiceListener(IDiscoveryLocator locator) {
            this.locator = locator;
            if (locator != null) {
                this.locator.addServiceListener((IServiceListener)this);
            }
        }

        Collection<org.osgi.service.remoteserviceadmin.EndpointDescription> getEndpointDescriptions() {
            return this.locator == null ? Collections.EMPTY_SET : EndpointDescriptionLocator.this.getEDsForNamespace(this.locator.getServicesNamespace());
        }

        public void serviceDiscovered(IServiceEvent anEvent) {
            this.handleService(anEvent.getServiceInfo(), true);
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
            this.handleService(anEvent.getServiceInfo(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleService(IServiceInfo serviceInfo, boolean discovered) {
            if (this.locator == null) {
                return;
            }
            IServiceID serviceID = serviceInfo.getServiceID();
            if (Arrays.asList(serviceID.getServiceTypeID().getServices()).contains("ecfosgirsvc")) {
                EndpointDescriptionLocator.this.trace("handleService", "fwk=" + EndpointDescriptionLocator.this.getFrameworkUUID() + " serviceInfo=" + serviceInfo + ", discovered=" + discovered + ", locator=" + this.locator);
                Map map = EndpointDescriptionLocator.this.edToServiceIDMap;
                synchronized (map) {
                    org.osgi.service.remoteserviceadmin.EndpointDescription ed = EndpointDescriptionLocator.this.findED(serviceID);
                    if (discovered) {
                        if (ed == null) {
                            DiscoveredEndpointDescription discoveredEndpointDescription = this.getDiscoveredEndpointDescription(serviceID, serviceInfo, true);
                            if (discoveredEndpointDescription != null) {
                                ed = discoveredEndpointDescription.getEndpointDescription();
                                if (ed != null) {
                                    org.osgi.service.remoteserviceadmin.EndpointDescription prevEd = this.isEndpointDescriptionUpdate(ed, serviceID);
                                    if (prevEd == null) {
                                        if (!EndpointDescriptionLocator.this.containsED(ed)) {
                                            EndpointDescriptionLocator.this.addED(ed, serviceID);
                                            EndpointDescriptionLocator.this.handleEndpointDescription(ed, true);
                                        } else {
                                            EndpointDescriptionLocator.this.trace("handleEndpointDescription", "endpointDescription previously discovered...ignoring");
                                        }
                                    } else {
                                        EndpointDescriptionLocator.this.trace("handleEndpointDescription", "endpointDescription updated. prev=" + prevEd + ", update=" + ed);
                                        EndpointDescriptionLocator.this.queueEndpointEvent(ed, 4);
                                    }
                                } else {
                                    EndpointDescriptionLocator.this.trace("handleService", "EndpointDescription is null for serviceID=" + serviceID);
                                }
                            } else {
                                EndpointDescriptionLocator.this.trace("handleService", "DiscoveredEndpointDescription is null for serviceID=" + serviceID);
                            }
                        } else {
                            EndpointDescriptionLocator.this.trace("handleService", "Found previous EndpointDescription with same serviceID=" + serviceID + ".  Ignoring");
                        }
                    } else if (ed != null) {
                        EndpointDescriptionLocator.this.removeED(ed);
                        EndpointDescriptionLocator.this.handleEndpointDescription(ed, false);
                    } else {
                        EndpointDescriptionLocator.this.trace("handleService", "Did not find serviceInfo with serviceID=" + serviceID + ".  Ignoring");
                    }
                }
            }
        }

        org.osgi.service.remoteserviceadmin.EndpointDescription isEndpointDescriptionUpdate(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IServiceID updateServiceID) {
            if (endpointDescription instanceof EndpointDescription) {
                EndpointDescription ed = (EndpointDescription)endpointDescription;
                Long receivedTS = ed.getTimestamp();
                if (receivedTS != null) {
                    String receivedId = ed.getId();
                    boolean update = false;
                    EndpointDescription ped = null;
                    for (org.osgi.service.remoteserviceadmin.EndpointDescription previousEndpoint : this.getEndpointDescriptions()) {
                        Long pedTS;
                        if (!(previousEndpoint instanceof EndpointDescription) || !(ped = (EndpointDescription)previousEndpoint).getId().equals(receivedId) || (pedTS = ped.getTimestamp()) == null || pedTS >= receivedTS) continue;
                        update = true;
                    }
                    if (update) {
                        EndpointDescriptionLocator.this.updateED(ped, ed, updateServiceID);
                        return ed;
                    }
                }
            } else {
                Map edProperties = endpointDescription.getProperties();
                Long receivedTS = PropertiesUtil.getOSGiEndpointModifiedValue(edProperties);
                if (receivedTS != null) {
                    String receivedId = endpointDescription.getId();
                    boolean update = false;
                    org.osgi.service.remoteserviceadmin.EndpointDescription ped = null;
                    Iterator<org.osgi.service.remoteserviceadmin.EndpointDescription> iterator = this.getEndpointDescriptions().iterator();
                    while (iterator.hasNext()) {
                        org.osgi.service.remoteserviceadmin.EndpointDescription previousEndpoint;
                        ped = previousEndpoint = iterator.next();
                        if (!previousEndpoint.getId().equals(receivedId)) continue;
                        Long pedTS = (Long)previousEndpoint.getProperties().get("ecf.osgi.endpoint.modified");
                        if (pedTS == null) {
                            update = true;
                            continue;
                        }
                        if (pedTS.longValue() == receivedTS.longValue()) {
                            return null;
                        }
                        if (pedTS != null && pedTS >= receivedTS) continue;
                        update = true;
                    }
                    if (update) {
                        EndpointDescriptionLocator.this.updateED(ped, endpointDescription, updateServiceID);
                        return endpointDescription;
                    }
                }
            }
            return null;
        }

        private DiscoveredEndpointDescription getDiscoveredEndpointDescription(IServiceID serviceId, IServiceInfo serviceInfo, boolean discovered) {
            String methodName = "getDiscoveredEndpointDescription";
            IDiscoveredEndpointDescriptionFactory factory = EndpointDescriptionLocator.this.getDiscoveredEndpointDescriptionFactory();
            try {
                return discovered ? factory.createDiscoveredEndpointDescription(this.locator, serviceInfo) : factory.removeDiscoveredEndpointDescription(this.locator, serviceId);
            }
            catch (Exception e) {
                EndpointDescriptionLocator.this.logError("getDiscoveredEndpointDescription", "Exception calling IEndpointDescriptionFactory." + (discovered ? "createDiscoveredEndpointDescription" : "getUndiscoveredEndpointDescription"), e);
                return null;
            }
            catch (NoClassDefFoundError e) {
                EndpointDescriptionLocator.this.logError("getDiscoveredEndpointDescription", "NoClassDefFoundError calling IEndpointDescriptionFactory." + (discovered ? "createDiscoveredEndpointDescription" : "getUndiscoveredEndpointDescription"), e);
                return null;
            }
        }

        public synchronized void close() {
            if (this.locator != null) {
                this.locator.removeServiceListener((IServiceListener)this);
                this.locator = null;
            }
        }

        public boolean triggerDiscovery() {
            return false;
        }
    }

    private class LocatorTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private LocatorTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            IDiscoveryLocator locator = (IDiscoveryLocator)EndpointDescriptionLocator.this.context.getService(reference);
            if (locator != null) {
                EndpointDescriptionLocator.this.openLocator(locator);
            }
            return locator;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            EndpointDescriptionLocator.this.shutdownLocator((IDiscoveryLocator)service);
        }
    }
}

