/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowser;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.DefaultNTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.ECFHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.IHttpClientModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.INTLMProxyHandler;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.filetransfer.httpclient45";
    public static final String USE_SHARED_CLIENT = "org.eclipse.ecf.provider.filetransfer.httpclient45.sharedClient";
    private static final String USE_SHARED_CLIENT_DEFAULT = "true";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker<LogService, LogService> logServiceTracker = null;
    private ServiceTracker<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryTracker;
    private ServiceTracker<INTLMProxyHandler, INTLMProxyHandler> ntlmProxyHandlerTracker;
    private ServiceTracker<IHttpClientFactory, IHttpClientFactory> httpClientFactoryTracker;
    private ServiceTracker<HttpClient, CloseableHttpClient> browseClientTracker;
    private ServiceTracker<HttpClient, CloseableHttpClient> retrieveClientTracker;
    private boolean useSharedClient;

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.useSharedClient = Boolean.parseBoolean(System.getProperty(USE_SHARED_CLIENT, USE_SHARED_CLIENT_DEFAULT));
        this.applyDebugOptions(ctxt);
    }

    private void applyDebugOptions(BundleContext ctxt) {
        DebugOptions debugOptions;
        ServiceReference debugRef = ctxt.getServiceReference(DebugOptions.class);
        DebugOptions debugOptions2 = debugOptions = debugRef == null ? null : (DebugOptions)ctxt.getService(debugRef);
        if (debugOptions == null) {
            return;
        }
        try {
            if (!debugOptions.isDebugEnabled()) {
                return;
            }
            Map options = debugOptions.getOptions();
            String ourDebugPrefix = "org.eclipse.ecf.provider.filetransfer.httpclient45/";
            String ecfDebugPrefix = "org.eclipse.ecf.provider.filetransfer.httpclient4/";
            for (Map.Entry entry : options.entrySet()) {
                String ecfOption;
                String ecfValue;
                if (entry.getKey() == null || !((String)entry.getKey()).startsWith(ourDebugPrefix) || (ecfValue = (String)options.get(ecfOption = String.valueOf(ecfDebugPrefix) + ((String)entry.getKey()).substring(ourDebugPrefix.length()))) != null) continue;
                debugOptions.setOption(ecfOption, (String)entry.getValue());
            }
        }
        finally {
            ctxt.ungetService(debugRef);
        }
    }

    public synchronized void stop(BundleContext ctxt) throws Exception {
        if (this.sslSocketFactoryTracker != null) {
            this.sslSocketFactoryTracker.close();
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.ntlmProxyHandlerTracker != null) {
            this.ntlmProxyHandlerTracker.close();
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    private synchronized LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class, null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public boolean isUseSharedClient() {
        return this.useSharedClient;
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactoryTracker == null) {
            this.sslSocketFactoryTracker = new ServiceTracker(this.context, SSLSocketFactory.class, null);
            this.sslSocketFactoryTracker.open();
        }
        SSLSocketFactory service = (SSLSocketFactory)this.sslSocketFactoryTracker.getService();
        return service;
    }

    public synchronized INTLMProxyHandler getNTLMProxyHandler() {
        INTLMProxyHandler service;
        if (this.ntlmProxyHandlerTracker == null) {
            this.ntlmProxyHandlerTracker = new ServiceTracker(this.context, INTLMProxyHandler.class, null);
            this.ntlmProxyHandlerTracker.open();
        }
        if ((service = (INTLMProxyHandler)this.ntlmProxyHandlerTracker.getService()) == null) {
            service = new DefaultNTLMProxyHandler();
        }
        return service;
    }

    public synchronized IHttpClientFactory getHttpClientFactory() {
        IHttpClientFactory service;
        if (this.httpClientFactoryTracker == null) {
            this.httpClientFactoryTracker = new ServiceTracker(this.context, IHttpClientFactory.class, null);
            this.httpClientFactoryTracker.open();
        }
        if ((service = (IHttpClientFactory)this.httpClientFactoryTracker.getService()) == null) {
            service = new ECFHttpClientFactory();
            Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
            ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
            this.context.registerService(IHttpClientFactory.class, (Object)service, serviceProperties);
        }
        return service;
    }

    public synchronized CloseableHttpClient getBrowseHttpClient() {
        CloseableHttpClient service;
        if (this.isUseSharedClient()) {
            if (this.browseClientTracker == null) {
                this.browseClientTracker = new ServiceTracker(this.context, HttpClient.class, (ServiceTrackerCustomizer)new ScopedHttpClientCustomizer(this.context, IRemoteFileSystemBrowser.class.getName()));
                this.browseClientTracker.open();
            }
            if ((service = (CloseableHttpClient)this.browseClientTracker.getService()) == null) {
                service = this.registerHttpClient();
            }
        } else {
            service = this.getHttpClientFactory().newClient().build();
        }
        return service;
    }

    public synchronized CloseableHttpClient getRetrieveHttpClient() {
        CloseableHttpClient service;
        if (this.isUseSharedClient()) {
            if (this.retrieveClientTracker == null) {
                this.retrieveClientTracker = new ServiceTracker(this.context, HttpClient.class, (ServiceTrackerCustomizer)new ScopedHttpClientCustomizer(this.context, IRetrieveFileTransfer.class.getName()));
                this.retrieveClientTracker.open();
            }
            if ((service = (CloseableHttpClient)this.retrieveClientTracker.getService()) == null) {
                service = this.registerHttpClient();
            }
        } else {
            service = this.getHttpClientFactory().newClient().build();
        }
        return service;
    }

    private CloseableHttpClient registerHttpClient() {
        CloseableHttpClient client = this.getHttpClientFactory().newClient().build();
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)serviceProperties).put("http.client.scope", "org.eclipse.ecf.filetransfer.service.*");
        this.context.registerService(new String[]{HttpClient.class.getName(), CloseableHttpClient.class.getName()}, (Object)client, serviceProperties);
        return client;
    }

    public static void logNoProxyWarning(Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, PLUGIN_ID, 4, "Warning: Platform proxy API not available", e));
        }
    }

    protected <T> T runModifiers(T value, ECFHttpClientFactory.ModifierRunner<T> modifierRunner) {
        T modifiedValue = value;
        List<ServiceReference<IHttpClientModifier>> orderedServices = this.getModifierReferences();
        for (ServiceReference<IHttpClientModifier> serviceReference : orderedServices) {
            IHttpClientModifier modifier = (IHttpClientModifier)this.context.getService(serviceReference);
            try {
                T newValue;
                if (modifier == null || (newValue = modifierRunner.run(modifier, modifiedValue)) == null) continue;
                modifiedValue = newValue;
            }
            finally {
                this.context.ungetService(serviceReference);
            }
        }
        return modifiedValue;
    }

    private List<ServiceReference<IHttpClientModifier>> getModifierReferences() {
        Collection serviceReferences;
        try {
            serviceReferences = this.context.getServiceReferences(IHttpClientModifier.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new ECFRuntimeException((Throwable)e);
        }
        ArrayList<ServiceReference<IHttpClientModifier>> orderedServices = new ArrayList<ServiceReference<IHttpClientModifier>>(serviceReferences);
        if (orderedServices.size() < 2) {
            return orderedServices;
        }
        Collections.sort(orderedServices, new Comparator<ServiceReference<?>>(){

            @Override
            public int compare(ServiceReference<?> o1, ServiceReference<?> o2) {
                if (o1 == o2) {
                    return 0;
                }
                int ranking1 = this.getServiceRanking(o1);
                int ranking2 = this.getServiceRanking(o2);
                return ranking1 - ranking2;
            }

            private int getServiceRanking(ServiceReference<?> reference) {
                Object rankingValue = reference.getProperty("service.ranking");
                if (rankingValue instanceof Integer) {
                    return (Integer)rankingValue;
                }
                if (rankingValue instanceof String) {
                    try {
                        return Integer.parseInt((String)rankingValue);
                    }
                    catch (NumberFormatException e) {
                        Trace.catching((String)Activator.PLUGIN_ID, (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", Activator.class, (String)"getServiceRanking", (Throwable)e);
                    }
                }
                return 0;
            }
        });
        return orderedServices;
    }

    private static final class ScopedHttpClientCustomizer
    implements ServiceTrackerCustomizer<HttpClient, CloseableHttpClient> {
        private final String neededScope;
        private final BundleContext context;

        public ScopedHttpClientCustomizer(BundleContext context, String neededScope) {
            this.context = context;
            this.neededScope = neededScope;
        }

        public CloseableHttpClient addingService(ServiceReference<HttpClient> reference) {
            if (!this.hasScope(reference, this.neededScope)) {
                return null;
            }
            HttpClient service = (HttpClient)this.context.getService(reference);
            if (service instanceof CloseableHttpClient) {
                return (CloseableHttpClient)service;
            }
            this.context.ungetService(reference);
            return null;
        }

        private boolean hasScope(ServiceReference<HttpClient> reference, String neededScope) {
            String[] scopes;
            Object scopeProperty = reference.getProperty("http.client.scope");
            if (scopeProperty == null || !(scopeProperty instanceof String)) {
                return false;
            }
            String[] stringArray = scopes = ((String)scopeProperty).split("\\s*,\\s*");
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                if (neededScope.equals(scope) || scope.endsWith("*") && neededScope.startsWith(scope.substring(0, scope.length() - 1))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void modifiedService(ServiceReference<HttpClient> reference, CloseableHttpClient service) {
            if (!this.hasScope(reference, this.neededScope)) {
                this.context.ungetService(reference);
            }
        }

        public void removedService(ServiceReference<HttpClient> reference, CloseableHttpClient service) {
            this.context.ungetService(reference);
        }
    }
}

