/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient5;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.NTLMSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.HttpClientDefaultSSLSocketFactoryModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.IHttpClientModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.INTLMProxyHandler;
import org.eclipse.ecf.provider.filetransfer.httpclient5.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient5.HttpClientRetrieveFileTransfer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class ECFHttpClientFactory
implements IHttpClientFactory {
    private static final List<String> DEFAULT_PREFERRED_AUTH_SCHEMES_NO_NTLM = Arrays.asList("Basic", "Digest");
    private static final List<String> DEFAULT_PREFERRED_AUTH_SCHEMES = Arrays.asList("Basic", "Digest", "NTLM");
    public static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    public static final int DEFAULT_CONNECTION_TTL = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TTL;
    public static final int DEFAULT_READ_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_READ_TIMEOUT;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    public static final String NTLM_PROXY_HANDLER_ATTR = INTLMProxyHandler.class.getName();
    private static final Registry<AuthSchemeFactory> DEFAULT_AUTH_SCHEME_REGISTRY = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("NTLM", (Object)NTLMSchemeFactory.INSTANCE).build();
    private static final SocketConfig DEFAULT_SOCKET_CONFIG = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(DEFAULT_READ_TIMEOUT, TimeUnit.MILLISECONDS).setTcpNoDelay(true).build();
    private ReferenceQueue<CloseableHttpClient> collectedClients;
    private List<WeakReference<CloseableHttpClient>> trackedClients;

    @Override
    public HttpClientBuilder newClient() {
        HttpClientBuilder builder = this.createHttpClientBuilder();
        builder.setDefaultCredentialsProvider((CredentialsProvider)new HttpClientProxyCredentialProvider());
        builder.setDefaultRequestConfig(this.newRequestConfig(null, System.getProperties()).build());
        PoolingHttpClientConnectionManagerBuilder cmBuilder = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(100).setMaxConnTotal(300).setConnectionTimeToLive(TimeValue.ofMilliseconds((long)DEFAULT_CONNECTION_TTL)).setDefaultSocketConfig(DEFAULT_SOCKET_CONFIG).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO);
        ECFHttpClientFactory.configureSSLSocketFactory(cmBuilder);
        builder.setConnectionManager((HttpClientConnectionManager)cmBuilder.build());
        builder.setDefaultAuthSchemeRegistry(DEFAULT_AUTH_SCHEME_REGISTRY);
        builder = Activator.getDefault().runModifiers(builder, new ModifierRunner<HttpClientBuilder>(){

            @Override
            public HttpClientBuilder run(IHttpClientModifier modifier, HttpClientBuilder value) {
                return modifier.modifyClient(value);
            }
        });
        return builder;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return new HttpClientBuilder(){

            public CloseableHttpClient build() {
                CloseableHttpClient client = super.build();
                ECFHttpClientFactory.this.track(client);
                return client;
            }
        };
    }

    @Override
    public HttpClientContext newClientContext() {
        HttpClientContext context = HttpClientContext.create();
        INTLMProxyHandler ntlmProxyHandler = Activator.getDefault().getNTLMProxyHandler();
        context.setAttribute(NTLM_PROXY_HANDLER_ATTR, (Object)ntlmProxyHandler);
        context.setAuthSchemeRegistry(DEFAULT_AUTH_SCHEME_REGISTRY);
        context = Activator.getDefault().runModifiers(context, new ModifierRunner<HttpClientContext>(){

            @Override
            public HttpClientContext run(IHttpClientModifier modifier, HttpClientContext value) {
                return modifier.modifyContext(value);
            }
        });
        return context;
    }

    @Override
    public RequestConfig.Builder newRequestConfig(final HttpClientContext context, final Map<?, ?> localOptions) {
        RequestConfig.Builder builder = RequestConfig.custom();
        int connectionRequestTimeout = DEFAULT_CONNECTION_REQUEST_TIMEOUT;
        int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        int readTimeout = DEFAULT_READ_TIMEOUT;
        if (localOptions != null) {
            connectionRequestTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.connectTimeout", localOptions, connectionRequestTimeout);
            connectionTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.connectTimeout", localOptions, connectionTimeout);
            readTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.readTimeout", localOptions, readTimeout);
        }
        builder.setConnectionRequestTimeout((long)connectionRequestTimeout, TimeUnit.MILLISECONDS).setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        boolean allowNTLMAuthentication = ECFHttpClientFactory.getNTLMProxyHandler((HttpContext)context).allowNTLMAuthentication(localOptions);
        List<String> preferredAuthSchemes = allowNTLMAuthentication ? DEFAULT_PREFERRED_AUTH_SCHEMES : DEFAULT_PREFERRED_AUTH_SCHEMES_NO_NTLM;
        builder.setProxyPreferredAuthSchemes(preferredAuthSchemes);
        builder.setTargetPreferredAuthSchemes(preferredAuthSchemes);
        builder = Activator.getDefault().runModifiers(builder, new ModifierRunner<RequestConfig.Builder>(){

            @Override
            public RequestConfig.Builder run(IHttpClientModifier modifier, RequestConfig.Builder value) {
                return modifier.modifyRequestConfig(value, context, localOptions);
            }
        });
        return builder;
    }

    private int getIntOption(String key, Map<?, ?> localOptions, int defaultValue) {
        Object option = localOptions.get(key);
        if (option != null) {
            int value = defaultValue;
            if (option instanceof Number) {
                value = ((Number)option).intValue();
            } else if (option instanceof String) {
                try {
                    value = Integer.parseInt((String)option);
                }
                catch (NumberFormatException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", HttpClientRetrieveFileTransfer.class, (String)"getDnsHostName", (Throwable)e);
                }
            }
            return value;
        }
        return defaultValue;
    }

    private static void configureSSLSocketFactory(PoolingHttpClientConnectionManagerBuilder cm) {
        SSLSocketFactory sslSocketFactory = Activator.getDefault().getSSLSocketFactory();
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new HttpClientDefaultSSLSocketFactoryModifier().getSSLSocketFactory();
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", HttpClientDefaultSSLSocketFactoryModifier.class, (String)"getSSLSocketFactory()", (Throwable)e);
                throw new ECFRuntimeException("Unable to instantiate schemes for HttpClient.", (Throwable)e);
            }
        }
        if (sslSocketFactory == SSLSocketFactory.getDefault()) {
            sslSocketFactory = null;
        }
        if (sslSocketFactory != null) {
            PublicSuffixMatcher publicSuffixMatcherCopy = PublicSuffixMatcherLoader.getDefault();
            String systemHttpsProtocols = System.getProperty("https.protocols");
            String systemCipherSuites = System.getProperty("https.cipherSuites");
            String[] supportedProtocols = ECFHttpClientFactory.split(systemHttpsProtocols);
            String[] supportedCipherSuites = ECFHttpClientFactory.split(systemCipherSuites);
            DefaultHostnameVerifier hostnameVerifierCopy = new DefaultHostnameVerifier(publicSuffixMatcherCopy);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslSocketFactory, supportedProtocols, supportedCipherSuites, (HostnameVerifier)hostnameVerifierCopy);
            cm.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
    }

    private synchronized void track(CloseableHttpClient client) {
        this.clearCollectedClients();
        if (this.collectedClients == null) {
            this.collectedClients = new ReferenceQueue();
            this.trackedClients = new LinkedList<WeakReference<CloseableHttpClient>>();
        }
        this.trackedClients.add(new WeakReference<CloseableHttpClient>(client, this.collectedClients));
    }

    private synchronized void clearCollectedClients() {
        if (this.collectedClients == null) {
            return;
        }
        Reference<CloseableHttpClient> collectedReference = this.collectedClients.poll();
        while (collectedReference != null) {
            this.trackedClients.remove(collectedReference);
            collectedReference = this.collectedClients.poll();
        }
    }

    public synchronized void close() {
        if (this.trackedClients != null) {
            for (WeakReference<CloseableHttpClient> clientRef : this.trackedClients) {
                CloseableHttpClient client = (CloseableHttpClient)clientRef.get();
                if (client == null) continue;
                try {
                    client.close();
                }
                catch (IOException ex) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", ECFHttpClientFactory.class, (String)"close", (Throwable)ex);
                }
            }
            this.trackedClients = null;
            this.collectedClients = null;
        }
    }

    @Deactivate
    public void deactivate() {
        this.close();
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public static CredentialsProvider modifyCredentialsProvider(CredentialsProvider credentialsProvider) {
        return Activator.getDefault().runModifiers(credentialsProvider, new ModifierRunner<CredentialsProvider>(){

            @Override
            public CredentialsProvider run(IHttpClientModifier modifier, CredentialsProvider value) {
                return modifier.modifyCredentialsProvider(value);
            }
        });
    }

    public static INTLMProxyHandler getNTLMProxyHandler(HttpContext httpContext) {
        Object value;
        Object object = value = httpContext == null ? null : httpContext.getAttribute(NTLM_PROXY_HANDLER_ATTR);
        if (value instanceof INTLMProxyHandler) {
            return (INTLMProxyHandler)value;
        }
        INTLMProxyHandler handler = Activator.getDefault().getNTLMProxyHandler();
        if (handler != null && httpContext != null && value == null) {
            httpContext.setAttribute(NTLM_PROXY_HANDLER_ATTR, (Object)handler);
        }
        return handler;
    }

    protected static interface ModifierRunner<T> {
        public T run(IHttpClientModifier var1, T var2);
    }
}

