/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.docshare;

import java.util.Hashtable;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.docshare.DocShare;
import org.eclipse.ecf.sync.doc.IDocumentSynchronizationStrategyFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ecf.internal.provisional.docshare";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker containerManagerTracker;
    private ServiceTracker syncStrategyFactoryServiceTracker;
    private boolean listenerActive;
    private static final Hashtable docsharechannels;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        docsharechannels = new Hashtable();
    }

    public DocShare getDocShare(ID containerID) {
        return (DocShare)((Object)docsharechannels.get(containerID));
    }

    public DocShare addDocShare(ID containerID, IChannelContainerAdapter channelAdapter) throws ECFException {
        DocShare docShare = (DocShare)((Object)docsharechannels.get(containerID));
        if (docShare == null) {
            docShare = docsharechannels.put(containerID, new DocShare(channelAdapter));
        }
        return docShare;
    }

    public DocShare removeDocShare(ID containerID) {
        return (DocShare)((Object)docsharechannels.remove(containerID));
    }

    public boolean isListenerActive() {
        return this.listenerActive;
    }

    public void setListenerActive(boolean active) {
        this.listenerActive = active;
    }

    public void start(BundleContext ctxt) throws Exception {
        super.start(ctxt);
        plugin = this;
        this.context = ctxt;
        this.setListenerActive(true);
    }

    public void stop(BundleContext ctxt) throws Exception {
        super.stop(ctxt);
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        if (this.syncStrategyFactoryServiceTracker != null) {
            this.syncStrategyFactoryServiceTracker.close();
            this.syncStrategyFactoryServiceTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    public IDocumentSynchronizationStrategyFactory getColaSynchronizationStrategyFactory() {
        if (this.syncStrategyFactoryServiceTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.sync.doc.IDocumentSynchronizationStrategyFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.syncStrategyFactoryServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.syncStrategyFactoryServiceTracker.open();
        }
        return (IDocumentSynchronizationStrategyFactory)this.syncStrategyFactoryServiceTracker.getService();
    }
}

