/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.OneToOneQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping,
MapKeyMapping {
    protected Map<DatabaseField, DatabaseField> sourceToTargetKeyFields;
    protected Map<DatabaseField, DatabaseField> targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;
    public DatabaseTable keyTableForMapKey = null;
    protected static final String setObject = "setObject";
    protected transient RelationTableMechanism mechanism;
    protected boolean isDefinedAsManyToOneMapping = false;

    public OneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
        this.shouldVerifyDelete = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        for (DatabaseField field : this.getForeignKeyFields()) {
            if (selectionQuery.isObjectLevelReadQuery()) {
                if (baseExpression != null) {
                    ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(field));
                    continue;
                }
                ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(field);
                continue;
            }
            if (!selectionQuery.isDataReadQuery()) continue;
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(field);
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        Iterator<DatabaseField> i = this.getForeignKeyFields().iterator();
        while (i.hasNext()) {
            joinRow.put(i.next(), (Object)null);
        }
    }

    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) {
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(sourceForeignKeyField);
        this.getSourceToTargetKeyFields().put(sourceForeignKeyField, targetPrimaryKeyField);
        this.getTargetToSourceKeyFields().put(targetPrimaryKeyField, sourceForeignKeyField);
    }

    public void addForeignKeyFieldName(String sourceForeignKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addForeignKeyField(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceToTargetKeyFields().put(sourcePrimaryKeyField, targetForeignKeyField);
        this.getTargetToSourceKeyFields().put(targetForeignKeyField, sourcePrimaryKeyField);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, Map deletedObjects) {
        deletedObjects.put(object, object);
    }

    @Override
    public Object buildElementClone(Object attributeValue, Object parent, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        return this.buildCloneForPartObject(attributeValue, null, null, unitOfWork, isExisting);
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object value, AbstractSession session) {
        Expression base = ((ObjectExpression)expression).getBaseExpression();
        Expression foreignKeyJoin = null;
        if (this.mechanism == null) {
            if (value == null) {
                if (!this.isForeignKeyRelationship()) {
                    throw QueryException.cannotCompareTargetForeignKeysToNull(base, value, this);
                }
                for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                    Expression join = null;
                    join = base.getField(field).equal(null);
                    if (foreignKeyJoin == null) {
                        foreignKeyJoin = join;
                        continue;
                    }
                    foreignKeyJoin = foreignKeyJoin.and(join);
                }
            } else {
                if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                    value = ProxyIndirectionPolicy.getValueFromProxy(value);
                    if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                        throw QueryException.incorrectClassForObjectComparison(base, value, this);
                    }
                }
                Iterator<Object> keyIterator = Arrays.asList(((CacheId)this.extractKeyFromReferenceObject(value, session)).getPrimaryKey()).iterator();
                for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                    Expression join = null;
                    join = base.getField(field).equal(keyIterator.next());
                    if (foreignKeyJoin == null) {
                        foreignKeyJoin = join;
                        continue;
                    }
                    foreignKeyJoin = foreignKeyJoin.and(join);
                }
            }
        } else {
            int size = this.mechanism.sourceKeyFields.size();
            Object key = null;
            if (value != null) {
                if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                    value = ProxyIndirectionPolicy.getValueFromProxy(value);
                    if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                        throw QueryException.incorrectClassForObjectComparison(base, value, this);
                    }
                }
                key = this.extractKeyFromReferenceObject(value, session);
                boolean allNulls = true;
                for (int i = 0; i < size; ++i) {
                    if (((CacheId)key).getPrimaryKey()[i] == null) continue;
                    allNulls = false;
                    break;
                }
                if (allNulls) {
                    value = null;
                }
            }
            if (value != null) {
                for (int i = 0; i < size; ++i) {
                    DatabaseField field = this.mechanism.sourceKeyFields.get(i);
                    Expression join = null;
                    join = base.getField(field).equal(((CacheId)key).getPrimaryKey()[i]);
                    foreignKeyJoin = foreignKeyJoin == null ? join : foreignKeyJoin.and(join);
                }
            } else {
                ReportQuery subQuery = new ReportQuery(this.descriptor.getJavaClass(), new ExpressionBuilder());
                Expression relationTableExp = subQuery.getExpressionBuilder().getTable(this.mechanism.relationTable);
                Expression subSelectExp = null;
                for (int i = 0; i < size; ++i) {
                    subSelectExp = relationTableExp.getField(this.mechanism.sourceRelationKeyFields.get(i)).equal(base.getField(this.mechanism.sourceKeyFields.get(i))).and(subSelectExp);
                }
                subQuery.setSelectionCriteria(subSelectExp);
                subQuery.dontRetrievePrimaryKeys();
                subQuery.addAttribute("", subQuery.getExpressionBuilder().getField(this.mechanism.sourceKeyFields.get(0)));
                foreignKeyJoin = base.notExists(subQuery);
            }
        }
        return foreignKeyJoin;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression argument, AbstractSession session) {
        Expression base = ((ObjectExpression)expression).getBaseExpression();
        Expression foreignKeyJoin = null;
        if (this.mechanism == null) {
            if (expression == argument) {
                for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                    Expression join = base.getField(field);
                    join = join.equal(join);
                    if (foreignKeyJoin == null) {
                        foreignKeyJoin = join;
                        continue;
                    }
                    foreignKeyJoin = foreignKeyJoin.and(join);
                }
            } else {
                Iterator<DatabaseField> targetFieldsEnum = this.getSourceToTargetKeyFields().values().iterator();
                for (DatabaseField sourceField : this.getSourceToTargetKeyFields().keySet()) {
                    DatabaseField targetField = targetFieldsEnum.next();
                    Expression join = null;
                    join = base.getField(sourceField).equal(argument.getField(targetField));
                    if (foreignKeyJoin == null) {
                        foreignKeyJoin = join;
                        continue;
                    }
                    foreignKeyJoin = foreignKeyJoin.and(join);
                }
            }
        } else if (expression == argument) {
            foreignKeyJoin = new ConstantExpression(0, base).equal(new ConstantExpression(0, base));
        } else {
            int size = this.mechanism.sourceKeyFields.size();
            Expression relTable = base.getTable(this.mechanism.getRelationTable());
            for (int i = 0; i < size; ++i) {
                Expression source = base.getField(this.mechanism.sourceKeyFields.get(i));
                Expression sourceRel = relTable.getField(this.mechanism.sourceRelationKeyFields.get(i));
                Expression targetRel = relTable.getField(this.mechanism.targetRelationKeyFields.get(i));
                Expression target = argument.getField(this.mechanism.targetKeyFields.get(i));
                foreignKeyJoin = source.equal(sourceRel).and(targetRel.equal(target)).and(foreignKeyJoin);
            }
        }
        return foreignKeyJoin;
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        DataReadQuery query = new DataReadQuery();
        query.setSQLStatement(new SQLSelectStatement());
        query.setContainerPolicy(containerPolicy);
        return query;
    }

    @Override
    public Object clone() {
        OneToOneMapping clone = (OneToOneMapping)super.clone();
        if (this.mechanism == null) {
            DatabaseField sourceClone;
            DatabaseField targetClone;
            clone.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
            clone.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size()));
            clone.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size()));
            Hashtable<DatabaseField, DatabaseField> setOfFields = new Hashtable<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
            Enumeration<DatabaseField> enumtr = this.getForeignKeyFields().elements();
            while (enumtr.hasMoreElements()) {
                DatabaseField field = enumtr.nextElement();
                DatabaseField fieldClone = (DatabaseField)field.clone();
                setOfFields.put(field, fieldClone);
                clone.getForeignKeyFields().addElement(fieldClone);
            }
            for (DatabaseField sourceField : this.getSourceToTargetKeyFields().keySet()) {
                DatabaseField targetField = this.getSourceToTargetKeyFields().get(sourceField);
                targetClone = (DatabaseField)setOfFields.get(targetField);
                if (targetClone == null) {
                    targetClone = (DatabaseField)targetField.clone();
                    setOfFields.put(targetField, targetClone);
                }
                if ((sourceClone = (DatabaseField)setOfFields.get(sourceField)) == null) {
                    sourceClone = (DatabaseField)sourceField.clone();
                    setOfFields.put(sourceField, sourceClone);
                }
                clone.getSourceToTargetKeyFields().put(sourceClone, targetClone);
            }
            for (DatabaseField targetField : this.getTargetToSourceKeyFields().keySet()) {
                DatabaseField sourceField = this.getTargetToSourceKeyFields().get(targetField);
                targetClone = (DatabaseField)setOfFields.get(targetField);
                if (targetClone == null) {
                    targetClone = (DatabaseField)targetField.clone();
                    setOfFields.put(targetField, targetClone);
                }
                if ((sourceClone = (DatabaseField)setOfFields.get(sourceField)) == null) {
                    sourceClone = (DatabaseField)sourceField.clone();
                    setOfFields.put(sourceField, sourceClone);
                }
                clone.getTargetToSourceKeyFields().put(targetClone, sourceClone);
            }
        } else {
            clone.mechanism = (RelationTableMechanism)this.mechanism.clone();
        }
        return clone;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, AbstractSession session) {
        return session.executeQuery((DatabaseQuery)this.getSelectionQuery(), dbRow);
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord dbRow, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) {
        return this.valueFromRowInternalWithJoin(dbRow, joinManager, query, session);
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        OneToOneQueryKey key = new OneToOneQueryKey();
        key.setDescriptor(this.getReferenceDescriptor());
        key.setReferenceClass(this.getReferenceClass());
        key.setJoinCriteria(this.getAdditionalSelectionCriteriaForMapKey());
        return key;
    }

    @Override
    public void deleteMapKey(Object objectDeleted, AbstractSession session) {
        session.deleteObject(objectDeleted);
    }

    @Override
    protected void extendPessimisticLockScopeInTargetQuery(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        if (this.mechanism == null) {
            super.extendPessimisticLockScopeInTargetQuery(targetQuery, sourceQuery);
        } else {
            this.mechanism.setRelationTableLockingClause(targetQuery, sourceQuery);
        }
    }

    @Override
    public void extendPessimisticLockScopeInSourceQuery(ObjectLevelReadQuery sourceQuery) {
        Expression exp = sourceQuery.getSelectionCriteria();
        if (this.mechanism == null) {
            ExpressionBuilder builder = sourceQuery.getExpressionBuilder();
            Iterator<Map.Entry<DatabaseField, DatabaseField>> it = this.getSourceToTargetKeyFields().entrySet().iterator();
            Map.Entry<DatabaseField, DatabaseField> entry = it.next();
            exp = builder.getField(entry.getKey()).equal(builder.get(this.getAttributeName()).getField(entry.getValue())).and(exp);
        } else {
            exp = this.mechanism.joinRelationTableField(exp, sourceQuery.getExpressionBuilder());
        }
        sourceQuery.setSelectionCriteria(exp);
    }

    protected Object extractForeignKeyFromRow(AbstractRecord row, AbstractSession session) {
        Object[] key;
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        if (this.mechanism == null) {
            key = new Object[this.getSourceToTargetKeyFields().size()];
            int index = 0;
            for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                Object value = row.get(field);
                try {
                    value = conversionManager.convertObject(value, builder.getFieldClassification(field));
                }
                catch (ConversionException e) {
                    throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
                }
                key[index] = value;
                ++index;
            }
        } else {
            Vector<DatabaseField> sourceKeyFields = this.mechanism.sourceKeyFields;
            int size = sourceKeyFields.size();
            key = new Object[size];
            for (int i = 0; i < size; ++i) {
                DatabaseField field = (DatabaseField)sourceKeyFields.get(i);
                Object value = row.get(field);
                try {
                    value = conversionManager.convertObject(value, builder.getFieldClassification(field));
                }
                catch (ConversionException e) {
                    throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
                }
                key[i] = value;
            }
        }
        return new CacheId(key);
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession session) {
        HashMap<DatabaseField, Object> keyFields = new HashMap<DatabaseField, Object>();
        for (int index = 0; index < this.getForeignKeyFields().size(); ++index) {
            DatabaseField targetRelationField = this.getForeignKeyFields().elementAt(index);
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(targetRelationField);
            Object value = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetKey, session);
            keyFields.put(targetRelationField, value);
        }
        return keyFields;
    }

    protected Object extractKeyFromReferenceObject(Object object, AbstractSession session) {
        Object[] key;
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        if (this.mechanism == null) {
            key = new Object[this.getSourceToTargetKeyFields().size()];
            int index = 0;
            for (DatabaseField field : this.getSourceToTargetKeyFields().values()) {
                key[index] = object == null ? null : objectBuilder.extractValueFromObjectForField(object, field, session);
                ++index;
            }
        } else {
            int size = this.mechanism.targetKeyFields.size();
            key = new Object[size];
            for (int i = 0; i < size; ++i) {
                if (object == null) {
                    key[i] = null;
                    continue;
                }
                DatabaseField field = this.mechanism.targetKeyFields.get(i);
                key[i] = objectBuilder.extractValueFromObjectForField(object, field, session);
            }
        }
        return new CacheId(key);
    }

    @Override
    public Object extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord row) {
        List<DatabaseField> primaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        Object[] result = new Object[primaryKeyFields.size()];
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField targetKeyField = primaryKeyFields.get(index);
            DatabaseField sourceKeyField = this.getTargetToSourceKeyFields().get(targetKeyField);
            if (sourceKeyField == null) {
                return null;
            }
            result[index] = row.get(sourceKeyField);
            if (this.getReferenceDescriptor().getCacheKeyType() != CacheKeyType.ID_VALUE) continue;
            return result[index];
        }
        return new CacheId(result);
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
        if (!query.isDistinctComputed()) {
            ((ObjectLevelReadQuery)batchQuery).useDistinct();
        }
        if (this.mechanism != null) {
            ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
            mappingBatchQuery.setShouldIncludeData(true);
            Enumeration<DatabaseField> relationFieldsEnum = this.mechanism.getSourceRelationKeyFields().elements();
            while (relationFieldsEnum.hasMoreElements()) {
                mappingBatchQuery.getAdditionalFields().add(mappingBatchQuery.getExpressionBuilder().getTable(this.mechanism.getRelationTable()).getField(relationFieldsEnum.nextElement()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable<Object, Object> referenceObjectsByKey = null;
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceObjectsByKey = this.getBatchReadObjects(query, session);
            if (referenceObjectsByKey == null) {
                referenceObjectsByKey = new Hashtable<Object, Object>();
                if (this.mechanism == null) {
                    List results = (List)session.executeQuery(query, argumentRow);
                    for (Object eachReferenceObject : results) {
                        Object eachReferenceKey = this.extractKeyFromReferenceObject(eachReferenceObject, session);
                        referenceObjectsByKey.put(eachReferenceKey, session.wrapObject(eachReferenceObject));
                    }
                } else {
                    ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
                    ComplexQueryResult complexResult = (ComplexQueryResult)session.executeQuery(query, argumentRow);
                    List results = (List)complexResult.getResult();
                    List rows = (List)complexResult.getData();
                    int size = results.size();
                    Vector<DatabaseField> sourceKeyRelationFields = this.mechanism.getSourceRelationKeyFields();
                    Vector<DatabaseField> sourceKeyFields = this.mechanism.getSourceKeyFields();
                    int sourceSize = sourceKeyRelationFields.size();
                    for (int i = 0; i < size; ++i) {
                        AbstractRecord row = (AbstractRecord)rows.get(i);
                        Object[] key = new Object[sourceSize];
                        for (int k = 0; k < sourceSize; ++k) {
                            Object value = row.get((DatabaseField)sourceKeyRelationFields.get(k));
                            key[k] = conversionManager.convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification((DatabaseField)sourceKeyFields.get(k)));
                        }
                        referenceObjectsByKey.put(new CacheId(key), session.wrapObject(results.get(i)));
                    }
                }
                this.setBatchReadObjects(referenceObjectsByKey, query, session);
                query.setSession(null);
            }
        }
        return referenceObjectsByKey.get(this.extractForeignKeyFromRow(databaseRow, session));
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return this.buildSelectionCriteria(false, false);
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(this.getReferenceDescriptor().getTables().size() + 1);
        tables.addAll(this.getReferenceDescriptor().getTables());
        if (this.keyTableForMapKey != null) {
            tables.add(this.keyTableForMapKey);
        }
        return tables;
    }

    @Override
    protected ReadQuery getExtendPessimisticLockScopeDedicatedQuery(AbstractSession session, short lockMode) {
        if (this.mechanism != null) {
            return this.mechanism.getLockRelationTableQueryClone(session, lockMode);
        }
        return super.getExtendPessimisticLockScopeDedicatedQuery(session, lockMode);
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseField fieldInTarget = this.getSourceToTargetKeyFields().get(fieldToClassify);
        if (fieldInTarget == null) {
            return null;
        }
        DatabaseMapping mapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(fieldInTarget);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldInTarget);
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    protected Map getForeignKeysToPrimaryKeys() {
        if (this.isForeignKeyRelationship()) {
            return this.getSourceToTargetKeyFields();
        }
        return this.getTargetToSourceKeyFields();
    }

    @Override
    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return this.getSourceToTargetKeyFields();
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.getForeignKeyFields();
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        return this.prepareNestedJoins(joinManager, query, session);
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(this.getReferenceDescriptor().getAllFields().size() + this.getForeignKeyFields().size());
        fields.addAll(this.getReferenceDescriptor().getAllFields());
        fields.addAll(this.getForeignKeyFields());
        return fields;
    }

    public Vector getOrderedForeignKeyFields() {
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyDescriptor().getPrimaryKeyFields();
        Vector<DatabaseField> result = new Vector<DatabaseField>(primaryKeyFields.size());
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField pkField = primaryKeyFields.get(index);
            boolean found = false;
            for (DatabaseField fkField : this.getForeignKeysToPrimaryKeys().keySet()) {
                if (!this.getForeignKeysToPrimaryKeys().get(fkField).equals(pkField)) continue;
                found = true;
                result.addElement(fkField);
                break;
            }
            if (found) continue;
            throw DescriptorException.missingForeignKeyTranslation(this, pkField);
        }
        return result;
    }

    protected ClassDescriptor getPrimaryKeyDescriptor() {
        if (this.isForeignKeyRelationship()) {
            return this.getReferenceDescriptor();
        }
        return this.getDescriptor();
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    public Vector getSourceToTargetKeyFieldAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getSourceToTargetKeyFields().size());
        Iterator<DatabaseField> sourceFieldEnum = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator<DatabaseField> targetFieldEnum = this.getSourceToTargetKeyFields().values().iterator();
        while (sourceFieldEnum.hasNext()) {
            String fieldValue = sourceFieldEnum.next().getQualifiedName();
            String attributeValue = targetFieldEnum.next().getQualifiedName();
            associations.addElement(new Association(fieldValue, attributeValue));
        }
        return associations;
    }

    public Map<DatabaseField, DatabaseField> getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, Object parent, MergeManager mergeManager) {
        return mergeManager.getTargetVersionOfSourceObject(object);
    }

    @Override
    public Class getMapKeyTargetType() {
        return this.getReferenceClass();
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.mechanism != null) {
            if (this.mechanism.hasRelationTable()) {
                if (!(this.foreignKeyFields.isEmpty() && this.sourceToTargetKeyFields.isEmpty() && this.targetToSourceKeyFields.isEmpty())) {
                    throw DescriptorException.oneToOneMappingConflict(this.getDescriptor(), this);
                }
                this.foreignKeyFields = null;
                this.sourceToTargetKeyFields = null;
                this.targetToSourceKeyFields = null;
                this.mechanism.initialize(session, this);
            } else {
                this.mechanism = null;
            }
        }
        if (this.mechanism == null) {
            for (int index = 0; index < this.getForeignKeyFields().size(); ++index) {
                DatabaseField foreignKeyField = this.getForeignKeyFields().get(index);
                foreignKeyField = this.getDescriptor().buildField(foreignKeyField, this.keyTableForMapKey);
                this.getForeignKeyFields().set(index, foreignKeyField);
            }
            if (!this.getTargetToSourceKeyFields().isEmpty() || !this.getSourceToTargetKeyFields().isEmpty()) {
                if (this.getTargetToSourceKeyFields().isEmpty() || this.getSourceToTargetKeyFields().isEmpty()) {
                    this.initializeForeignKeysWithDefaults(session);
                } else {
                    this.initializeForeignKeys(session);
                }
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.shouldForceInitializationOfSelectionCriteria()) {
                this.setSelectionCriteria(this.buildSelectionCriteria());
            } else {
                this.setSelectionCriteria(this.buildSelectionCriteria(true, true));
            }
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, session);
        }
    }

    protected void initializeForeignKeys(AbstractSession session) {
        HashMap<DatabaseField, DatabaseField> newSourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size());
        HashMap<DatabaseField, DatabaseField> newTargetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField sourceField = entry.getKey();
            sourceField = this.getDescriptor().buildField(sourceField, this.keyTableForMapKey);
            DatabaseField targetField = entry.getValue();
            targetField = this.getReferenceDescriptor().buildField(targetField, this.keyTableForMapKey);
            newSourceToTargetKeyFields.put(sourceField, targetField);
            newTargetToSourceKeyFields.put(targetField, sourceField);
        }
        this.setSourceToTargetKeyFields(newSourceToTargetKeyFields);
        this.setTargetToSourceKeyFields(newTargetToSourceKeyFields);
    }

    protected void initializeForeignKeysWithDefaults(AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getSourceToTargetKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> targetKeys = this.getReferenceDescriptor().getPrimaryKeyFields();
            if (targetKeys.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField sourceField = this.getSourceToTargetKeyFields().keySet().iterator().next();
            sourceField = this.getDescriptor().buildField(sourceField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getSourceToTargetKeyFields().put(sourceField, targetKeys.get(0));
            this.getTargetToSourceKeyFields().put(targetKeys.get(0), sourceField);
        } else {
            if (this.getTargetToSourceKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> sourceKeys = this.getDescriptor().getPrimaryKeyFields();
            if (sourceKeys.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField targetField = this.getTargetToSourceKeyFields().keySet().iterator().next();
            targetField = this.getReferenceDescriptor().buildField(targetField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getTargetToSourceKeyFields().put(targetField, sourceKeys.get(0));
            this.getSourceToTargetKeyFields().put(sourceKeys.get(0), targetField);
        }
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression pkCriteria = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression backRef = builder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression newPKCriteria = pkCriteria.rebuildOn(backRef);
            Expression twistedSelection = backRef.twist(this.getSelectionCriteria(), builder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression rebuiltAdditional = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(backRef);
                twistedSelection = twistedSelection == null ? rebuiltAdditional : twistedSelection.and(rebuiltAdditional);
            }
            this.setPrivateOwnedCriteria(newPKCriteria.and(twistedSelection));
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable table) throws DescriptorException {
        this.keyTableForMapKey = table;
    }

    public void postInitializeMapValueSelectionQuery(ReadQuery selectionQuery, AbstractSession session) {
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceToTargetKeyFields(), !this.isForeignKeyRelationship());
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    public Expression buildSelectionCriteria() {
        return this.buildSelectionCriteria(true, false);
    }

    public Expression buildSelectionCriteria(boolean useParameter, boolean usePreviousSelectionCriteria) {
        Expression criteria = null;
        if (usePreviousSelectionCriteria) {
            criteria = this.getSelectionCriteria();
        }
        if (this.mechanism == null) {
            ExpressionBuilder builder = new ExpressionBuilder();
            if (this.getSourceToTargetKeyFields().isEmpty()) {
                throw DescriptorException.noForeignKeysAreSpecified(this);
            }
            for (DatabaseField foreignKey : this.getSourceToTargetKeyFields().keySet()) {
                DatabaseField targetKey = this.getSourceToTargetKeyFields().get(foreignKey);
                Expression expression = null;
                expression = useParameter ? ((Expression)builder).getField(targetKey).equal(builder.getParameter(foreignKey)) : ((Expression)builder).getField(targetKey).equal(((Expression)builder).getField(foreignKey));
                if (criteria == null) {
                    criteria = expression;
                    continue;
                }
                criteria = expression.and(criteria);
            }
        } else {
            criteria = this.mechanism.buildSelectionCriteria(this, criteria);
        }
        return criteria;
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        DatabaseRecord targetRow = new DatabaseRecord();
        for (DatabaseField foreignKey : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(foreignKey);
            targetRow.put(targetKey, databaseRow.get(foreignKey));
        }
        Object targetObject = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoShallowObject(targetObject, databaseRow, query);
        targetObject = this.getIndirectionPolicy().valueFromRow(targetObject);
        this.setAttributeValueInObject(original, targetObject);
    }

    @Override
    public boolean isOneToOneMapping() {
        return true;
    }

    @Override
    public boolean isOwned() {
        return this.hasRelationTable() && !this.isReadOnly;
    }

    @Override
    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return super.readPrivateOwnedForObject(modifyQuery);
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)readQuery, modifyQuery.getTranslationRow());
    }

    @Override
    public void rehashFieldDependancies(AbstractSession session) {
        this.setSourceToTargetKeyFields(Helper.rehashMap(this.getSourceToTargetKeyFields()));
    }

    public void setDefinedAsManyToOneMapping(boolean isDefinedAsManyToOneMapping) {
        this.isDefinedAsManyToOneMapping = isDefinedAsManyToOneMapping;
    }

    public void setForeignKeyFieldName(String sourceForeignKeyFieldName) {
        DatabaseField sourceField = new DatabaseField(sourceForeignKeyFieldName);
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(sourceField);
        this.getSourceToTargetKeyFields().put(sourceField, new DatabaseField());
    }

    public void setForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setForeignKeyFields(fields);
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean shouldVerifyDelete) {
        this.shouldVerifyDelete = shouldVerifyDelete;
    }

    public void setSourceToTargetKeyFieldAssociations(Vector sourceToTargetKeyFieldAssociations) {
        this.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(sourceToTargetKeyFieldAssociations.size() + 1));
        this.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(sourceToTargetKeyFieldAssociations.size() + 1));
        Enumeration associationsEnum = sourceToTargetKeyFieldAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            DatabaseField sourceField = new DatabaseField((String)association.getKey());
            DatabaseField targetField = new DatabaseField((String)association.getValue());
            this.getSourceToTargetKeyFields().put(sourceField, targetField);
            this.getTargetToSourceKeyFields().put(targetField, sourceField);
        }
    }

    public void setSourceToTargetKeyFields(Map<DatabaseField, DatabaseField> sourceToTargetKeyFields) {
        this.sourceToTargetKeyFields = sourceToTargetKeyFields;
    }

    public void setTargetForeignKeyFieldName(String targetForeignKeyFieldName) {
        DatabaseField targetField = new DatabaseField(targetForeignKeyFieldName);
        this.getTargetToSourceKeyFields().put(targetField, new DatabaseField());
    }

    public void setTargetToSourceKeyFields(Map<DatabaseField, DatabaseField> targetToSourceKeyFields) {
        this.targetToSourceKeyFields = targetToSourceKeyFields;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isDefinedAsManyToOneMapping() {
        return this.isDefinedAsManyToOneMapping;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        this.getIndirectionPolicy().iterateOnAttributeValue(iterator, element);
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return this.getDescriptor().getObjectBuilder().unwrapObject(key, session);
    }

    @Override
    public Object wrapKey(Object key, AbstractSession session) {
        return this.getDescriptor().getObjectBuilder().wrapObject(key, session);
    }

    @Override
    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(sourceKey);
            Object referenceValue = null;
            if (attribute != null) {
                referenceValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(attribute, targetKey, session);
            }
            row.add(sourceKey, referenceValue);
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        AbstractRecord referenceRow = this.indirectionPolicy.extractReferenceRow(attributeValue);
        if (referenceRow != null) {
            Object value = referenceRow.get(field);
            Class type = this.getFieldClassification(field);
            if (value == null || value.getClass() != type) {
                try {
                    value = session.getDatasourcePlatform().convertObject(value, type);
                }
                catch (ConversionException exception) {
                    throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), exception);
                }
            }
            return value;
        }
        Object referenceObject = this.getRealAttributeValueFromAttribute(attributeValue, object, session);
        if (referenceObject == null) {
            return null;
        }
        DatabaseField targetField = this.mechanism == null ? this.sourceToTargetKeyFields.get(field) : this.mechanism.targetKeyFields.get(this.mechanism.sourceKeyFields.indexOf(field));
        return this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetField, session);
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object key;
        AbstractRecord targetRow = this.trimRowForJoin(row, joinManager, executionSession);
        if (joinManager != null && joinManager.hasOuterJoinedAttributeQuery() && !sourceQuery.hasPartialAttributeExpressions() && (key = this.referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(targetRow, executionSession)) == null) {
            return this.indirectionPolicy.nullValueFromRow();
        }
        ObjectLevelReadQuery nestedQuery = this.prepareNestedJoinQueryClone(row, null, joinManager, sourceQuery, executionSession);
        nestedQuery.setTranslationRow(targetRow);
        Object referenceObject = this.referenceDescriptor.getObjectBuilder().buildObject(nestedQuery, targetRow);
        if (nestedQuery.shouldUseWrapperPolicy() && executionSession.isUnitOfWork()) {
            referenceObject = this.referenceDescriptor.getObjectBuilder().wrapObject(referenceObject, executionSession);
        }
        return this.indirectionPolicy.valueFromRow(referenceObject);
    }

    @Override
    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        int size = this.fields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)this.fields.get(index);
            if (row.get(field) != null) continue;
            return this.indirectionPolicy.nullValueFromRow();
        }
        return super.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly || !this.isForeignKeyRelationship) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        AbstractRecord referenceRow = this.indirectionPolicy.extractReferenceRow(attributeValue);
        if (referenceRow == null) {
            Object referenceObject = this.getRealAttributeValueFromAttribute(attributeValue, object, session);
            Vector<DatabaseField> foreignKeyFields = this.getForeignKeyFields();
            int size = foreignKeyFields.size();
            for (int index = 0; index < size; ++index) {
                DatabaseField sourceKey = (DatabaseField)foreignKeyFields.get(index);
                Object referenceValue = null;
                if (referenceObject != null) {
                    DatabaseField targetKey = this.sourceToTargetKeyFields.get(sourceKey);
                    referenceValue = this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKey, session);
                }
                databaseRow.add(sourceKey, referenceValue);
            }
        } else {
            Vector<DatabaseField> foreignKeyFields = this.getForeignKeyFields();
            int size = foreignKeyFields.size();
            for (int index = 0; index < size; ++index) {
                DatabaseField sourceKey = (DatabaseField)foreignKeyFields.get(index);
                databaseRow.add(sourceKey, referenceRow.get(sourceKey));
            }
        }
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord databaseRow, AbstractSession session) {
        if (!this.isReadOnly && this.isPrimaryKeyMapping && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord ChangeRecord2, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }

    public boolean hasRelationTableMechanism() {
        return this.mechanism != null;
    }

    public boolean hasRelationTable() {
        return this.mechanism != null && this.mechanism.hasRelationTable();
    }

    public RelationTableMechanism getRelationTableMechanism() {
        return this.mechanism;
    }

    public void setRelationTableMechanism(RelationTableMechanism mechanism) {
        this.mechanism = mechanism;
    }

    public DatabaseTable getRelationTable() {
        if (this.mechanism != null) {
            return this.mechanism.getRelationTable();
        }
        return null;
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.mechanism != null && !this.isReadOnly()) {
            AbstractRecord sourceRow = this.mechanism.buildRelationTableSourceRow(query.getObject(), query.getSession(), this);
            query.getSession().executeQuery((DatabaseQuery)this.mechanism.deleteQuery, sourceRow);
        }
        super.preDelete(query);
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        super.postInsert(query);
        if (this.mechanism != null && !this.isReadOnly()) {
            Object targetObject = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
            if (targetObject == null) {
                return;
            }
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{setObject, this.mechanism.buildRelationTableSourceRow(query.getObject(), query.getSession(), this), targetObject};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                AbstractRecord sourceAndTargetRow = this.mechanism.buildRelationTableSourceAndTargetRow(query.getObject(), targetObject, query.getSession(), (ForeignReferenceMapping)this);
                query.getSession().executeQuery((DatabaseQuery)this.mechanism.insertQuery, sourceAndTargetRow);
            }
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.mechanism == null) {
            super.postUpdate(query);
        } else {
            if (!this.isAttributeValueInstantiated(query.getObject())) {
                return;
            }
            AbstractRecord sourceRow = null;
            if (!this.isReadOnly()) {
                sourceRow = this.mechanism.buildRelationTableSourceRow(query.getObject(), query.getSession(), this);
                query.getSession().executeQuery((DatabaseQuery)this.mechanism.deleteQuery, sourceRow);
            }
            super.postUpdate(query);
            if (sourceRow != null) {
                Object targetObject = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
                if (targetObject == null) {
                    return;
                }
                if (query.shouldCascadeOnlyDependentParts()) {
                    Object[] event = new Object[]{setObject, sourceRow, targetObject};
                    query.getSession().getCommitManager().addDataModificationEvent(this, event);
                } else {
                    AbstractRecord sourceAndTargetRow = this.mechanism.addRelationTableTargetRow(targetObject, query.getSession(), sourceRow, this);
                    query.getSession().executeQuery((DatabaseQuery)this.mechanism.insertQuery, sourceAndTargetRow);
                }
            }
        }
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] != setObject) {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
        AbstractRecord sourceAndTargetRow = this.mechanism.addRelationTableTargetRow(event[2], session, (AbstractRecord)event[1], this);
        session.executeQuery((DatabaseQuery)this.mechanism.insertQuery, sourceAndTargetRow);
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        if (this.mechanism != null) {
            return new Vector<DatabaseField>(0);
        }
        return super.collectFields();
    }
}

