/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursor;

public abstract class Cursor
implements Enumeration,
Serializable {
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    protected transient AbstractSession session;
    protected transient AbstractSession executionSession;
    protected transient Vector fields;
    protected int size = -1;
    public transient CursorPolicy policy;
    protected Vector objectCollection;
    protected Map initiallyConformingIndex;
    protected Expression selectionCriteriaClone;
    protected AbstractRecord translationRow;
    protected int position;

    public Cursor() {
    }

    public Cursor(DatabaseCall call, CursorPolicy policy) {
        this.session = policy.getQuery().getSession();
        this.executionSession = this.session.getExecutionSession(policy.getQuery());
        this.statement = call.getStatement();
        this.fields = call.getFields();
        this.resultSet = call.getResult();
        this.policy = policy;
        this.setObjectCollection(new Vector());
        if (this.getQuery().getSession().isUnitOfWork() && this.getQuery().isObjectLevelReadQuery()) {
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
            query.registerResultInUnitOfWork(this, (UnitOfWorkImpl)this.session, this.getQuery().getTranslationRow(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DatabaseException {
        RuntimeException exception = null;
        try {
            block14: {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.getAccessor().closeCursor(this.getResultSet(), this.getSession());
                    this.getAccessor().closeStatement(this.getStatement(), this.getSession(), null);
                }
                catch (RuntimeException caughtException) {
                    exception = caughtException;
                }
                finally {
                    block15: {
                        try {
                            this.getSession().releaseReadConnection(this.getQuery().getAccessor());
                        }
                        catch (RuntimeException releaseException) {
                            if (exception != null) break block15;
                            throw releaseException;
                        }
                    }
                    if (exception == null) break block14;
                    throw exception;
                }
            }
            this.setResultSet(null);
        }
        catch (SQLException sqlException) {
            throw DatabaseException.sqlException(sqlException, this.getAccessor(), this.getSession(), false);
        }
    }

    protected void finalize() throws DatabaseException {
        this.close();
    }

    protected DatabaseAccessor getAccessor() {
        try {
            return (DatabaseAccessor)this.getQuery().getAccessor();
        }
        catch (ClassCastException e) {
            throw QueryException.invalidDatabaseAccessor(this.getQuery().getAccessor());
        }
    }

    protected abstract int getCursorSize() throws DatabaseException, QueryException;

    protected Vector getFields() {
        return this.fields;
    }

    public Map getInitiallyConformingIndex() {
        return this.initiallyConformingIndex;
    }

    public Vector getObjectCollection() {
        return this.objectCollection;
    }

    public int getPageSize() {
        return this.getPolicy().getPageSize();
    }

    public CursorPolicy getPolicy() {
        return this.policy;
    }

    public abstract int getPosition();

    public ReadQuery getQuery() {
        return this.getPolicy().getQuery();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Expression getSelectionCriteriaClone() {
        return this.selectionCriteriaClone;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    protected AbstractSession getExecutionSession() {
        return this.executionSession;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean isClosed() {
        return this.getResultSet() == null;
    }

    protected Object buildAndRegisterObject(AbstractRecord row) {
        Object object = null;
        if (this.getSession().isUnitOfWork() && !this.getQuery().isReportQuery() && this.getQuery().shouldMaintainCache() && this.getQuery().isObjectLevelReadQuery()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
            if (query.shouldConformResultsInUnitOfWork() || query.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
                object = query.conformIndividualResult(query.buildObject(row), unitOfWork, this.getTranslationRow(), this.getSelectionCriteriaClone(), this.getInitiallyConformingIndex());
                if (object == null) {
                    return InvalidObject.instance;
                }
            } else {
                object = query.buildObject(row);
            }
        } else {
            object = this.getQuery().buildObject(row);
        }
        return object;
    }

    protected Object retrieveNextObject() throws DatabaseException {
        AbstractRecord row;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            row = this.getAccessor().cursorRetrieveNextRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (row != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(row)) == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        AbstractRecord row;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            row = this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (row != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(row)) == InvalidObject.instance);
        return object;
    }

    protected void setFields(Vector fields) {
        this.fields = fields;
    }

    public void setInitiallyConformingIndex(Map index) {
        this.initiallyConformingIndex = index;
    }

    public void setObjectCollection(Vector collection) {
        this.objectCollection = collection;
    }

    public void setPolicy(CursorPolicy policy) {
        this.policy = policy;
    }

    protected void setPosition(int value) {
        this.position = value;
    }

    protected void setResultSet(ResultSet result) {
        this.resultSet = result;
    }

    public void setSelectionCriteriaClone(Expression expression) {
        this.selectionCriteriaClone = expression;
    }

    public void setSession(AbstractSession databaseSession) {
        this.session = databaseSession;
    }

    protected void setExecutionSession(AbstractSession executionSession) {
        this.executionSession = executionSession;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTranslationRow(AbstractRecord row) {
        this.translationRow = row;
    }

    public int size() throws DatabaseException {
        if (this.size == -1) {
            this.size = this.getCursorSize();
            if (this.getInitiallyConformingIndex() != null) {
                this.size += this.getInitiallyConformingIndex().size();
            }
        }
        return this.size;
    }
}

