/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FetchGroup
implements Serializable {
    private String name;
    private Set attributes;

    public FetchGroup() {
        this("");
    }

    public FetchGroup(String name) {
        this.name = name;
        this.attributes = new HashSet(10);
    }

    public boolean containsAttribute(String attribute) {
        return this.getAttributes().contains(attribute);
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public synchronized void addAttribute(String attrName) {
        this.attributes.add(attrName);
    }

    public void addAttributes(Collection newAttributes) {
        this.attributes.addAll(newAttributes);
    }

    public void removeAttribute(String attrName) {
        this.attributes.remove(attrName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSupersetOf(FetchGroup anotherGroup) {
        return anotherGroup != null && (this == anotherGroup || this.getAttributes().containsAll(anotherGroup.getAttributes()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getAttributes() + ")";
    }
}

