/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaPackageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCJavaClassImpl
implements JavaClass {
    private JDefinedClass xjcClass;
    private JClass xjcRefClass;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private static Field JDEFINEDCLASS_ANNOTATIONS = null;
    private static Field JDEFINEDCLASS_MODS = null;
    private static Field JDEFINEDCLASS_SUPERCLASS = null;
    private static Field JTYPEVAR_BOUND = null;
    private static final Map<String, JPrimitiveType> jPrimitiveTypes = new HashMap<String, JPrimitiveType>();

    public XJCJavaClassImpl(JClass jRefClass, JCodeModel codeModel, DynamicClassLoader loader) {
        this.xjcClass = null;
        this.xjcRefClass = jRefClass;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
    }

    public XJCJavaClassImpl(JDefinedClass jDefinedClass, JCodeModel codeModel, DynamicClassLoader loader) {
        this.xjcClass = jDefinedClass;
        this.xjcRefClass = null;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
    }

    public Collection<JavaClass> getActualTypeArguments() {
        JTypeVar[] typeParams = null;
        typeParams = this.xjcRefClass != null ? this.xjcRefClass.typeParams() : this.xjcClass.typeParams();
        ArrayList<JavaClass> typeArguments = new ArrayList<JavaClass>(typeParams.length);
        for (int i = 0; i < typeParams.length; ++i) {
            JTypeVar var = typeParams[i];
            JClass xjcBoundClass = null;
            try {
                xjcBoundClass = (JClass)PrivilegedAccessHelper.getValueFromField((Field)JTYPEVAR_BOUND, (Object)var);
            }
            catch (Exception e) {
                return null;
            }
            XJCJavaClassImpl boundClass = new XJCJavaClassImpl(xjcBoundClass, this.jCodeModel, this.dynamicClassLoader);
            typeArguments.add(boundClass);
        }
        return typeArguments;
    }

    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        throw new UnsupportedOperationException("getComponentType");
    }

    public JavaConstructor getConstructor(JavaClass[] parameterTypes) {
        JType[] xjcParameterTypes = new JType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaClass pType = parameterTypes[i];
            String className = pType.getQualifiedName();
            Object xjcType = null;
            xjcType = pType.isPrimitive() ? (JType)jPrimitiveTypes.get(className) : this.jCodeModel._getClass(className);
            xjcParameterTypes[i] = xjcType;
        }
        JMethod constructor = this.xjcClass.getConstructor(xjcParameterTypes);
        return new XJCJavaConstructorImpl(constructor, this.jCodeModel, this.dynamicClassLoader);
    }

    public Collection<JavaConstructor> getConstructors() {
        ArrayList<JavaConstructor> constructors = new ArrayList<JavaConstructor>();
        Iterator it = this.xjcClass.constructors();
        while (it.hasNext()) {
            constructors.add(new XJCJavaConstructorImpl((JMethod)it.next(), this.jCodeModel, this.dynamicClassLoader));
        }
        return constructors;
    }

    public Collection<JavaClass> getDeclaredClasses() {
        ArrayList<JavaClass> declaredClasses = new ArrayList<JavaClass>();
        if (this.xjcRefClass != null) {
            return declaredClasses;
        }
        Iterator it = this.xjcClass.classes();
        while (it.hasNext()) {
            declaredClasses.add(new XJCJavaClassImpl((JDefinedClass)it.next(), this.jCodeModel, this.dynamicClassLoader));
        }
        return declaredClasses;
    }

    public JavaConstructor getDeclaredConstructor(JavaClass[] parameterTypes) {
        return this.getConstructor(parameterTypes);
    }

    public Collection<JavaConstructor> getDeclaredConstructors() {
        return this.getConstructors();
    }

    public JavaField getDeclaredField(String fieldName) {
        JFieldVar xjcField = (JFieldVar)this.xjcClass.fields().get(fieldName);
        return new XJCJavaFieldImpl(xjcField, this.jCodeModel, this.dynamicClassLoader);
    }

    public Collection<JavaField> getDeclaredFields() {
        Collection xjcFields = this.xjcClass.fields().values();
        ArrayList<JavaField> fields = new ArrayList<JavaField>(xjcFields.size());
        for (JFieldVar jField : xjcFields) {
            fields.add(new XJCJavaFieldImpl(jField, this.jCodeModel, this.dynamicClassLoader));
        }
        return fields;
    }

    public JavaMethod getDeclaredMethod(String name, JavaClass[] args) {
        return this.getMethod(name, args);
    }

    public Collection<JavaMethod> getDeclaredMethods() {
        return this.getMethods();
    }

    public JavaMethod getMethod(String name, JavaClass[] args) {
        Collection xjcMethods = this.xjcClass.methods();
        for (JMethod xjcMethod : xjcMethods) {
            JType[] params = xjcMethod.listParamTypes();
            boolean argsAreEqual = this.argsAreEqual(args, params);
            if (!xjcMethod.name().equals(name) || !argsAreEqual) continue;
            return new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader);
        }
        return null;
    }

    private boolean argsAreEqual(JavaClass[] elinkArgs, JType[] xjcArgs) {
        if (elinkArgs == null && xjcArgs == null) {
            return true;
        }
        if (elinkArgs != null && xjcArgs == null) {
            return false;
        }
        if (elinkArgs == null && xjcArgs != null) {
            return false;
        }
        if (elinkArgs.length != xjcArgs.length) {
            return false;
        }
        for (int i = 0; i < elinkArgs.length; ++i) {
            JavaClass elinkClass = elinkArgs[i];
            JType xjcClass = xjcArgs[i];
            if (elinkClass.getName().equals(xjcClass.name())) continue;
            return false;
        }
        return true;
    }

    public Collection<JavaMethod> getMethods() {
        Collection xjcMethods = this.xjcClass.methods();
        ArrayList<JavaMethod> elinkMethods = new ArrayList<JavaMethod>(xjcMethods.size());
        for (JMethod xjcMethod : xjcMethods) {
            elinkMethods.add(new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader));
        }
        return elinkMethods;
    }

    public int getModifiers() {
        JMods xjcMods = null;
        try {
            xjcMods = (JMods)PrivilegedAccessHelper.getValueFromField((Field)JDEFINEDCLASS_MODS, (Object)this.xjcClass);
        }
        catch (Exception e) {
            return 0;
        }
        return xjcMods.getValue();
    }

    public String getName() {
        return this.getQualifiedName();
    }

    public JavaPackage getPackage() {
        if (this.xjcRefClass != null) {
            JPackage pkg = null;
            try {
                Field _packageField = PrivilegedAccessHelper.getDeclaredField(this.xjcRefClass.getClass(), (String)"_package", (boolean)true);
                pkg = (JPackage)PrivilegedAccessHelper.getValueFromField((Field)_packageField, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return null;
            }
            return new XJCJavaPackageImpl(pkg, this.dynamicClassLoader);
        }
        return new XJCJavaPackageImpl(this.xjcClass.getPackage(), this.dynamicClassLoader);
    }

    public String getPackageName() {
        if (this.xjcRefClass != null) {
            JPackage pkg = null;
            try {
                Method _packageMethod = PrivilegedAccessHelper.getDeclaredMethod(this.xjcRefClass.getClass(), (String)"_package", (Class[])new Class[0]);
                pkg = (JPackage)PrivilegedAccessHelper.invokeMethod((Method)_packageMethod, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return null;
            }
            return pkg.name();
        }
        return this.xjcClass._package().name();
    }

    public String getQualifiedName() {
        if (this.xjcRefClass != null) {
            String name = null;
            try {
                Method binaryNameMethod = PrivilegedAccessHelper.getDeclaredMethod(this.xjcRefClass.getClass(), (String)"binaryName", (Class[])new Class[0]);
                name = (String)PrivilegedAccessHelper.invokeMethod((Method)binaryNameMethod, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return null;
            }
            return name;
        }
        return this.getPackageName() + "." + this.xjcClass.name();
    }

    public String getRawName() {
        return this.getQualifiedName();
    }

    public JavaClass getSuperclass() {
        if (this.xjcRefClass != null) {
            return null;
        }
        try {
            JClass superClass = (JClass)PrivilegedAccessHelper.getValueFromField((Field)JDEFINEDCLASS_SUPERCLASS, (Object)this.xjcClass);
            if (superClass instanceof JDefinedClass) {
                return new XJCJavaClassImpl((JDefinedClass)superClass, this.jCodeModel, this.dynamicClassLoader);
            }
            return new XJCJavaClassImpl(superClass, this.jCodeModel, this.dynamicClassLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasActualTypeArguments() {
        if (this.xjcRefClass != null) {
            return this.xjcRefClass.typeParams().length > 0;
        }
        return this.xjcClass.typeParams().length > 0;
    }

    public boolean isAbstract() {
        return this.xjcClass.isAbstract();
    }

    public boolean isAnnotation() {
        if (this.xjcRefClass != null) {
            return false;
        }
        return this.xjcClass.isAnnotationTypeDeclaration();
    }

    public boolean isArray() {
        if (this.xjcRefClass != null) {
            boolean isArray = false;
            try {
                Field isArrayField = PrivilegedAccessHelper.getDeclaredField(this.xjcRefClass.getClass(), (String)"isArray", (boolean)true);
                isArray = (Boolean)PrivilegedAccessHelper.getValueFromField((Field)isArrayField, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return false;
            }
            return isArray;
        }
        return this.xjcClass.isArray();
    }

    public boolean isAssignableFrom(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        Object someClass = null;
        XJCJavaClassImpl javaClassImpl = (XJCJavaClassImpl)javaClass;
        someClass = javaClassImpl.isXJCRefClass() ? javaClassImpl.xjcRefClass : javaClassImpl.xjcClass;
        return this.xjcClass.isAssignableFrom(someClass);
    }

    public boolean isEnum() {
        return this.xjcClass.getClassType().equals(ClassType.ENUM);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isInterface() {
        if (this.xjcRefClass != null) {
            boolean isInterface = false;
            try {
                Field isInterfaceField = PrivilegedAccessHelper.getDeclaredField(this.xjcRefClass.getClass(), (String)"isInterface", (boolean)true);
                isInterface = (Boolean)PrivilegedAccessHelper.getValueFromField((Field)isInterfaceField, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return false;
            }
            return isInterface;
        }
        return this.xjcClass.isInterface();
    }

    public boolean isMemberClass() {
        throw new UnsupportedOperationException("isMemberClass");
    }

    public boolean isPrimitive() {
        if (this.xjcRefClass != null) {
            Object primitiveType = null;
            try {
                Method getPrimitiveTypeMethod = PrivilegedAccessHelper.getDeclaredMethod(this.xjcRefClass.getClass(), (String)"getPrimitiveType", (Class[])new Class[0]);
                primitiveType = PrivilegedAccessHelper.invokeMethod((Method)getPrimitiveTypeMethod, (Object)this.xjcRefClass);
            }
            catch (Exception e) {
                return false;
            }
            return primitiveType != null;
        }
        return this.xjcClass.isPrimitive();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (this.xjcRefClass != null) {
            return null;
        }
        if (aClass != null) {
            Collection annotations = null;
            try {
                annotations = (Collection)PrivilegedAccessHelper.getValueFromField((Field)JDEFINEDCLASS_ANNOTATIONS, (Object)this.xjcClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (annotations == null) {
                return null;
            }
            for (JAnnotationUse annotationUse : annotations) {
                String annotationClass;
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                String myAnnotationClass = xjcAnnotation.getJavaAnnotationClass().getCanonicalName();
                if (!myAnnotationClass.equals(annotationClass = aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = null;
        try {
            annotations = (Collection)PrivilegedAccessHelper.getValueFromField((Field)JDEFINEDCLASS_ANNOTATIONS, (Object)this.xjcClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (annotations == null) {
            return annotationsList;
        }
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        throw new UnsupportedOperationException("getDeclaredAnnotation");
    }

    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        throw new UnsupportedOperationException("getDeclaredAnnotations");
    }

    boolean isXJCRefClass() {
        return this.xjcRefClass != null;
    }

    static {
        JCodeModel tempCodeModel = new JCodeModel();
        jPrimitiveTypes.put("java.lang.Boolean", tempCodeModel.BOOLEAN);
        jPrimitiveTypes.put("java.lang.Byte", tempCodeModel.BYTE);
        jPrimitiveTypes.put("java.lang.Character", tempCodeModel.CHAR);
        jPrimitiveTypes.put("java.lang.Double", tempCodeModel.DOUBLE);
        jPrimitiveTypes.put("java.lang.Float", tempCodeModel.FLOAT);
        jPrimitiveTypes.put("java.lang.Integer", tempCodeModel.INT);
        jPrimitiveTypes.put("java.lang.Long", tempCodeModel.LONG);
        jPrimitiveTypes.put("java.lang.Short", tempCodeModel.SHORT);
        try {
            JDEFINEDCLASS_ANNOTATIONS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, (String)"annotations", (boolean)true);
            JDEFINEDCLASS_MODS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, (String)"mods", (boolean)true);
            JDEFINEDCLASS_SUPERCLASS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, (String)"superClass", (boolean)true);
            JTYPEVAR_BOUND = PrivilegedAccessHelper.getDeclaredField(JTypeVar.class, (String)"bound", (boolean)true);
        }
        catch (Exception e) {
            throw JAXBException.errorCreatingDynamicJAXBContext((Exception)e);
        }
    }
}

