/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.IndexExpression;
import org.eclipse.persistence.internal.expressions.NestedTable;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryKeyExpression
extends ObjectExpression {
    protected String name;
    protected DatabaseField aliasedField;
    protected boolean shouldQueryToManyRelationship;
    protected transient QueryKey queryKey;
    protected boolean hasQueryKey;
    protected transient DatabaseMapping mapping;
    protected boolean hasMapping;
    protected Boolean isAttributeExpression;
    protected IndexExpression index;

    public QueryKeyExpression() {
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public QueryKeyExpression(String aName, Expression base) {
        this.name = aName;
        this.baseExpression = base;
        this.shouldUseOuterJoin = false;
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        QueryKeyExpression expression = (QueryKeyExpression)object;
        if (this.shouldQueryToManyRelationship() || expression.shouldQueryToManyRelationship()) {
            return false;
        }
        return this.getName() == expression.getName() || this.getName() != null && this.getName().equals(expression.getName());
    }

    @Override
    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getName() != null) {
            hashCode += this.getName().hashCode();
        }
        return hashCode;
    }

    @Override
    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (criteria != null) {
            criteria = this.getBaseExpression().twist(criteria, this);
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                criteria.convertToUseOuterJoin();
            }
        }
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            childrenCriteria = this.getBaseExpression().twist(childrenCriteria, this);
            childrenCriteria.convertToUseOuterJoin();
            criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            Expression historyCriteria = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            criteria = criteria != null ? criteria.and(historyCriteria) : historyCriteria;
        }
        return criteria;
    }

    @Override
    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
        Vector<DatabaseTable> tables = this.getDescriptor().getTables();
        int tablesSize = tables.size();
        if (this.shouldUseOuterJoin()) {
            for (int i = 1; i < tablesSize; ++i) {
                DatabaseTable table = tables.elementAt(i);
                Expression joinExpression = (Expression)this.getDescriptor().getQueryManager().getTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression().twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            List<DatabaseTable> childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            tablesSize = childrenTables.size();
            for (int i = 0; i < tablesSize; ++i) {
                DatabaseTable table = childrenTables.get(i);
                Expression joinExpression = this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression().twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        return tablesJoinExpressions;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        DatabaseMapping mapping = this.getMapping();
        if (this.isAttribute() || mapping != null && (mapping.isAggregateObjectMapping() || mapping.isTransformationMapping())) {
            return ((DataExpression)this.getBaseExpression()).aliasForTable(table);
        }
        if (mapping != null && (mapping.isReferenceMapping() || mapping.isStructureMapping())) {
            DatabaseTable alias = this.getBaseExpression().aliasForTable(mapping.getDescriptor().getTables().firstElement());
            alias.setName(alias.getName() + "." + mapping.getField().getName());
            return alias;
        }
        if (mapping != null && mapping.isDirectCollectionMapping()) {
            DatabaseTable aliasedTable;
            if (this.tableAliases != null && (aliasedTable = this.tableAliases.keyAtValue(table)) != null) {
                return aliasedTable;
            }
            return this.getTable(table).aliasForTable(table);
        }
        return super.aliasForTable(table);
    }

    @Override
    public Expression as(Class castClass) {
        QueryKeyExpression clonedExpression = new QueryKeyExpression(this.getName(), this.getBaseExpression());
        clonedExpression.shouldQueryToManyRelationship = this.shouldQueryToManyRelationship;
        clonedExpression.shouldUseOuterJoin = this.shouldUseOuterJoin;
        clonedExpression.hasQueryKey = this.hasQueryKey;
        clonedExpression.hasMapping = this.hasMapping;
        clonedExpression.setCastClass(castClass);
        return clonedExpression;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.index != null) {
            this.index = (IndexExpression)this.index.copiedVersionFrom(alreadyDone);
        }
    }

    @Override
    public String descriptionOfNodeType() {
        return "Query Key";
    }

    public void doQueryToManyRelationship() {
        this.shouldQueryToManyRelationship = true;
    }

    @Override
    public List<DatabaseTable> getAdditionalTables() {
        if (this.mapping != null && this.mapping.isCollectionMapping()) {
            return ((CollectionMapping)this.mapping).getContainerPolicy().getAdditionalTablesForJoinQuery();
        }
        return null;
    }

    @Override
    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    protected DatabaseTable getAliasedTable() {
        DataExpression base = (DataExpression)this.getBaseExpression();
        DatabaseTable alias = base.aliasForTable(this.getField().getTable());
        if (alias == null) {
            return this.getField().getTable();
        }
        return alias;
    }

    public ClassDescriptor getContainingDescriptor() {
        return ((DataExpression)this.getBaseExpression()).getDescriptor();
    }

    @Override
    public DatabaseField getField() {
        if (!this.isAttribute()) {
            return null;
        }
        return this.getContainingDescriptor().getObjectBuilder().getFieldForQueryKeyName(this.getName());
    }

    @Override
    public Vector getFields() {
        List<DatabaseField> fields;
        if (this.isAttribute()) {
            Vector<DatabaseField> result = new Vector<DatabaseField>(1);
            DatabaseField field = this.getField();
            if (field != null) {
                result.addElement(field);
            }
            return result;
        }
        Vector<DatabaseField> result = new Vector<DatabaseField>();
        result.addAll(super.getFields());
        if (this.mapping.isCollectionMapping() && (fields = this.mapping.getContainerPolicy().getAdditionalFieldsForJoin((CollectionMapping)this.mapping)) != null) {
            result.addAll(fields);
        }
        return result;
    }

    @Override
    public Object getFieldValue(Object objectValue, AbstractSession session) {
        DatabaseMapping mapping = this.getMapping();
        Vector fieldValue = objectValue;
        if (mapping != null && (mapping.isDirectToFieldMapping() || mapping.isDirectCollectionMapping())) {
            if (objectValue instanceof Collection) {
                Collection values = objectValue;
                Vector fieldValues = new Vector(values.size());
                for (Object value : values) {
                    if (!(value instanceof Expression)) {
                        value = this.getFieldValue(value, session);
                    }
                    fieldValues.add(value);
                }
                fieldValue = fieldValues;
            } else if (mapping.isDirectToFieldMapping()) {
                fieldValue = ((AbstractDirectMapping)mapping).getFieldValue(objectValue, session);
            } else if (mapping.isDirectCollectionMapping()) {
                fieldValue = ((DirectCollectionMapping)mapping).getFieldValue(objectValue, session);
            }
        }
        return fieldValue;
    }

    @Override
    public DatabaseMapping getMapping() {
        if (!this.hasMapping) {
            return null;
        }
        if (this.mapping == null) {
            this.mapping = super.getMapping();
            if (this.mapping == null) {
                this.hasMapping = false;
            }
        }
        return this.mapping;
    }

    public DatabaseMapping getMappingFromQueryKey() {
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey == null || !(queryKey instanceof DirectQueryKey)) {
            throw QueryException.cannotConformExpression();
        }
        this.mapping = queryKey.getDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)queryKey).getField());
        if (this.mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return this.mapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Vector getOwnedTables() {
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            Vector<NestedTable> nestedTable = null;
            nestedTable = this.shouldQueryToManyRelationship() ? (Vector<NestedTable>)super.getOwnedTables().clone() : new Vector<NestedTable>(1);
            nestedTable.addElement(new NestedTable(this));
            return nestedTable;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            return null;
        }
        return super.getOwnedTables();
    }

    @Override
    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        if (this.getContainingDescriptor() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        if (this.queryKey == null) {
            this.queryKey = this.getContainingDescriptor().getQueryKeyNamed(this.getName());
            if (this.queryKey == null) {
                this.hasQueryKey = false;
            }
        }
        return this.queryKey;
    }

    @Override
    public Expression index() {
        if (this.index == null) {
            this.index = new IndexExpression(this);
        }
        return this.index;
    }

    protected void initializeAliasedField() {
        DatabaseField tempField = this.getField().clone();
        DatabaseTable aliasedTable = this.getAliasedTable();
        this.aliasedField = tempField;
        this.aliasedField.setTable(aliasedTable);
    }

    @Override
    public boolean isAttribute() {
        if (this.isAttributeExpression == null) {
            if (this.getSession() == null) {
                return false;
            }
            QueryKey queryKey = this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.isAttributeExpression = queryKey.isDirectQueryKey();
            } else {
                DatabaseMapping mapping = this.getMapping();
                if (mapping != null) {
                    if (mapping.isVariableOneToOneMapping()) {
                        throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(mapping, mapping.getDescriptor());
                    }
                    this.isAttributeExpression = mapping.isDirectToFieldMapping();
                } else {
                    this.isAttributeExpression = Boolean.FALSE;
                }
            }
        }
        return this.isAttributeExpression;
    }

    @Override
    public boolean isQueryKeyExpression() {
        return true;
    }

    @Override
    public Expression mappingCriteria() {
        Expression selectionCriteria;
        if (this.getQueryKeyOrNull() == null) {
            if (this.getMapping() == null || !this.getMapping().isForeignReferenceMapping()) {
                return null;
            }
            selectionCriteria = ((ForeignReferenceMapping)this.getMapping()).getJoinCriteria(this);
        } else {
            if (!this.getQueryKeyOrNull().isForeignReferenceQueryKey()) {
                return null;
            }
            selectionCriteria = ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getJoinCriteria();
            selectionCriteria = this.getBaseExpression().twist(selectionCriteria, this);
        }
        if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
            selectionCriteria = selectionCriteria.convertToUseOuterJoin();
        }
        return selectionCriteria;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        return this.normalize(normalizer, null);
    }

    public Expression normalize(ExpressionNormalizer normalizer, Vector foreignKeyJoinPointer) {
        Expression mappingExpression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        super.normalize(normalizer);
        this.setHasBeenNormalized(true);
        if (this.getMapping() != null && this.getMapping().isDirectToXMLTypeMapping()) {
            normalizer.getStatement().setRequiresAliases(true);
        }
        if (this.isAttribute()) {
            return this;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            normalizer.getStatement().setRequiresAliases(true);
            return this;
        }
        if (this.shouldQueryToManyRelationship() && !normalizer.getStatement().isDistinctComputed() && !normalizer.getStatement().isAggregateSelect()) {
            normalizer.getStatement().useDistinct();
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            if (!this.shouldQueryToManyRelationship()) {
                return this;
            }
            normalizer.getStatement().dontUseDistinct();
        }
        if ((mappingExpression = this.mappingCriteria()) != null) {
            mappingExpression = mappingExpression.normalize(normalizer);
        }
        if (mappingExpression != null) {
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin()) {
                normalizer.getStatement().getOuterJoinExpressions().addElement(this);
                normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(mappingExpression);
                normalizer.addAdditionalExpression(mappingExpression.and(this.additionalExpressionCriteria()));
                return this;
            }
            if ((this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                if (this.shouldUseOuterJoin()) {
                    Expression historyCriteria;
                    normalizer.getStatement().getOuterJoinExpressions().addElement(this);
                    normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(mappingExpression);
                    normalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    normalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(null);
                    if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null && (historyCriteria = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this)) != null) {
                        normalizer.addAdditionalExpression(historyCriteria);
                    }
                    return this;
                }
                if (this.isUsingOuterJoinForMultitableInheritance()) {
                    normalizer.getStatement().getOuterJoinExpressions().addElement(null);
                    normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(null);
                    normalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    normalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(this.getMapping().getReferenceDescriptor());
                }
            }
            if (foreignKeyJoinPointer != null) {
                foreignKeyJoinPointer.add(mappingExpression);
            } else {
                normalizer.addAdditionalExpression(mappingExpression.and(this.additionalExpressionCriteria()));
            }
        }
        return this;
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        if (this.isAttribute()) {
            printer.printField(this.getAliasedField());
        }
        if (!this.isAttribute() && this.getMapping() != null && this.getMapping().isDirectCollectionMapping()) {
            DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)this.getMapping();
            TableExpression table = (TableExpression)this.getTable(directCollectionMapping.getReferenceTable());
            DatabaseTable aliasedTable = table.aliasForTable(table.getTable());
            DatabaseField aliasedField = directCollectionMapping.getDirectField().clone();
            aliasedField.setTable(aliasedTable);
            printer.printField(aliasedField);
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            DatabaseTable tableAlias = this.aliasForTable(new NestedTable(this));
            printer.printString(tableAlias.getName());
        }
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        this.getBaseExpression().printJava(printer);
        if (!this.shouldUseOuterJoin()) {
            if (!this.shouldQueryToManyRelationship()) {
                printer.printString(".get(");
            } else {
                printer.printString(".anyOf(");
            }
        } else if (!this.shouldQueryToManyRelationship()) {
            printer.printString(".getAllowingNull(");
        } else {
            printer.printString(".anyOfAllowingNone(");
        }
        printer.printString("\"" + this.getName() + "\")");
        if (this.castClass != null) {
            printer.printString(".cast(" + this.castClass.getName() + ".class)");
        }
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        QueryKeyExpression result = null;
        result = this.shouldUseOuterJoin ? (QueryKeyExpression)newLocalBase.getAllowingNull(this.getName()) : (QueryKeyExpression)newLocalBase.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        if (this.castClass != null) {
            result.setCastClass(this.castClass);
        }
        return result;
    }

    public Expression rebuildOn(Expression oldBase, Expression newBase) {
        if (this == oldBase) {
            return newBase;
        }
        Expression newLocalBase = ((QueryKeyExpression)this.getBaseExpression()).rebuildOn(oldBase, newBase);
        QueryKeyExpression result = null;
        result = this.shouldUseOuterJoin ? (QueryKeyExpression)newLocalBase.getAllowingNull(this.getName()) : (QueryKeyExpression)newLocalBase.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return result;
    }

    @Override
    protected void resetCache() {
        this.hasMapping = true;
        this.mapping = null;
        this.hasQueryKey = true;
        this.queryKey = null;
    }

    public boolean shouldQueryToManyRelationship() {
        return this.shouldQueryToManyRelationship;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context);
        QueryKeyExpression result = (QueryKeyExpression)twistedBase.get(this.getName());
        if (this.shouldUseOuterJoin) {
            result.doUseOuterJoin();
        }
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateNode() {
        void var3_7;
        if (this.getQueryKeyOrNull() == null && this.getMapping() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        DatabaseMapping mapping = this.getMapping();
        Object var3_3 = null;
        boolean qkIsToMany = false;
        if (queryKey != null) {
            QueryKey queryKey2 = queryKey;
            qkIsToMany = queryKey.isManyToManyQueryKey() || queryKey.isOneToManyQueryKey();
        }
        boolean isNestedMapping = false;
        if (mapping != null) {
            if (!(!this.shouldUseOuterJoin || mapping.isOneToOneMapping() || mapping.isOneToManyMapping() || mapping.isManyToManyMapping() || mapping.isAggregateCollectionMapping() || mapping.isDirectCollectionMapping())) {
                throw QueryException.outerJoinIsOnlyValidForOneToOneMappings(this.getMapping());
            }
            qkIsToMany = mapping.isCollectionMapping();
            if (this.index != null) {
                if (!qkIsToMany) throw QueryException.indexRequiresCollectionMappingWithListOrderField(this, mapping);
                CollectionMapping collectionMapping = (CollectionMapping)this.getMapping();
                if (collectionMapping.getListOrderField() == null) throw QueryException.indexRequiresCollectionMappingWithListOrderField(this, collectionMapping);
                this.index.setField(collectionMapping.getListOrderField());
                this.addDerivedField(this.index);
            }
            isNestedMapping = mapping.isNestedTableMapping();
            DatabaseMapping databaseMapping = mapping;
        } else if (this.index != null) {
            throw QueryException.indexRequiresCollectionMappingWithListOrderField(this, null);
        }
        if (!this.shouldQueryToManyRelationship() && qkIsToMany && !isNestedMapping) {
            throw QueryException.invalidUseOfToManyQueryKeyInExpression(var3_7);
        }
        if (!this.shouldQueryToManyRelationship() || qkIsToMany) return;
        throw QueryException.invalidUseOfAnyOfInExpression(var3_7);
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (!this.getBaseExpression().isExpressionBuilder() && this.getBaseExpression().isQueryKeyExpression()) {
            object = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (object == null) {
                return null;
            }
            if (object instanceof Vector) {
                Vector<Object> comparisonVector = new Vector<Object>(((Vector)object).size() + 2);
                Enumeration valuesToIterate = ((Vector)object).elements();
                while (valuesToIterate.hasMoreElements()) {
                    Object vectorObject = valuesToIterate.nextElement();
                    if (vectorObject == null) {
                        comparisonVector.addElement(vectorObject);
                        continue;
                    }
                    Object valueOrValues = this.valuesFromCollection(vectorObject, session, valueHolderPolicy, isObjectUnregistered);
                    if (valueOrValues instanceof Vector) {
                        Enumeration nestedValuesToIterate = ((Vector)valueOrValues).elements();
                        while (nestedValuesToIterate.hasMoreElements()) {
                            comparisonVector.addElement(nestedValuesToIterate.nextElement());
                        }
                        continue;
                    }
                    comparisonVector.addElement(valueOrValues);
                }
                return comparisonVector;
            }
        }
        return this.valuesFromCollection(object, session, valueHolderPolicy, isObjectUnregistered);
    }

    public Object valuesFromCollection(Object object, AbstractSession session, int valueHolderPolicy, boolean isObjectUnregistered) {
        FetchGroupManager fetchGroupManager;
        DatabaseMapping mapping;
        ClassDescriptor descriptor;
        boolean readMappingFromQueryKey = false;
        if (this.getMapping() == null) {
            this.getMappingFromQueryKey();
            readMappingFromQueryKey = true;
        }
        if ((descriptor = (mapping = this.mapping).getDescriptor()).hasInheritance() && descriptor.getJavaClass() != object.getClass()) {
            mapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForAttributeName(this.getName());
            descriptor = mapping.getDescriptor();
        }
        if (descriptor.hasFetchGroupManager() && (fetchGroupManager = descriptor.getFetchGroupManager()).isPartialObject(object) && !fetchGroupManager.isAttributeFetched(object, mapping.getAttributeName())) {
            throw QueryException.cannotConformUnfetchedAttribute(mapping.getAttributeName());
        }
        if (mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).valueFromObject(object, mapping.getField(), session);
        }
        if (mapping.isForeignReferenceMapping()) {
            Object clone;
            UnitOfWorkImpl uow;
            Object valueFromMapping = mapping.getAttributeValueFromObject(object);
            if (!((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(valueFromMapping) && valueHolderPolicy != 1) {
                throw QueryException.mustInstantiateValueholders();
            }
            Object valueToIterate = mapping.getRealAttributeValueFromObject(object, session);
            UnitOfWorkImpl unitOfWorkImpl = uow = isObjectUnregistered ? (UnitOfWorkImpl)session : null;
            if (mapping.isCollectionMapping() && valueToIterate != null) {
                valueToIterate = mapping.getContainerPolicy().vectorFor(valueToIterate, session);
                if (isObjectUnregistered && uow.getCloneMapping().get(object) == null) {
                    Vector objectValues = (Vector)valueToIterate;
                    for (int i = 0; i < objectValues.size(); ++i) {
                        Object original = objectValues.elementAt(i);
                        Object clone2 = uow.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(original);
                        if (clone2 == null) continue;
                        objectValues.setElementAt(clone2, i);
                    }
                }
            } else if (isObjectUnregistered && uow.getCloneMapping().get(object) == null && (clone = uow.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(valueToIterate)) != null) {
                valueToIterate = clone;
            }
            return valueToIterate;
        }
        if (mapping.isAggregateMapping()) {
            Object aggregateValue = mapping.getAttributeValueFromObject(object);
            while (readMappingFromQueryKey && mapping.isAggregateObjectMapping() && !((AggregateObjectMapping)mapping).getReferenceClass().equals(this.queryKey.getDescriptor().getJavaClass())) {
                mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)this.queryKey).getField());
                aggregateValue = mapping.getRealAttributeValueFromObject(aggregateValue, session);
            }
            return aggregateValue;
        }
        throw QueryException.cannotConformExpression();
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getName());
        if (this.castClass != null) {
            writer.write(" (" + this.castClass.getName() + ") ");
        }
        writer.write(this.tableAliasesDescription());
    }

    public boolean isNormalizationRequired() {
        return this.shouldQueryToManyRelationship() || this.getMapping() == null || (this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() || this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin();
    }

    public boolean isDirectCollection() {
        if (this.getMapping() != null) {
            return this.getMapping().isDirectCollectionMapping();
        }
        if (this.getQueryKeyOrNull() != null) {
            return this.queryKey.isDirectCollectionQueryKey();
        }
        return false;
    }

    public boolean isOneToOne() {
        if (this.getMapping() != null) {
            return this.getMapping().isOneToOneMapping();
        }
        if (this.getQueryKeyOrNull() != null) {
            return this.queryKey.isOneToOneQueryKey();
        }
        return false;
    }

    public boolean isOneToMany() {
        if (this.getMapping() != null) {
            return this.getMapping().isOneToManyMapping();
        }
        if (this.getQueryKeyOrNull() != null) {
            return this.queryKey.isOneToManyQueryKey();
        }
        return false;
    }

    public boolean isManyToMany() {
        if (this.getMapping() != null) {
            return this.getMapping().isManyToManyMapping();
        }
        if (this.getQueryKeyOrNull() != null) {
            return this.queryKey.isManyToManyQueryKey();
        }
        return false;
    }

    public boolean isMapKeyObjectRelationship() {
        if (this.getMapping() != null) {
            return this.getMapping().isCollectionMapping() && ((CollectionMapping)this.getMapping()).isMapKeyObjectRelationship();
        }
        return false;
    }

    public ClassDescriptor getMapKeyDescriptor() {
        return ((CollectionMapping)this.getMapping()).getContainerPolicy().getDescriptorForMapKey();
    }

    public DatabaseTable getReferenceTable() {
        if (this.getMapping() != null) {
            if (this.getMapping().isDirectCollectionMapping()) {
                return ((DirectCollectionMapping)this.getMapping()).getReferenceTable();
            }
            return this.getMapping().getReferenceDescriptor().getTables().firstElement();
        }
        return ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getReferenceTable(this.getDescriptor());
    }

    public DatabaseTable getSourceTable() {
        if (this.getMapping() != null) {
            if (this.getMapping().isObjectReferenceMapping() && ((ObjectReferenceMapping)this.getMapping()).isForeignKeyRelationship()) {
                return this.getMapping().getFields().firstElement().getTable();
            }
            return ((ObjectExpression)this.getBaseExpression()).getDescriptor().getTables().firstElement();
        }
        return ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getSourceTable();
    }

    public DatabaseTable getRelationTable() {
        if (this.getMapping() != null) {
            if (this.getMapping().isManyToManyMapping()) {
                return ((ManyToManyMapping)this.getMapping()).getRelationTable();
            }
            if (this.getMapping().isOneToOneMapping()) {
                return ((OneToOneMapping)this.getMapping()).getRelationTable();
            }
        } else if (this.getQueryKeyOrNull().isForeignReferenceQueryKey()) {
            return ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getRelationTable(this.getDescriptor());
        }
        return null;
    }
}

