/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataFactory m_factory;
    protected MetadataProject m_project;
    protected AbstractSession m_session;

    public MetadataProcessor(PersistenceUnitInfo puInfo, AbstractSession session, ClassLoader loader, boolean enableLazyForOneToOne, boolean weaveEager) {
        this.m_loader = loader;
        this.m_session = session;
        this.m_project = new MetadataProject(puInfo, session, enableLazyForOneToOne, weaveEager);
    }

    public void addEntityListeners() {
        for (EntityAccessor accessor : this.m_project.getEntityAccessors()) {
            accessor.setJavaClass(accessor.getDescriptor().getJavaClass());
            accessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processQueries(this.m_loader);
    }

    public MetadataFactory getMetadataFactory() {
        return this.m_factory;
    }

    public Set<String> getPersistenceUnitClassSetFromMappingFiles() {
        HashSet<String> classSet = new HashSet<String>();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            for (EntityAccessor entity : entityMappings.getEntities()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(entity.getClassName()));
            }
            for (EmbeddableAccessor embeddable : entityMappings.getEmbeddables()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(embeddable.getClassName()));
            }
            for (MappedSuperclassAccessor mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(mappedSuperclass.getClassName()));
            }
        }
        return classSet;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<StructConverter> getStructConverters() {
        ArrayList<StructConverter> structConverters = new ArrayList<StructConverter>();
        for (StructConverterMetadata converter : this.m_project.getStructConverters()) {
            StructConverter structConverter = (StructConverter)MetadataHelper.getClassInstance(converter.getConverterClassName(), this.m_loader);
            structConverters.add(structConverter);
        }
        return structConverters;
    }

    protected void handleORMException(RuntimeException e, String mappingFile, boolean throwException) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(4, "error_loading_xml_file", new Object[]{mappingFile, e});
        } else if (!throwException) {
            this.m_session.log(4, "ejb_or_metadata", "error_loading_xml_file", new Object[]{mappingFile, e});
        } else {
            this.m_session.handleException(e);
        }
    }

    protected void initPersistenceUnitClasses() {
        HashMap<String, EntityAccessor> entities = new HashMap<String, EntityAccessor>();
        HashMap<String, EmbeddableAccessor> embeddables = new HashMap<String, EmbeddableAccessor>();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.initPersistenceUnitClasses(entities, embeddables);
        }
        for (EntityAccessor entity : entities.values()) {
            this.m_project.addEntityAccessor(entity);
            entity.getEntityMappings().processEntityMappingsDefaults(entity);
        }
        for (EmbeddableAccessor embeddable : embeddables.values()) {
            this.m_project.addEmbeddableAccessor(embeddable);
            embeddable.getEntityMappings().processEntityMappingsDefaults(embeddable);
        }
        PersistenceUnitInfo persistenceUnitInfo = this.m_project.getPersistenceUnitInfo();
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(persistenceUnitInfo.getManagedClassNames());
        for (URL url : persistenceUnitInfo.getJarFileUrls()) {
            classNames.addAll(PersistenceUnitProcessor.getClassNamesFromURL(url, this.m_loader));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            classNames.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), this.m_loader));
        }
        for (String className : classNames) {
            MetadataClass candidateClass = this.m_factory.getMetadataClass(className);
            if (candidateClass == null) continue;
            if (PersistenceUnitProcessor.isEntity(candidateClass) && !this.m_project.hasEntity(candidateClass)) {
                this.m_project.addEntityAccessor(new EntityAccessor(PersistenceUnitProcessor.getEntityAnnotation(candidateClass), candidateClass, this.m_project));
                continue;
            }
            if (PersistenceUnitProcessor.isEmbeddable(candidateClass) && !this.m_project.hasEmbeddable(candidateClass)) {
                this.m_project.addEmbeddableAccessor(new EmbeddableAccessor(PersistenceUnitProcessor.getEmbeddableAnnotation(candidateClass), candidateClass, this.m_project));
                continue;
            }
            if (!PersistenceUnitProcessor.isStaticMetamodelClass(candidateClass)) continue;
            this.m_project.addStaticMetamodelClass(PersistenceUnitProcessor.getStaticMetamodelAnnotation(candidateClass), candidateClass);
        }
    }

    public void loadMappingFiles(boolean throwExceptionOnFail) {
        this.loadStandardMappingFiles("META-INF/orm.xml");
        this.loadSpecifiedMappingFiles(throwExceptionOnFail);
        Boolean excludeEclipseLinkORM = Boolean.valueOf((String)this.m_project.getPersistenceUnitInfo().getProperties().get("eclipselink.exclude-eclipselink-orm"));
        if (!excludeEclipseLinkORM.booleanValue()) {
            this.loadStandardMappingFiles("META-INF/eclipselink-orm.xml");
        }
    }

    protected void loadSpecifiedMappingFiles(boolean throwExceptionOnFail) {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        for (String mappingFileName : puInfo.getMappingFileNames()) {
            try {
                Enumeration<URL> mappingFileURLs = this.m_loader.getResources(mappingFileName);
                if (mappingFileURLs.hasMoreElements()) {
                    URL nextURL = mappingFileURLs.nextElement();
                    if (mappingFileURLs.hasMoreElements()) {
                        this.logThrowable((Throwable)ValidationException.nonUniqueMappingFileName((String)puInfo.getPersistenceUnitName(), (String)mappingFileName));
                    }
                    this.m_project.addEntityMappings(XMLEntityMappingsReader.read(nextURL, this.m_loader, this.m_project.getPersistenceUnitInfo().getProperties()));
                    continue;
                }
                this.handleORMException((RuntimeException)ValidationException.mappingFileNotFound((String)puInfo.getPersistenceUnitName(), (String)mappingFileName), mappingFileName, throwExceptionOnFail);
            }
            catch (IOException e) {
                this.handleORMException((RuntimeException)PersistenceUnitLoadingException.exceptionLoadingORMXML((String)mappingFileName, (Exception)e), mappingFileName, throwExceptionOnFail);
            }
        }
    }

    protected void loadStandardMappingFiles(String ormXMLFile) {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        HashSet<URL> rootUrls = new HashSet<URL>(puInfo.getJarFileUrls());
        rootUrls.add(puInfo.getPersistenceUnitRootUrl());
        for (URL rootURL : rootUrls) {
            this.logMessage("Searching for default mapping file in " + rootURL);
            URL ormURL = null;
            Archive par = null;
            try {
                par = PersistenceUnitProcessor.getArchiveFactory(this.m_loader).createArchive(rootURL);
                ormURL = par.getEntryAsURL(ormXMLFile);
                if (ormURL == null) continue;
                this.logMessage("Found a default mapping file at " + ormURL + " for root URL " + rootURL);
                XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(ormURL, this.m_loader, this.m_project.getPersistenceUnitInfo().getProperties());
                entityMappings.setIsEclipseLinkORMFile(ormXMLFile.equals("META-INF/eclipselink-orm.xml"));
                this.m_project.addEntityMappings(entityMappings);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (par == null) continue;
                par.close();
            }
        }
    }

    protected void logMessage(String message) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(2, message);
        } else {
            this.m_session.logMessage(message);
        }
    }

    protected void logThrowable(Throwable exception) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().logThrowable(2, exception);
        } else {
            this.m_session.getSessionLog().logThrowable(2, exception);
        }
    }

    public void processCustomizers() {
        for (ClassAccessor classAccessor : this.m_project.getAccessorsWithCustomizer()) {
            DescriptorCustomizer customizer = (DescriptorCustomizer)MetadataHelper.getClassInstance(classAccessor.getCustomizerClass().getName(), this.m_loader);
            try {
                customizer.customize(classAccessor.getDescriptor().getClassDescriptor());
            }
            catch (Exception e) {
                this.logThrowable(e);
            }
        }
    }

    public void processEntityMappings() {
        this.m_factory = new MetadataAsmFactory(this.m_project.getLogger(), this.m_loader);
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.setLoader(this.m_loader);
            entityMappings.setProject(this.m_project);
            entityMappings.setMetadataFactory(this.m_factory);
            entityMappings.processPersistenceUnitMetadata();
        }
        this.initPersistenceUnitClasses();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.process();
        }
    }

    public void processORMMetadata() {
        this.m_project.processStage1();
        this.m_project.processStage2();
        this.m_project.processStage3();
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
        this.m_factory.setLoader(loader);
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.setLoader(this.m_loader);
        }
    }
}

