/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.cache.TimeOfDayMetadata;

public class CacheMetadata
extends ORMetadata {
    protected Boolean m_alwaysRefresh;
    protected Boolean m_disableHits;
    protected Boolean m_shared;
    protected Boolean m_refreshOnlyIfNewer;
    protected String m_coordinationType;
    protected String m_type;
    protected Integer m_expiry;
    protected Integer m_size;
    protected TimeOfDayMetadata m_expiryTimeOfDay;

    public CacheMetadata() {
        super("<cache>");
    }

    public CacheMetadata(MetadataAnnotation cache, MetadataAccessibleObject accessibleObject) {
        super(cache, accessibleObject);
        this.m_alwaysRefresh = (Boolean)cache.getAttribute("alwaysRefresh");
        this.m_disableHits = (Boolean)cache.getAttribute("disableHits");
        this.m_coordinationType = (String)cache.getAttribute("coordinationType");
        this.m_expiry = (Integer)cache.getAttribute("expiry");
        MetadataAnnotation expiryTimeOfDay = (MetadataAnnotation)cache.getAttribute("expiryTimeOfDay");
        if (expiryTimeOfDay != null) {
            this.m_expiryTimeOfDay = new TimeOfDayMetadata(expiryTimeOfDay, accessibleObject);
        }
        this.m_shared = (Boolean)cache.getAttribute("shared");
        this.m_size = (Integer)cache.getAttribute("size");
        this.m_type = (String)cache.getAttribute("type");
        this.m_refreshOnlyIfNewer = (Boolean)cache.getAttribute("refreshOnlyIfNewer");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheMetadata) {
            CacheMetadata cache = (CacheMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_alwaysRefresh, cache.getAlwaysRefresh())) {
                return false;
            }
            if (!this.valuesMatch(this.m_disableHits, cache.getDisableHits())) {
                return false;
            }
            if (!this.valuesMatch(this.m_shared, cache.getShared())) {
                return false;
            }
            if (!this.valuesMatch(this.m_refreshOnlyIfNewer, cache.getRefreshOnlyIfNewer())) {
                return false;
            }
            if (!this.valuesMatch(this.m_coordinationType, cache.getCoordinationType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_type, cache.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_expiry, cache.getExpiry())) {
                return false;
            }
            if (!this.valuesMatch(this.m_size, cache.getSize())) {
                return false;
            }
            return this.valuesMatch(this.m_expiryTimeOfDay, cache.getExpiryTimeOfDay());
        }
        return false;
    }

    public Boolean getAlwaysRefresh() {
        return this.m_alwaysRefresh;
    }

    public String getCoordinationType() {
        return this.m_coordinationType;
    }

    public Boolean getDisableHits() {
        return this.m_disableHits;
    }

    public Integer getExpiry() {
        return this.m_expiry;
    }

    public TimeOfDayMetadata getExpiryTimeOfDay() {
        return this.m_expiryTimeOfDay;
    }

    public Boolean getRefreshOnlyIfNewer() {
        return this.m_refreshOnlyIfNewer;
    }

    public Boolean getShared() {
        return this.m_shared;
    }

    public Integer getSize() {
        return this.m_size;
    }

    public String getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor, MetadataClass javaClass) {
        descriptor.setHasCache();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_type != null) {
            if (this.m_type.equals(CacheType.SOFT_WEAK.name())) {
                classDescriptor.useSoftCacheWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.FULL.name())) {
                classDescriptor.useFullIdentityMap();
            } else if (this.m_type.equals(CacheType.WEAK.name())) {
                classDescriptor.useWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.SOFT.name())) {
                classDescriptor.useSoftIdentityMap();
            } else if (this.m_type.equals(CacheType.HARD_WEAK.name())) {
                classDescriptor.useHardCacheWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.CACHE.name())) {
                classDescriptor.useCacheIdentityMap();
            } else if (this.m_type.equals(CacheType.NONE.name())) {
                classDescriptor.useNoIdentityMap();
            }
        }
        if (this.m_size != null) {
            classDescriptor.setIdentityMapSize(this.m_size.intValue());
        }
        if (this.m_shared != null) {
            classDescriptor.setIsIsolated(this.m_shared == false);
        }
        if (this.m_expiryTimeOfDay == null) {
            if (this.m_expiry != null && this.m_expiry != -1) {
                classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy((long)this.m_expiry.intValue()));
            }
        } else if (this.m_expiry == null || this.m_expiry == -1) {
            classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(this.m_expiryTimeOfDay.processHour().intValue(), this.m_expiryTimeOfDay.processMinute().intValue(), this.m_expiryTimeOfDay.processSecond().intValue(), this.m_expiryTimeOfDay.processMillisecond().intValue()));
        } else {
            throw ValidationException.cacheExpiryAndExpiryTimeOfDayBothSpecified((Object)javaClass);
        }
        if (this.m_alwaysRefresh != null) {
            classDescriptor.setShouldAlwaysRefreshCache(this.m_alwaysRefresh.booleanValue());
        }
        if (this.m_refreshOnlyIfNewer != null) {
            classDescriptor.setShouldOnlyRefreshCacheIfNewerVersion(this.m_refreshOnlyIfNewer.booleanValue());
        }
        if (this.m_disableHits != null) {
            classDescriptor.setShouldDisableCacheHits(this.m_disableHits.booleanValue());
        }
        if (this.m_coordinationType != null) {
            if (this.m_coordinationType.equals(CacheCoordinationType.SEND_OBJECT_CHANGES.name())) {
                classDescriptor.setCacheSynchronizationType(1);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS.name())) {
                classDescriptor.setCacheSynchronizationType(2);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES.name())) {
                classDescriptor.setCacheSynchronizationType(3);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.NONE.name())) {
                classDescriptor.setCacheSynchronizationType(4);
            }
        }
    }

    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.m_alwaysRefresh = alwaysRefresh;
    }

    public void setCoordinationType(String coordinationType) {
        this.m_coordinationType = coordinationType;
    }

    public void setDisableHits(Boolean disableHits) {
        this.m_disableHits = disableHits;
    }

    public void setExpiry(Integer expiry) {
        this.m_expiry = expiry;
    }

    public void setExpiryTimeOfDay(TimeOfDayMetadata expiryTimeOfDay) {
        this.m_expiryTimeOfDay = expiryTimeOfDay;
    }

    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.m_refreshOnlyIfNewer = refreshOnlyIfNewer;
    }

    public void setShared(Boolean shared) {
        this.m_shared = shared;
    }

    public void setSize(Integer size) {
        this.m_size = size;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

