/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCJavaMethodImpl
implements JavaMethod {
    private JMethod xjcMethod;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private static Field JMETHOD_ANNOTATIONS = null;
    private static Field JMETHOD_OUTER = null;

    public XJCJavaMethodImpl(JMethod javaMethod, JCodeModel codeModel, DynamicClassLoader loader) {
        this.xjcMethod = javaMethod;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
    }

    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = null;
            try {
                annotations = (Collection)PrivilegedAccessHelper.getValueFromField((Field)JMETHOD_ANNOTATIONS, (Object)this.xjcMethod);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (annotations == null) {
                return null;
            }
            for (JAnnotationUse annotationUse : annotations) {
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                if (!xjcAnnotation.getJavaAnnotationClass().getCanonicalName().equals(aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = null;
        try {
            annotations = (Collection)PrivilegedAccessHelper.getValueFromField((Field)JMETHOD_ANNOTATIONS, (Object)this.xjcMethod);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (annotations == null) {
            return annotationsList;
        }
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    public String getName() {
        return this.xjcMethod.name();
    }

    public JavaClass[] getParameterTypes() {
        JType[] params = this.xjcMethod.listParamTypes();
        JavaClass[] paramArray = new JavaClass[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramArray[i] = new XJCJavaClassImpl((JDefinedClass)params[i], this.jCodeModel, this.dynamicClassLoader);
        }
        return paramArray;
    }

    public JavaClass getResolvedType() {
        try {
            return new XJCJavaClassImpl(this.jCodeModel._class(this.xjcMethod.type().fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
        catch (JClassAlreadyExistsException ex) {
            return new XJCJavaClassImpl(this.jCodeModel._getClass(this.xjcMethod.type().fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
    }

    public JavaClass getReturnType() {
        JType type = this.xjcMethod.type();
        try {
            Field argsField = PrivilegedAccessHelper.getDeclaredField(type.getClass(), (String)"args", (boolean)true);
            List args = (List)PrivilegedAccessHelper.getValueFromField((Field)argsField, (Object)type);
            type = (JType)args.get(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return new XJCJavaClassImpl(this.jCodeModel._class(type.fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
        catch (JClassAlreadyExistsException ex) {
            return new XJCJavaClassImpl(this.jCodeModel._getClass(type.fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
    }

    public boolean hasActualTypeArguments() {
        try {
            JavaClass[] allParams;
            for (JavaClass type : allParams = this.getParameterTypes()) {
                Class<?> paramClass = Class.forName(type.getPackageName() + "." + type.getName());
                if (!(paramClass.newInstance() instanceof ParameterizedType)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<Object> getActualTypeArguments() {
        throw new UnsupportedOperationException("getActualTypeArguments");
    }

    public int getModifiers() {
        return this.xjcMethod.mods().getValue();
    }

    public JavaClass getOwningClass() {
        JDefinedClass ownerXJCClass = null;
        try {
            ownerXJCClass = (JDefinedClass)PrivilegedAccessHelper.getValueFromField((Field)JMETHOD_OUTER, (Object)this.xjcMethod);
        }
        catch (Exception e) {
            return null;
        }
        return new XJCJavaClassImpl(ownerXJCClass, this.jCodeModel, this.dynamicClassLoader);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        throw new UnsupportedOperationException("getDeclaredAnnotation");
    }

    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        throw new UnsupportedOperationException("getDeclaredAnnotations");
    }

    static {
        try {
            JMETHOD_ANNOTATIONS = PrivilegedAccessHelper.getDeclaredField(JMethod.class, (String)"annotations", (boolean)true);
            JMETHOD_OUTER = PrivilegedAccessHelper.getDeclaredField(JMethod.class, (String)"outer", (boolean)true);
        }
        catch (Exception e) {
            throw JAXBException.errorCreatingDynamicJAXBContext((Exception)e);
        }
    }
}

