/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDODataFactoryDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOHelperContext
implements HelperContext {
    protected CopyHelper copyHelper;
    protected DataFactory dataFactory;
    protected DataHelper dataHelper;
    protected EqualityHelper equalityHelper;
    protected XMLHelper xmlHelper;
    protected TypeHelper typeHelper;
    protected XSDHelper xsdHelper;
    private String identifier;
    private static ConcurrentHashMap<Object, ConcurrentHashMap<String, HelperContext>> helperContexts = new ConcurrentHashMap();
    private static WeakHashMap<ClassLoader, WeakReference<HelperContext>> userSetHelperContexts = new WeakHashMap();
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private static String WAS_CLASSLOADER_NAME = "com.ibm.ws";
    private static String JBOSS_CLASSLOADER_NAME = "jboss";
    private static String GLOBAL_HELPER_IDENTIFIER = "";
    private static final int COUNTER_LIMIT = 20;
    private static MBeanServer wlsMBeanServer = null;
    private static ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_RUNTIME_SERVICE = "RuntimeService";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_APP_RUNTIMES = "ApplicationRuntimes";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD = "ExecuteThread";
    private static final String WLS_MBEAN_SERVER = "MBeanServer";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME = "ApplicationName";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_ACTIVE_VERSION_STATE = "ActiveVersionState";
    private static final Class[] WLS_PARAMETER_TYPES = new Class[0];
    private static final String WAS_NEWLINE = "\n";
    private static final String WAS_APP_COLON = "[app:";
    private static final String WAS_CLOSE_BRACKET = "]";
    private static final String JBOSS_VFSZIP = "vfszip:";
    private static final String JBOSS_VFSFILE = "vfsfile:";
    private static final String JBOSS_EAR = ".ear";
    private static final String JBOSS_WAR = ".war";
    private static final int JBOSS_VFSZIP_OFFSET = "vfszip:".length();
    private static final int JBOSS_VFSFILE_OFFSET = "vfsfile:".length();
    private static final int JBOSS_EAR_OFFSET = ".ear".length();
    private static final int JBOSS_TRIM_COUNT = 2;

    public SDOHelperContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(String identifier) {
        this(identifier, Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(ClassLoader aClassLoader) {
        this.identifier = GLOBAL_HELPER_IDENTIFIER;
        this.initialize(aClassLoader);
    }

    public SDOHelperContext(String identifier, ClassLoader aClassLoader) {
        this.identifier = identifier;
        this.initialize(aClassLoader);
    }

    protected void initialize(ClassLoader aClassLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new SDODataFactoryDelegate(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new SDOXMLHelperDelegate(this, aClassLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public void reset() {
        ((SDOTypeHelper)this.getTypeHelper()).reset();
        ((SDOXMLHelper)this.getXMLHelper()).reset();
        ((SDOXSDHelper)this.getXSDHelper()).reset();
    }

    public CopyHelper getCopyHelper() {
        return this.copyHelper;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataHelper getDataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public XMLHelper getXMLHelper() {
        return this.xmlHelper;
    }

    public XSDHelper getXSDHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable createResolvable() {
        return new SDOResolvable(this);
    }

    public ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return new SDOResolvable(target, this);
    }

    public static void putHelperContext(ClassLoader key, HelperContext value) {
        if (key == null || value == null) {
            return;
        }
        userSetHelperContexts.put(key, new WeakReference<HelperContext>(value));
    }

    private static HelperContext getHelperContext(ClassLoader key) {
        if (key == null) {
            return null;
        }
        WeakReference<HelperContext> wRef = userSetHelperContexts.get(key);
        if (wRef == null) {
            return null;
        }
        return (HelperContext)wRef.get();
    }

    public static void removeHelperContext(ClassLoader key) {
        if (key == null) {
            return;
        }
        userSetHelperContexts.remove(key);
    }

    public static HelperContext getHelperContext() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        HelperContext hCtx = SDOHelperContext.getHelperContext(contextClassLoader);
        if (hCtx != null) {
            return hCtx;
        }
        return SDOHelperContext.getHelperContext(GLOBAL_HELPER_IDENTIFIER);
    }

    public static HelperContext getHelperContext(String identifier) {
        HelperContext existingContext;
        ConcurrentMap<String, HelperContext> contextMap = SDOHelperContext.getContextMap();
        HelperContext helperContext = (HelperContext)contextMap.get(identifier);
        if (null == helperContext && (existingContext = contextMap.putIfAbsent(identifier, helperContext = new SDOHelperContext(identifier))) != null) {
            helperContext = existingContext;
        }
        return helperContext;
    }

    public static HelperContext getHelperContext(String identifier, ClassLoader classLoader) {
        HelperContext existingContext;
        ConcurrentMap<String, HelperContext> contextMap = SDOHelperContext.getContextMap();
        HelperContext helperContext = (HelperContext)contextMap.get(identifier);
        if (null == helperContext && (existingContext = contextMap.putIfAbsent(identifier, helperContext = new SDOHelperContext(identifier, classLoader))) != null) {
            helperContext = existingContext;
        }
        return helperContext;
    }

    static ConcurrentMap<String, HelperContext> getContextMap() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Object key = SDOHelperContext.getDelegateMapKey(contextClassLoader);
        ConcurrentHashMap<String, Object> contextMap = helperContexts.get(key);
        if (null == contextMap) {
            contextMap = new ConcurrentHashMap();
            ConcurrentHashMap<String, HelperContext> existingMap = helperContexts.putIfAbsent(key, contextMap);
            if (existingMap != null) {
                contextMap = existingMap;
            }
            if (key.getClass() == ClassConstants.STRING) {
                helperContexts.put(contextClassLoader, contextMap);
            }
        }
        SDOHelperContext.addNotificationListener(key);
        return contextMap;
    }

    public static void putHelperContext(HelperContext ctx) {
        String identifier = ((SDOHelperContext)ctx).getIdentifier();
        if (GLOBAL_HELPER_IDENTIFIER.equals(identifier)) {
            return;
        }
        SDOHelperContext.getContextMap().put(identifier, ctx);
    }

    private static void resetHelperContext(Object key) {
        HelperContext hCtx = helperContexts.get(key).get(GLOBAL_HELPER_IDENTIFIER);
        if (hCtx != null) {
            helperContexts.remove(key);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getDelegateMapKey(ClassLoader classLoader) {
        String classLoaderName = classLoader.getClass().getName();
        Object delegateKey = classLoader;
        if (classLoaderName.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() == null) return classLoader;
            if (classLoader.toString().indexOf(".web.") == -1) {
                if (classLoader.toString().indexOf(".wrappers") == -1) return classLoader;
            }
            classLoader = classLoader.getParent();
            return classLoader;
        }
        if (classLoaderName.contains(WLS_CLASSLOADER_NAME)) {
            Object executeThread = SDOHelperContext.getExecuteThread();
            if (executeThread == null) return delegateKey;
            try {
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), (String)WLS_APPLICATION_NAME_GET_METHOD_NAME, (Class[])WLS_PARAMETER_TYPES, (boolean)false);
                delegateKey = PrivilegedAccessHelper.invokeMethod((Method)getMethod, (Object)executeThread);
                if (delegateKey != null) return delegateKey;
                return classLoader;
            }
            catch (Exception e) {
                throw SDOException.errorInvokingWLSMethodReflectively((String)WLS_APPLICATION_NAME_GET_METHOD_NAME, (String)WLS_EXECUTE_THREAD, (Exception)e);
            }
        }
        if (classLoaderName.contains(WAS_CLASSLOADER_NAME)) {
            delegateKey = SDOHelperContext.getApplicationNameForWAS(classLoader);
            if (delegateKey != null) return delegateKey;
            return classLoader;
        }
        if (!classLoaderName.contains(JBOSS_CLASSLOADER_NAME)) return delegateKey;
        delegateKey = SDOHelperContext.getApplicationNameForJBoss(classLoader);
        if (delegateKey != null) return delegateKey;
        return classLoader;
    }

    private static MBeanServer getWLSMBeanServer() {
        if (wlsMBeanServer == null) {
            InitialContext weblogicContext = null;
            try {
                weblogicContext = new InitialContext();
                try {
                    wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException e) {
                    try {
                        wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException ne) {
                        throw SDOException.errorPerformingWLSLookup((String)WLS_MBEAN_SERVER, (Exception)ne);
                    }
                }
            }
            catch (NamingException nex) {
                throw SDOException.errorCreatingWLSInitialContext((Exception)nex);
            }
        }
        return wlsMBeanServer;
    }

    private static Object getExecuteThread() {
        if (SDOHelperContext.getWLSMBeanServer() != null) {
            if (wlsThreadPoolRuntime == null) {
                ObjectName service = null;
                ObjectName serverRuntime = null;
                try {
                    service = new ObjectName(WLS_SERVICE_KEY);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName((String)"RuntimeService [com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean]", (Exception)x);
                }
                try {
                    serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName((String)WLS_SERVER_RUNTIME, (Exception)x);
                }
                try {
                    wlsThreadPoolRuntime = (ObjectName)wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName((String)WLS_THREADPOOL_RUNTIME, (Exception)x);
                }
            }
            try {
                return wlsMBeanServer.invoke(wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
            }
            catch (Exception x) {
                throw SDOException.errorInvokingWLSMethodReflectively((String)WLS_EXECUTE_THREAD_GET_METHOD_NAME, (String)WLS_THREADPOOL_RUNTIME, (Exception)x);
            }
        }
        return null;
    }

    private static void addNotificationListener(Object mapKey) {
        if (Thread.currentThread().getContextClassLoader().getClass().getName().contains(WLS_CLASSLOADER_NAME) && SDOHelperContext.getWLSMBeanServer() != null) {
            try {
                ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                ObjectName serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                ObjectName[] appRuntimes = (ObjectName[])wlsMBeanServer.getAttribute(serverRuntime, WLS_APP_RUNTIMES);
                for (int i = 0; i < appRuntimes.length; ++i) {
                    try {
                        ObjectName appRuntime = appRuntimes[i];
                        Object appName = wlsMBeanServer.getAttribute(appRuntime, WLS_APPLICATION_NAME);
                        if (appName == null || !appName.toString().equals(mapKey)) continue;
                        wlsMBeanServer.addNotificationListener(appRuntime, new MyNotificationListener(appName.toString()), null, null);
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void makeDefaultContext() {
        ConcurrentHashMap<String, Object> existingContexts;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Object key = SDOHelperContext.getDelegateMapKey(contextClassLoader);
        ConcurrentHashMap<String, Object> contexts = helperContexts.get(key);
        if (contexts == null && (existingContexts = helperContexts.putIfAbsent(key, contexts = new ConcurrentHashMap())) != null) {
            contexts = existingContexts;
        }
        this.identifier = GLOBAL_HELPER_IDENTIFIER;
        contexts.put(GLOBAL_HELPER_IDENTIFIER, this);
    }

    private static String getApplicationNameForWAS(ClassLoader loader) {
        String applicationName = null;
        for (int i = 0; applicationName == null && i < 20; ++i) {
            applicationName = SDOHelperContext.getApplicationNameFromWASClassLoader(loader);
            ClassLoader parent = loader.getParent();
            if (parent == null || parent == loader) break;
            loader = parent;
        }
        return applicationName;
    }

    private static String getApplicationNameFromWASClassLoader(ClassLoader loader) {
        String firstLine;
        int appPos;
        String applicationName = null;
        String loaderString = loader.toString().trim();
        while (loaderString.startsWith(WAS_NEWLINE) && loaderString.length() > 0) {
            loaderString = loaderString.substring(1).trim();
        }
        String[] loaderStringLines = loaderString.split(WAS_NEWLINE, 2);
        if (loaderStringLines.length > 0 && (appPos = (firstLine = loaderStringLines[0].trim()).indexOf(WAS_APP_COLON)) >= 0 && appPos + WAS_APP_COLON.length() < firstLine.length()) {
            String appNameSegment = firstLine.substring(appPos + WAS_APP_COLON.length());
            int closingBracketPosition = appNameSegment.indexOf(WAS_CLOSE_BRACKET);
            applicationName = closingBracketPosition > 0 ? appNameSegment.substring(0, closingBracketPosition) : appNameSegment;
        }
        return applicationName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private static String getApplicationNameForJBoss(ClassLoader loader) {
        ClassLoader parent;
        String applicationName = null;
        for (int i = 0; i < 20 && (applicationName = SDOHelperContext.getApplicationNameFromJBossClassLoader(loader)) == null && (parent = loader.getParent()) != null && parent != loader; ++i) {
            loader = parent;
        }
        return applicationName;
    }

    private static String getApplicationNameFromJBossClassLoader(ClassLoader loader) {
        String clStr = loader.toString();
        String appNameSegment = null;
        if (clStr.indexOf(JBOSS_VFSZIP) != -1) {
            appNameSegment = clStr.substring(clStr.indexOf(JBOSS_VFSZIP) + JBOSS_VFSZIP_OFFSET, clStr.length() - 2);
            if (appNameSegment.indexOf(JBOSS_WAR) != -1 && appNameSegment.indexOf(JBOSS_EAR) != -1) {
                appNameSegment = appNameSegment.substring(0, appNameSegment.indexOf(JBOSS_EAR) + JBOSS_EAR_OFFSET);
            }
        } else if (clStr.indexOf(JBOSS_VFSFILE) != -1) {
            appNameSegment = clStr.substring(clStr.indexOf(JBOSS_VFSFILE) + JBOSS_VFSFILE_OFFSET, clStr.length() - 2);
        }
        if (appNameSegment != null) {
            return new File(appNameSegment).getName();
        }
        return null;
    }

    private static class MyNotificationListener
    implements NotificationListener {
        Object mapKey;

        public MyNotificationListener(Object mapKey) {
            this.mapKey = mapKey;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AttributeChangeNotification) {
                try {
                    AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                    if (acn.getAttributeName().equals(SDOHelperContext.WLS_ACTIVE_VERSION_STATE) && acn.getNewValue().equals(0)) {
                        SDOHelperContext.resetHelperContext(this.mapKey);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

