/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.xml.sax.InputSource;

public class SchemaResolverWrapper {
    private SchemaResolver schemaResolver;
    private List<String> systemIdList;

    public SchemaResolverWrapper(SchemaResolver resolver) {
        this.schemaResolver = resolver;
        this.systemIdList = new ArrayList<String>();
    }

    public Source resolveSchema(Source sourceXSD, String namespace, String schemaLocation) {
        String sysId;
        this.addSchemaToList(sourceXSD.getSystemId());
        Source schemaSource = this.schemaResolver.resolveSchema(sourceXSD, namespace, schemaLocation);
        if (schemaSource != null && this.shouldProcessSchema(sysId = schemaSource.getSystemId())) {
            return schemaSource;
        }
        return null;
    }

    public Source resolveSchema(String systemId) {
        if (!this.addSchemaToList(systemId)) {
            return null;
        }
        try {
            InputSource source = this.schemaResolver.resolveEntity(null, systemId);
            if (source != null) {
                return new StreamSource(source.getCharacterStream());
            }
        }
        catch (Exception ex) {
            throw SDOException.errorResolvingSchema((Exception)ex);
        }
        return null;
    }

    private boolean shouldProcessSchema(String systemId) {
        if (systemId == null) {
            return true;
        }
        return this.addSchemaToList(systemId);
    }

    private boolean addSchemaToList(String systemId) {
        if (systemId == null || this.systemIdList.contains(systemId)) {
            return false;
        }
        this.systemIdList.add(systemId);
        return true;
    }

    public SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }
}

