/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class DynamicSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected ArrayList sqlStrings;
    protected long batchSize;
    protected boolean usesOptimisticLocking;

    public DynamicSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.sqlStrings = new ArrayList(10);
        this.batchSize = 0L;
    }

    public void appendCall(AbstractSession session, DatabaseCall dbCall) {
        if (dbCall != null) {
            this.cacheQueryTimeout(session, dbCall);
        }
        if (!dbCall.hasParameters()) {
            if (this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE) {
                this.databaseAccessor.getLogin().getPlatform().setMaxBatchWritingSize(DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE);
            }
            if (this.batchSize + (long)dbCall.getSQLString().length() > (long)this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize()) {
                this.executeBatchedStatements(session);
            }
            if (this.usesOptimisticLocking != dbCall.hasOptimisticLock) {
                this.executeBatchedStatements(session);
            }
            this.sqlStrings.add(dbCall.getSQLString());
            this.batchSize += (long)dbCall.getSQLString().length();
            this.usesOptimisticLocking = dbCall.hasOptimisticLock;
            ++this.statementCount;
            if (((ModifyQuery)dbCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(session);
            }
        } else {
            this.executeBatchedStatements(session);
            this.switchMechanisms(session, dbCall);
        }
    }

    public void clear() {
        this.sqlStrings.clear();
        this.executionCount = 0;
        this.statementCount = 0;
        this.usesOptimisticLocking = false;
        this.batchSize = 0L;
        this.clearCacheQueryTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchedStatements(AbstractSession session) {
        if (this.sqlStrings.isEmpty()) {
            return;
        }
        session.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
        if (session.shouldLog(3, "sql")) {
            Iterator sqlStringsIterator = this.sqlStrings.iterator();
            while (sqlStringsIterator.hasNext()) {
                session.log(3, "sql", (String)sqlStringsIterator.next(), null, this.databaseAccessor, false);
            }
        }
        session.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
        try {
            Statement statement;
            ++this.databaseAccessor.writeStatementsCount;
            this.databaseAccessor.incrementCallCount(session);
            if (!session.getPlatform().usesJDBCBatchWriting()) {
                statement = this.prepareBatchStatement(session);
                this.databaseAccessor.executeBatchedStatement((PreparedStatement)statement, session);
            } else {
                statement = this.prepareJDK12BatchStatement(session);
                this.executionCount += this.databaseAccessor.executeJDK12BatchStatement(statement, null, session, false);
                if (this.usesOptimisticLocking && this.executionCount != this.statementCount) {
                    throw OptimisticLockException.batchStatementExecutionFailure();
                }
            }
            Object var4_3 = null;
            this.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clear();
            throw throwable;
        }
    }

    protected void switchMechanisms(AbstractSession session, DatabaseCall dbCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToParameterizedSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism().appendCall(session, dbCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement prepareBatchStatement(AbstractSession session) throws DatabaseException {
        PreparedStatement statement = null;
        boolean isDelimiterStringNeeded = false;
        StringWriter writer = new StringWriter();
        org.eclipse.persistence.platform.database.DatabasePlatform platform = session.getPlatform();
        writer.write(platform.getBatchBeginString());
        Iterator sqlStringsIteration = this.sqlStrings.iterator();
        while (sqlStringsIteration.hasNext()) {
            if (isDelimiterStringNeeded) {
                writer.write(platform.getBatchDelimiterString());
            }
            writer.write((String)sqlStringsIteration.next());
            isDelimiterStringNeeded = true;
        }
        writer.write(platform.getBatchDelimiterString());
        writer.write(platform.getBatchEndString());
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                statement = this.databaseAccessor.getConnection().prepareStatement(writer.toString());
                Object var8_9 = null;
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
                throw throwable;
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, null);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement prepareJDK12BatchStatement(AbstractSession session) throws DatabaseException {
        Statement statement = null;
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                statement = this.databaseAccessor.getConnection().createStatement();
                Iterator sqlStringsIterator = this.sqlStrings.iterator();
                while (sqlStringsIterator.hasNext()) {
                    statement.addBatch((String)sqlStringsIterator.next());
                }
                if (this.queryTimeoutCache > 0) {
                    statement.setQueryTimeout(this.queryTimeoutCache);
                }
                Object var5_6 = null;
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
                throw throwable;
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, null);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        return statement;
    }
}

