/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTableDescriptorLockingPolicy
extends MWDescriptorLockingPolicy {
    private MWColumnHandle versionLockingColumnHandle;
    public static final String VERSION_LOCKING_COLUMN_PROPERTY = "versionLockingColumn";
    private volatile String optimisticLockingType;
    public static final String OPTIMISTIC_LOCKING_TYPE_PROPERTY = "optimisticLockingType";
    public static final String OPTIMISTIC_COLUMNS_LOCKING_TYPE = "Columns Locking";
    public static final String OPTIMISTIC_VERSION_LOCKING_TYPE = "Version Locking";
    public static final String DEFAULT_OPTIMISTIC_LOCKING_TYPE = "Version Locking";
    private volatile String optimisticColumnsLockingType;
    public static final String OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY = "optimisticColumnsLockingType";
    public static final String OPTIMISTIC_COLUMNS_ALL_COLUMNS = "All Columns";
    public static final String OPTIMISTIC_COLUMNS_CHANGED_COLUMNS = "Changed Columns";
    public static final String OPTIMISTIC_COLUMNS_SELECTED_COLUMNS = "Selected Columns";
    public static final String DEFAULT_OPTIMISTIC_COLUMNS_LOCKING_TYPE = "All Columns";
    private Collection columnLockColumnHandles;
    public static final String COLUMN_LOCK_COLUMNS_COLLECTION = "columnLockColumns";
    private MWHandle.NodeReferenceScrubber columnLockColumnScrubber;

    protected MWTableDescriptorLockingPolicy() {
    }

    public MWTableDescriptorLockingPolicy(MWRelationalTransactionalPolicy descriptor) {
        super(descriptor);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.versionLockingColumnHandle = new MWColumnHandle(this, this.buildVersionLockingColumnScrubber());
        this.columnLockColumnHandles = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.versionLockingColumnHandle);
        Collection collection = this.columnLockColumnHandles;
        synchronized (collection) {
            children.addAll(this.columnLockColumnHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber buildVersionLockingColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTableDescriptorLockingPolicy.this.setVersionLockingColumn(null);
            }

            public String toString() {
                return "MWTableDescriptorLockingPolicy.buildVersionLockingColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber columnLockColumnScrubber() {
        if (this.columnLockColumnScrubber == null) {
            this.columnLockColumnScrubber = this.buildColumnLockColumnScrubber();
        }
        return this.columnLockColumnScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildColumnLockColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTableDescriptorLockingPolicy.this.removeColumnLockColumnHandle((MWColumnHandle)handle);
            }

            public String toString() {
                return "MWTableDescriptorLockingPolicy.buildColumnLockColumnScrubber()";
            }
        };
    }

    public MWTableDescriptor getOwningTableDescriptor() {
        return (MWTableDescriptor)this.getOwningDescriptor();
    }

    public MWColumn getVersionLockingColumn() {
        return this.versionLockingColumnHandle.getColumn();
    }

    public void setVersionLockingColumn(MWColumn column) {
        if (column != null && this.getLockingType() != "Optimistic Locking") {
            throw new IllegalStateException("LockingType must be Optimistic Locking");
        }
        MWColumn old = this.versionLockingColumnHandle.getColumn();
        this.versionLockingColumnHandle.setColumn(column);
        this.firePropertyChanged(VERSION_LOCKING_COLUMN_PROPERTY, old, column);
    }

    public MWDataField getVersionLockField() {
        return this.getVersionLockingColumn();
    }

    public void setVersionLockField(MWDataField lockField) {
        this.setVersionLockingColumn((MWColumn)lockField);
    }

    private Iterator columnLockColumnHandles() {
        return new CloneIterator(this.columnLockColumnHandles){

            protected void remove(Object current) {
                MWTableDescriptorLockingPolicy.this.removeColumnLockColumnHandle((MWColumnHandle)current);
            }
        };
    }

    void removeColumnLockColumnHandle(MWColumnHandle handle) {
        this.columnLockColumnHandles.remove(handle);
        this.fireItemRemoved(COLUMN_LOCK_COLUMNS_COLLECTION, handle.getColumn());
    }

    public Iterator columnLockColumns() {
        return new TransformationIterator(this.columnLockColumnHandles()){

            protected Object transform(Object next) {
                return ((MWColumnHandle)next).getColumn();
            }
        };
    }

    public int columnLockColumnsSize() {
        return this.columnLockColumnHandles.size();
    }

    public void addColumnLockColumn(MWColumn column) {
        this.columnLockColumnHandles.add(new MWColumnHandle(this, column, this.columnLockColumnScrubber()));
        this.fireItemAdded(COLUMN_LOCK_COLUMNS_COLLECTION, column);
    }

    public void removeColumnLockColumn(MWColumn column) {
        Iterator stream = this.columnLockColumns();
        while (stream.hasNext()) {
            if (stream.next() != column) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(column.toString());
    }

    private void clearColumnLockColumns() {
        Iterator stream = this.columnLockColumnHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    public Iterator columnLockColumnsNames() {
        return new TransformationIterator(this.columnLockColumns()){

            protected Object transform(Object next) {
                return ((MWColumn)next).qualifiedName();
            }
        };
    }

    public void setLockingType(String newLockingType) {
        String oldLockingType = this.getLockingType();
        super.setLockingType(newLockingType);
        if (this.attributeValueHasChanged(newLockingType, oldLockingType)) {
            if (newLockingType != "Optimistic Locking") {
                this.setOptimisticLockingType(null);
            } else {
                this.setOptimisticLockingType("Version Locking");
            }
        }
    }

    public String getOptimisticColumnsLockingType() {
        return this.optimisticColumnsLockingType;
    }

    public void setOptimisticColumnsLockingType(String fieldsType) {
        String oldValue = this.optimisticColumnsLockingType;
        this.optimisticColumnsLockingType = fieldsType;
        this.firePropertyChanged(OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY, oldValue, this.optimisticColumnsLockingType);
        if (this.attributeValueHasChanged(oldValue, this.optimisticColumnsLockingType) && this.optimisticColumnsLockingType != OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            this.clearColumnLockColumns();
        }
    }

    public String getOptimisticLockingType() {
        return this.optimisticLockingType;
    }

    public void setOptimisticLockingType(String optimisticLockingType) {
        String oldLockingType = this.optimisticLockingType;
        this.optimisticLockingType = optimisticLockingType;
        this.firePropertyChanged(OPTIMISTIC_LOCKING_TYPE_PROPERTY, oldLockingType, this.optimisticLockingType);
        if (this.attributeValueHasChanged(oldLockingType, this.optimisticLockingType)) {
            if (this.optimisticLockingType == "Version Locking") {
                this.setOptimisticColumnsLockingType(null);
                this.setOptimisticVersionLockingType("Version Locking");
                this.clearColumnLockColumns();
            } else if (this.optimisticLockingType == null) {
                this.setOptimisticColumnsLockingType(null);
                this.setOptimisticVersionLockingType(null);
                this.setVersionLockField(null);
                this.clearColumnLockColumns();
            } else {
                this.setOptimisticColumnsLockingType("All Columns");
                this.setVersionLockField(null);
                this.setOptimisticVersionLockingType(null);
            }
        }
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.selectedColumnsLockingNotMapped(problems);
        this.selectedColumnsLockingContainsPrimaryKey(problems);
    }

    protected void checkWriteLockFieldWritable(List newProblems) {
        if (this.getOptimisticLockingType() == "Version Locking") {
            super.checkWriteLockFieldWritable(newProblems);
        }
    }

    private void selectedColumnsLockingNotMapped(List newProblems) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE && this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            ArrayList<String> unmappedColumnNames = new ArrayList<String>();
            ArrayList<String> invalidColumnNames = new ArrayList<String>();
            Iterator stream = this.columnLockColumns();
            while (stream.hasNext()) {
                MWColumn column = (MWColumn)stream.next();
                if (!CollectionTools.contains(this.getOwningTableDescriptor().allAssociatedColumns(), (Object)column)) {
                    invalidColumnNames.add(column.getName());
                }
                if (this.getOwningTableDescriptor().allWritableMappingsForField(column).size() != 0) continue;
                unmappedColumnNames.add(column.getName());
            }
            if (unmappedColumnNames.size() > 0) {
                newProblems.add(this.buildProblem("0306", unmappedColumnNames));
            }
            if (invalidColumnNames.size() > 0) {
                newProblems.add(this.buildProblem("0310", invalidColumnNames));
            }
        }
    }

    protected void checkLockFieldSpecifiedForLockingPolicy(List newProblems) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == "Version Locking") {
            if (this.getVersionLockField() == null) {
                newProblems.add(this.buildProblem("0308"));
            } else if (!CollectionTools.contains(this.getOwningTableDescriptor().allAssociatedColumns(), (Object)this.getVersionLockField())) {
                newProblems.add(this.buildProblem("0309"));
            }
        }
    }

    private void selectedColumnsLockingContainsPrimaryKey(List newProblems) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE && this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            Collection primaryKeys = CollectionTools.collection(this.getOwningTableDescriptor().primaryKeys());
            ArrayList<String> illegalColumnNames = new ArrayList<String>();
            Iterator stream = this.columnLockColumns();
            while (stream.hasNext()) {
                MWColumn column = (MWColumn)stream.next();
                if (!primaryKeys.contains(column)) continue;
                illegalColumnNames.add(column.getName());
            }
            if (illegalColumnNames.size() > 0) {
                newProblems.add(this.buildProblem("0307", illegalColumnNames));
            }
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustRuntimeDescriptor(runtimeDescriptor);
        if (this.getLockingType() == "Optimistic Locking") {
            if (this.getOptimisticLockingType() == "Version Locking") {
                VersionLockingPolicy lockingPolicy;
                if (this.getOptimisticVersionLockingType() == "Version Locking") {
                    lockingPolicy = new VersionLockingPolicy();
                } else {
                    lockingPolicy = new TimestampLockingPolicy();
                    if (this.usesLocalTime()) {
                        ((TimestampLockingPolicy)lockingPolicy).useLocalTime();
                    } else {
                        ((TimestampLockingPolicy)lockingPolicy).useServerTime();
                    }
                }
                if (this.getVersionLockField() != null) {
                    lockingPolicy.setWriteLockFieldName(this.getVersionLockField().runtimeField().getQualifiedName());
                }
                lockingPolicy.setIsStoredInCache(this.shouldStoreVersionInCache());
                runtimeDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
            } else if (this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE) {
                AllFieldsLockingPolicy lockingPolicy;
                if (this.getOptimisticColumnsLockingType() == "All Columns") {
                    lockingPolicy = new AllFieldsLockingPolicy();
                } else if (this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_CHANGED_COLUMNS) {
                    lockingPolicy = new ChangedFieldsLockingPolicy();
                } else {
                    lockingPolicy = new SelectedFieldsLockingPolicy();
                    ((SelectedFieldsLockingPolicy)lockingPolicy).setLockFieldNames(CollectionTools.vector(this.columnLockColumnsNames()));
                }
                runtimeDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTableDescriptorLockingPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWDescriptorLockingPolicy.class);
        XMLCompositeObjectMapping versionLockingColumnHandleMapping = new XMLCompositeObjectMapping();
        versionLockingColumnHandleMapping.setAttributeName("versionLockingColumnHandle");
        versionLockingColumnHandleMapping.setGetMethodName("getVersionLockingColumnHandleForTopLink");
        versionLockingColumnHandleMapping.setSetMethodName("setVersionLockingColumnHandleForTopLink");
        versionLockingColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        versionLockingColumnHandleMapping.setXPath("version-locking-column-handle");
        descriptor.addMapping((DatabaseMapping)versionLockingColumnHandleMapping);
        ObjectTypeConverter optimisticLockingTypeConverter = new ObjectTypeConverter();
        optimisticLockingTypeConverter.addConversionValue((Object)OPTIMISTIC_COLUMNS_LOCKING_TYPE, (Object)OPTIMISTIC_COLUMNS_LOCKING_TYPE);
        optimisticLockingTypeConverter.addConversionValue((Object)"Version Locking", (Object)"Version Locking");
        XMLDirectMapping optimisticLockingTypeMapping = new XMLDirectMapping();
        optimisticLockingTypeMapping.setAttributeName(OPTIMISTIC_LOCKING_TYPE_PROPERTY);
        optimisticLockingTypeMapping.setXPath("optimistic-locking-type/text()");
        optimisticLockingTypeMapping.setConverter((Converter)optimisticLockingTypeConverter);
        descriptor.addMapping((DatabaseMapping)optimisticLockingTypeMapping);
        ObjectTypeConverter optimisticColumnsLockingTypeConverter = new ObjectTypeConverter();
        optimisticColumnsLockingTypeConverter.addConversionValue((Object)"All Columns", (Object)"All Columns");
        optimisticColumnsLockingTypeConverter.addConversionValue((Object)OPTIMISTIC_COLUMNS_CHANGED_COLUMNS, (Object)OPTIMISTIC_COLUMNS_CHANGED_COLUMNS);
        optimisticColumnsLockingTypeConverter.addConversionValue((Object)OPTIMISTIC_COLUMNS_SELECTED_COLUMNS, (Object)OPTIMISTIC_COLUMNS_SELECTED_COLUMNS);
        XMLDirectMapping optimisticColumnsLockingTypeMapping = new XMLDirectMapping();
        optimisticColumnsLockingTypeMapping.setAttributeName(OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY);
        optimisticColumnsLockingTypeMapping.setXPath("optimistic-columns-locking-type/text()");
        optimisticColumnsLockingTypeMapping.setConverter((Converter)optimisticColumnsLockingTypeConverter);
        descriptor.addMapping((DatabaseMapping)optimisticColumnsLockingTypeMapping);
        XMLCompositeCollectionMapping columnLockColumnHandlesMapping = new XMLCompositeCollectionMapping();
        columnLockColumnHandlesMapping.setAttributeName("columnLockColumnHandles");
        columnLockColumnHandlesMapping.setGetMethodName("getColumnLockColumnHandlesForTopLink");
        columnLockColumnHandlesMapping.setSetMethodName("setColumnLockColumnHandlesForTopLink");
        columnLockColumnHandlesMapping.setReferenceClass(MWColumnHandle.class);
        columnLockColumnHandlesMapping.setXPath("column-lock-column-handles/column-handle");
        descriptor.addMapping((DatabaseMapping)columnLockColumnHandlesMapping);
        return descriptor;
    }

    private MWColumnHandle getVersionLockingColumnHandleForTopLink() {
        return this.versionLockingColumnHandle.getColumn() == null ? null : this.versionLockingColumnHandle;
    }

    private void setVersionLockingColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildVersionLockingColumnScrubber();
        this.versionLockingColumnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getColumnLockColumnHandlesForTopLink() {
        Collection collection = this.columnLockColumnHandles;
        synchronized (collection) {
            return new TreeSet(this.columnLockColumnHandles);
        }
    }

    private void setColumnLockColumnHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWColumnHandle)stream.next()).setScrubber(this.columnLockColumnScrubber());
        }
        this.columnLockColumnHandles = handles;
    }
}

