/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.CollectionChangeRecord {
    protected Map addObjectList;
    protected Vector orderedAddObjects;
    protected Map orderedAddObjectIndices;
    protected Vector orderedChangeObjectList;
    protected Hashtable orderedRemoveObjects;
    protected transient Vector orderedRemoveObjectIndices;
    protected transient List addOverFlow;
    protected Map removeObjectList;
    protected boolean orderHasBeenRepaired;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        Iterator enumtr = objectChanges.values().iterator();
        while (enumtr.hasNext()) {
            Object object = cp.unwrapElement(enumtr.next());
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            if (change.hasKeys()) {
                this.getAddObjectList().put(change, change);
                continue;
            }
            if (this.getRemoveObjectList().containsKey(change)) {
                this.getRemoveObjectList().remove(change);
                continue;
            }
            this.getAddObjectList().put(change, change);
        }
    }

    public void addOrderedAdditionChange(Vector objectChanges, Map objectChangesIndices, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        Enumeration e = objectChanges.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedAddObjects().add(change);
            this.getOrderedAddObjectIndices().put(change, objectChangesIndices.get(object));
        }
    }

    public void addOrderedRemoveChange(Vector indicesToRemove, Hashtable objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        this.orderedRemoveObjectIndices = indicesToRemove;
        Enumeration e = this.orderedRemoveObjectIndices.elements();
        while (e.hasMoreElements()) {
            Integer index = (Integer)e.nextElement();
            Object object = objectChanges.get(index);
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedRemoveObjects().put(index, change);
        }
    }

    public void addRemoveChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        if (objectChanges.isEmpty()) {
            return;
        }
        ClassDescriptor descriptor = this.mapping.getReferenceDescriptor();
        boolean hasChildren = descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren();
        Iterator enumtr = cp.getChangeValuesFrom(objectChanges);
        while (enumtr.hasNext()) {
            ObjectChangeSet change;
            Object object = cp.unwrapElement(enumtr.next());
            if (hasChildren) {
                descriptor = this.getReferenceDescriptor(object, session);
            }
            if ((change = descriptor.getObjectBuilder().createObjectChangeSet(object, changeSet, session)).hasKeys()) {
                this.getRemoveObjectList().put(change, change);
                continue;
            }
            if (this.getAddObjectList().containsKey(change)) {
                this.getAddObjectList().remove(change);
                continue;
            }
            this.getRemoveObjectList().put(change, change);
        }
    }

    @Override
    public Map getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashMap(10);
        }
        return this.addObjectList;
    }

    public List getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList();
        }
        return this.addOverFlow;
    }

    ClassDescriptor getReferenceDescriptor(Object object, AbstractSession session) {
        return session.getClassDescriptor(object);
    }

    @Override
    public Map getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashMap(10);
        }
        return this.removeObjectList;
    }

    @Override
    public boolean hasChanges() {
        return this.addObjectList != null && !this.addObjectList.isEmpty() || this.removeObjectList != null && !this.removeObjectList.isEmpty() || this.orderedAddObjects != null && !this.orderedAddObjects.isEmpty() || this.orderedRemoveObjects != null && !this.orderedRemoveObjects.isEmpty() || this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty() || this.getOwner().isNew();
    }

    @Override
    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getAddObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getRemoveObjectList().containsKey(localChangeSet)) {
                this.getRemoveObjectList().remove(localChangeSet);
                continue;
            }
            this.getAddObjectList().put(localChangeSet, localChangeSet);
        }
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getRemoveObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getAddObjectList().containsKey(localChangeSet)) {
                this.getAddObjectList().remove(localChangeSet);
                continue;
            }
            this.getRemoveObjectList().put(localChangeSet, localChangeSet);
        }
        for (OrderedChangeObject changeObject : ((CollectionChangeRecord)mergeFromRecord).getOrderedChangeObjectList()) {
            ObjectChangeSet mergingObject = changeObject.getChangeSet();
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            OrderedChangeObject orderedChangeObject = new OrderedChangeObject(changeObject.getChangeType(), changeObject.getIndex(), localChangeSet);
            this.getOrderedChangeObjectList().add(orderedChangeObject);
        }
    }

    public void setAddObjectList(Map objectChangesList) {
        this.addObjectList = objectChangesList;
    }

    public void setRemoveObjectList(Map objectChangesList) {
        this.removeObjectList = objectChangesList;
    }

    @Override
    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> addList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getAddObjectList().size() + 1);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> removeList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getRemoveObjectList().size() + 1);
        if (this.getOrderedAddObjects().size() > 0 || this.getOrderedRemoveObjectIndices().size() > 0) {
            Vector<ObjectChangeSet> orderedAddList = new Vector<ObjectChangeSet>(this.getOrderedAddObjects().size());
            IdentityHashMap orderedAddListIndices = new IdentityHashMap(this.getOrderedAddObjectIndices().size());
            for (int i = 0; i < this.getOrderedAddObjects().size(); ++i) {
                ObjectChangeSet changeSet = (ObjectChangeSet)this.getOrderedAddObjects().elementAt(i);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedAddList.add(localChangeSet);
                orderedAddListIndices.put(localChangeSet, this.getOrderedAddObjectIndices().get(changeSet));
                if (!this.getAddObjectList().containsKey(changeSet)) continue;
                addList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedAddObjects(orderedAddList);
            this.setOrderedAddObjectIndices(orderedAddListIndices);
            Hashtable orderedRemoveList = new Hashtable(this.getOrderedRemoveObjects().size());
            Enumeration changes = this.getOrderedRemoveObjects().keys();
            while (changes.hasMoreElements()) {
                Object index = changes.nextElement();
                ObjectChangeSet changeSet = (ObjectChangeSet)this.getOrderedRemoveObjects().get(index);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedRemoveList.put(index, localChangeSet);
                if (!this.getRemoveObjectList().containsKey(changeSet)) continue;
                removeList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedRemoveObjects(orderedRemoveList);
        } else {
            ObjectChangeSet localChangeSet;
            Iterator changes = this.getAddObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)changes.next(), mergeFromChangeSet);
                addList.put(localChangeSet, localChangeSet);
            }
            changes = this.getRemoveObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)changes.next(), mergeFromChangeSet);
                removeList.put(localChangeSet, localChangeSet);
            }
        }
        this.setAddObjectList(addList);
        this.setRemoveObjectList(removeList);
    }

    public Vector getOrderedAddObjects() {
        if (this.orderedAddObjects == null) {
            this.orderedAddObjects = new Vector();
        }
        return this.orderedAddObjects;
    }

    public Integer getOrderedAddObjectIndex(ObjectChangeSet changes) {
        return (Integer)this.getOrderedAddObjectIndices().get(changes);
    }

    public Map getOrderedAddObjectIndices() {
        if (this.orderedAddObjectIndices == null) {
            this.orderedAddObjectIndices = new IdentityHashMap();
        }
        return this.orderedAddObjectIndices;
    }

    public Vector getOrderedChangeObjectList() {
        if (this.orderedChangeObjectList == null) {
            this.orderedChangeObjectList = new Vector();
        }
        return this.orderedChangeObjectList;
    }

    public Vector getOrderedRemoveObjectIndices() {
        if (this.orderedRemoveObjectIndices == null) {
            this.orderedRemoveObjectIndices = new Vector();
        }
        return this.orderedRemoveObjectIndices;
    }

    public Object getOrderedRemoveObject(Integer index) {
        return this.getOrderedRemoveObjects().get(index);
    }

    public Hashtable getOrderedRemoveObjects() {
        if (this.orderedRemoveObjects == null) {
            this.orderedRemoveObjects = new Hashtable();
        }
        return this.orderedRemoveObjects;
    }

    public void setOrderedAddObjectIndices(Map orderedAddObjectIndices) {
        this.orderedAddObjectIndices = orderedAddObjectIndices;
    }

    public void setOrderedAddObjects(Vector orderedAddObjects) {
        this.orderedAddObjects = orderedAddObjects;
    }

    public void setOrderedChangeObjectList(Vector orderedChangeObjectList) {
        this.orderedChangeObjectList = orderedChangeObjectList;
    }

    public void setOrderedRemoveObjects(Hashtable orderedRemoveObjects) {
        this.orderedRemoveObjects = orderedRemoveObjects;
    }

    public List<Integer> getCurrentIndexesOfOriginalObjects(List newList) {
        int i;
        int newSize = newList.size();
        ArrayList<Integer> currentIndexes = new ArrayList<Integer>(newSize);
        for (i = 0; i < newSize; ++i) {
            currentIndexes.add(i);
        }
        if (this.orderedChangeObjectList != null) {
            for (i = this.orderedChangeObjectList.size() - 1; i >= 0; --i) {
                OrderedChangeObject orderedChange = (OrderedChangeObject)this.orderedChangeObjectList.get(i);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == CollectionChangeEvent.ADD) {
                    if (index == null) {
                        currentIndexes.remove(currentIndexes.size() - 1);
                        continue;
                    }
                    currentIndexes.remove(index);
                    continue;
                }
                if (changeType != CollectionChangeEvent.REMOVE) continue;
                if (index == null) {
                    throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                }
                currentIndexes.add(index, newList.indexOf(obj));
            }
        }
        return currentIndexes;
    }

    public void recreateOriginalCollection(Object currentCollection, ContainerPolicy cp, AbstractSession session) {
        if (currentCollection == null) {
            this.setOriginalCollection(null);
            return;
        }
        if (currentCollection instanceof IndirectCollection) {
            this.setOriginalCollection(((IndirectCollection)currentCollection).getDelegateObject());
        } else {
            this.setOriginalCollection(currentCollection);
        }
        if (this.orderedChangeObjectList == null || this.orderedChangeObjectList.isEmpty()) {
            Iterator it;
            if (this.removeObjectList != null) {
                it = this.removeObjectList.keySet().iterator();
                while (it.hasNext()) {
                    cp.addInto(((ObjectChangeSet)it.next()).getUnitOfWorkClone(), this.getOriginalCollection(), session);
                }
                this.removeObjectList.clear();
            }
            if (this.addObjectList != null) {
                it = this.addObjectList.keySet().iterator();
                while (it.hasNext()) {
                    cp.removeFrom(((ObjectChangeSet)it.next()).getUnitOfWorkClone(), this.getOriginalCollection(), session);
                }
                this.addObjectList.clear();
            }
        } else {
            List originalList = (List)this.getOriginalCollection();
            for (int i = this.orderedChangeObjectList.size() - 1; i >= 0; --i) {
                OrderedChangeObject orderedChange = (OrderedChangeObject)this.orderedChangeObjectList.get(i);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == CollectionChangeEvent.ADD) {
                    if (index == null) {
                        originalList.remove(originalList.size() - 1);
                        continue;
                    }
                    originalList.remove(index);
                    continue;
                }
                if (changeType != CollectionChangeEvent.REMOVE) continue;
                if (index == null) {
                    throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                }
                originalList.add(index, obj);
            }
            this.orderedChangeObjectList.clear();
            if (this.removeObjectList != null) {
                this.removeObjectList.clear();
            }
            if (this.addObjectList != null) {
                this.addObjectList.clear();
            }
        }
    }

    public void setOrderHasBeenRepaired(boolean hasBeenRepaired) {
        this.orderHasBeenRepaired = hasBeenRepaired;
    }

    public boolean orderHasBeenRepaired() {
        return this.orderHasBeenRepaired;
    }
}

