/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyConstraint
implements Serializable {
    protected String name = "";
    protected List<String> sourceFields = new ArrayList<String>();
    protected List<String> targetFields = new ArrayList<String>();
    protected String targetTable = "";
    protected boolean shouldCascadeOnDelete = false;

    public ForeignKeyConstraint() {
    }

    public ForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        this();
        this.name = name;
        this.sourceFields.add(sourceField);
        this.targetFields.add(targetField);
        this.targetTable = targetTable;
    }

    public void addSourceField(String sourceField) {
        this.getSourceFields().add(sourceField);
    }

    public void addTargetField(String targetField) {
        this.getTargetFields().add(targetField);
    }

    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            writer.write("FOREIGN KEY (");
            Iterator<String> iterator = this.getSourceFields().iterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next());
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(") REFERENCES ");
            writer.write(this.getTargetTable());
            writer.write(" (");
            iterator = this.getTargetFields().iterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next());
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(")");
            if (this.shouldCascadeOnDelete()) {
                writer.write(" ON DELETE CASCADE");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void cascadeOnDelete() {
        this.setShouldCascadeOnDelete(true);
    }

    public void dontCascadeOnDelete() {
        this.setShouldCascadeOnDelete(false);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public List<String> getTargetFields() {
        return this.targetFields;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShouldCascadeOnDelete(boolean shouldCascadeOnDelete) {
        this.shouldCascadeOnDelete = shouldCascadeOnDelete;
    }

    public void setSourceFields(List<String> sourceFields) {
        this.sourceFields = sourceFields;
    }

    public void setTargetFields(List<String> targetFields) {
        this.targetFields = targetFields;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public boolean shouldCascadeOnDelete() {
        return this.shouldCascadeOnDelete;
    }
}

