/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryTableMetadata
extends TableMetadata {
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();

    public SecondaryTableMetadata() {
        super("<secondary-table>");
    }

    public SecondaryTableMetadata(MetadataAnnotation secondaryTable, MetadataAccessibleObject accessibleObject) {
        super(secondaryTable, accessibleObject);
        if (secondaryTable != null) {
            for (Object primaryKeyJoinColumn : (Object[])secondaryTable.getAttributeArray("pkJoinColumns")) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn, accessibleObject));
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof SecondaryTableMetadata) {
            SecondaryTableMetadata secondaryTable = (SecondaryTableMetadata)objectToCompare;
            return this.valuesMatch(this.m_primaryKeyJoinColumns, secondaryTable.getPrimaryKeyJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_secondary_table_catalog";
    }

    @Override
    public String getNameContext() {
        return "metadata_default_secondary_table_name";
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_secondary_table_schema";
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

