/*******************************************************************************
 * Copyright (c) 1998, 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.aggregate;

import java.util.*;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.TransformationMapping;

/**
 * TopLink generated Project class.
 * <b>WARNING</b>: This code was generated by an automated tool.
 * Any changes will be lost when the code is re-generated
 */
public class AggregateProject extends org.eclipse.persistence.sessions.Project {
    protected boolean useNewAggregateCollection;
    /**
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    public AggregateProject() {
        this(false);
    }
    public AggregateProject(boolean useNewAggregateCollection) {
        this.useNewAggregateCollection  = useNewAggregateCollection;
        applyPROJECT();
        applyLOGIN();
        buildAddressDescriptor();
        buildAddressDescriptionDescriptor();
        buildClientDescriptor();
        buildComputerDescriptor();
        buildEmployeeDescriptor();
        buildEvaluationClientDescriptor();
        buildLanguageDescriptor();
        buildPeriodDescriptor();
        buildPeriodDescriptionDescriptor();
        buildProjectDescriptionDescriptor();
        buildResponsibilityDescriptor();
        buildOidDescriptor();
        buildVersionDescriptor();
        buildJobDescriptor();
        buildWorkerDescriptor();

        //aggregate collection mapping
        buildAgentDescriptor();
        buildCustomerDescriptor();
        buildHouseDescriptor();
        buildDependantDescriptor();//nested aggregate collection "Agent->Customer->Dependant"
        buildCompanyDescriptor();//1:1 with aggregated Customer
        buildSingleHouseDescriptor();//inheritance "House -> SingleHouse"
        buildTownHouseDescriptor();//inheritance "House -> TownHouse"
        buildSellingPointDescriptor();//CR#2587, cascading foreign keys.
        buildRoomSellingPointDescriptor();// CR#2896
        if(useNewAggregateCollection) {
            buildBuilderDescriptor();
        }

        // Added May 5, 2000 - Jon D. for pr381
        buildTransportDescriptor();
        buildVehicleDescriptor();
        buildBicycleDescriptor();
        buildCarDescriptor();

        buildGolfClubShaftDescriptor();
        buildGolfClubDescriptor();
        buildManufacturerDescriptor();
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyLOGIN() {
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyPROJECT() {
        setName("ComplexAggregateSystem");
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildAddressDescriptionDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.AddressDescription.class);
        Vector vector = new Vector();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("periodDescription");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getPeriodDescription");
        aggregateobjectmapping.setSetMethodName("setPeriodDescription");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.PeriodDescription.class);
        aggregateobjectmapping.setIsNullAllowed(true);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Address.class);
        onetoonemapping.setIsPrivateOwned(true);
        // added for bug 5478648 - D.Minsky 
        onetoonemapping.setUsesBatchReading(true);
        onetoonemapping.addForeignKeyFieldName("AGG_EMP.EM_ADD", "AGG_ADD.ID");
        descriptor.addMapping(onetoonemapping);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildAddressDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Address.class);
        Vector vector = new Vector();
        vector.addElement("AGG_ADD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ADD.ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("address");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_ADD.ADDRESS");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_ADD.ID");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildAgentDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Agent.class);
        Vector vector = new Vector();
        vector.addElement("AGENT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGENT_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("AGENT_SEQ");
        descriptor.setSequenceNumberFieldName("AGENT_ID");
        //cr 4143  Must have version for this test
        org.eclipse.persistence.descriptors.VersionLockingPolicy lockingPolicy = new org.eclipse.persistence.descriptors.VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy(lockingPolicy);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("customers");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(true);
        aggregatecollectionmapping.setGetMethodName("getCustomerValueHolder");
        aggregatecollectionmapping.setSetMethodName("setCustomerValueHolder");
        aggregatecollectionmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Customer.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("CUSTOMER.AGENT_ID", "AGENT.AGENT_ID");
        descriptor.addMapping(aggregatecollectionmapping);

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping2 = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping2.setAttributeName("houses");
        aggregatecollectionmapping2.setIsReadOnly(false);
        aggregatecollectionmapping2.setUsesIndirection(true);
        aggregatecollectionmapping2.setGetMethodName("getHouseValueHolder");
        aggregatecollectionmapping2.setSetMethodName("setHouseValueHolder");
        aggregatecollectionmapping2.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.House.class);
        aggregatecollectionmapping2.addTargetForeignKeyFieldName("HOUSE.AGENT_ID", "AGENT.AGENT_ID");
        descriptor.addMapping(aggregatecollectionmapping2);

        // SECTION: AGGREGATECOLLECTIONMAPPING  -- java 2 collection

        /*    org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping2 = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
            aggregatecollectionmapping2.setAttributeName("houses2");
            aggregatecollectionmapping2.setIsReadOnly(false );
            //aggregatecollectionmapping2.setUsesIndirection(true);
            aggregatecollectionmapping2.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.House.class);
            aggregatecollectionmapping2.addTargetForeignKeyFieldName("HOUSE.AGENT_ID","AGENT.AGENT_ID");
            aggregatecollectionmapping2.useTransparentCollection();
            //aggregatecollectionmapping2.useCollectionClass(java.util.ArrayList.class);
            descriptor.addMapping(aggregatecollectionmapping2);

        */

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGENT_ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("firstName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getFirstName");
        directtofieldmapping1.setSetMethodName("setFirstName");
        directtofieldmapping1.setFieldName("FNAME");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLastName");
        directtofieldmapping2.setSetMethodName("setLastName");
        directtofieldmapping2.setFieldName("LNAME");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }

    protected void buildBicycleDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Bicycle.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.Vehicle.class);
        Vector vector = new Vector();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.BICYCLE_DESC");
        descriptor.addMapping(directtofieldmapping);
        addDescriptor(descriptor);
    }

    protected void buildBuilderDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Builder.class);
        Vector vector = new Vector();
        vector.addElement("BUILDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("BUILDER_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("BUILDER_SEQ");
        descriptor.setSequenceNumberFieldName("BUILDER_ID");
        //cr 4143  Must have version for this test
        org.eclipse.persistence.descriptors.VersionLockingPolicy lockingPolicy = new org.eclipse.persistence.descriptors.VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy(lockingPolicy);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("customers");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Customer.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("BUILDER_CUSTOMER.BUILDER_ID", "BUILDER.BUILDER_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.CUSTOMER_ID", "CUSTOMER_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.COMPANY_ID", "COMPANY_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.NAME", "NAME");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.INCOME", "INCOME");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.CUSTOMER_ID", "CUSTOMER_ID");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.FIRST_NAME", "FIRST_NAME");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.AGE", "AGE");
        aggregatecollectionmapping.useTransparentCollection();
        descriptor.addMapping(aggregatecollectionmapping);

        // SECTION: AGGREGATECOLLECTIONMAPPING

        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping2 = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping2.setAttributeName("houses");
        aggregatecollectionmapping2.setIsReadOnly(false );
        aggregatecollectionmapping2.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.House.class);
        aggregatecollectionmapping2.addTargetForeignKeyFieldName("BUILDER_HOUSE.BUILDER_ID","BUILDER.BUILDER_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.LOCATION", "LOCATION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.DESCRIPTIONS", "DESCRIPTIONS");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.INS_ID", "INS_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.VERSION", "VERSION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.TYPE", "TYPE");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.BUILDER_ID", "SINGLE_HOUSE.AGENT_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.LOCATION", "SINGLE_HOUSE.LOCATION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.GARAGE", "SINGLE_HOUSE.GARAGE");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.LOCATION", "LOCATION");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.AREA", "AREA");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.DESCRIPTION", "DESCRIPTION");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.TYPE", "TYPE");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.SQUARE_FEET", "SQUARE_FEET");
        aggregatecollectionmapping2.useTransparentCollection();
        descriptor.addMapping(aggregatecollectionmapping2);


        // SECTION: AGGREGATECOLLECTIONMAPPING

        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping3 = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping3.setAttributeName("vehicles");
        aggregatecollectionmapping3.setIsReadOnly(false );
        aggregatecollectionmapping3.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Vehicle.class);
        aggregatecollectionmapping3.addTargetForeignKeyFieldName("BUILDER_VEHICLE.BUILDER_ID","BUILDER.BUILDER_ID");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.TYPE", "TYPE");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAPACITY", "CAPACITY");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.COLOUR", "COLOUR");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.BICYCLE_DESC", "BICYCLE_DESC");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAR_MAKE", "CAR_MAKE");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAR_MODEL", "CAR_MODEL");
        aggregatecollectionmapping3.useTransparentCollection();
        descriptor.addMapping(aggregatecollectionmapping3);


        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("BUILDER_ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("firstName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getFirstName");
        directtofieldmapping1.setSetMethodName("setFirstName");
        directtofieldmapping1.setFieldName("FNAME");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLastName");
        directtofieldmapping2.setSetMethodName("setLastName");
        directtofieldmapping2.setFieldName("LNAME");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }

    protected void buildCarDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Car.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.Vehicle.class);
        Vector vector = new Vector();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("make");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.CAR_MAKE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("model");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGGVEHICLE.CAR_MODEL");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildClientDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Client.class);
        Vector vector = new Vector();
        vector.addElement("AGG_CLNT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_CLNT.CL_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("CL_ID");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(false);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.Client.class, "Client");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.EvaluationClient.class, "Eval");

        org.eclipse.persistence.descriptors.VersionLockingPolicy lockingPolicy = new org.eclipse.persistence.descriptors.VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("AGG_CLNT.VERSION");
        lockingPolicy.storeInObject();
        descriptor.setOptimisticLockingPolicy(lockingPolicy);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("addressDescription");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.AddressDescription.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_ADD", "AGG_EMP.EM_ADD");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_EDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_SDATE", "AGG_EMP.EM_SDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_EEDATE", "AGG_EMP.EM_EEDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_ESDATE", "AGG_EMP.EM_ESDATE");
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping2 = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping2.setAttributeName("id");
        aggregateobjectmapping2.setIsReadOnly(false);
        aggregateobjectmapping2.setGetMethodName("getOid");
        aggregateobjectmapping2.setSetMethodName("setOid");
        aggregateobjectmapping2.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Oid.class);
        aggregateobjectmapping2.addFieldNameTranslation("AGG_CLNT.CL_ID", "ID");
        aggregateobjectmapping2.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_CLNT.CL_NAME");
        descriptor.addMapping(directtofieldmapping1);

        org.eclipse.persistence.mappings.AggregateObjectMapping versionMapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Version.class);
        versionMapping.setIsNullAllowed(false);
        versionMapping.addFieldNameTranslation("AGG_CLNT.VERSION", "VERSION");
        descriptor.addMapping(versionMapping);

        addDescriptor(descriptor);
    }

    protected void buildCompanyDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Company.class);
        Vector vector = new Vector();
        vector.addElement("COMPANY_AGG");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COMPANY_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("COMPANY_SEQ");
        descriptor.setSequenceNumberFieldName("COMPANY_ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("companyId");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getCompanyId");
        directtofieldmapping.setSetMethodName("setCompanyId");
        directtofieldmapping.setFieldName("COMPANY_ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getName");
        directtofieldmapping1.setSetMethodName("setName");
        directtofieldmapping1.setFieldName("NAME");
        descriptor.addMapping(directtofieldmapping1);

        addDescriptor(descriptor);
    }

    protected void buildComputerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Computer.class);
        Vector vector = new Vector();
        vector.addElement("AGG_COM");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_COM.ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_COM.DESCRIP");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("id");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getOid");
        aggregateobjectmapping.setSetMethodName("setOid");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Oid.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        addDescriptor(descriptor);
    }

    protected void buildCustomerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Customer.class);
        Vector vector = new Vector();
        vector.addElement("CUSTOMER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("CUSTOMER_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("CUSTOMER_SEQ");
        descriptor.setSequenceNumberFieldName("CUSTOMER_ID");
        descriptor.descriptorIsAggregateCollection();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("dependants");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(true);
        aggregatecollectionmapping.setGetMethodName("getDependantValueHolder");
        aggregatecollectionmapping.setSetMethodName("setDependantValueHolder");
        aggregatecollectionmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Dependant.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("DEPENDANT.CUSTOMER_ID", "CUSTOMER.CUSTOMER_ID");
        descriptor.addMapping(aggregatecollectionmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("name");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getName");
        directtofieldmapping.setSetMethodName("setName");
        directtofieldmapping.setFieldName("NAME");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("income");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getIncome");
        directtofieldmapping1.setSetMethodName("setIncome");
        directtofieldmapping1.setFieldName("INCOME");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getId");
        directtofieldmapping2.setSetMethodName("setId");
        directtofieldmapping2.setFieldName("CUSTOMER_ID");
        descriptor.addMapping(directtofieldmapping2);

        org.eclipse.persistence.mappings.OneToOneMapping oneToOnemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        oneToOnemapping.setAttributeName("company");
        oneToOnemapping.setIsReadOnly(false);
        oneToOnemapping.setIsPrivateOwned(true);
        oneToOnemapping.setUsesIndirection(true);
        oneToOnemapping.setReferenceClass(Company.class);
        oneToOnemapping.addForeignKeyFieldName("CUSTOMER.COMPANY_ID", "COMPANY_AGG.COMPANY_ID");
        descriptor.addMapping(oneToOnemapping);

        addDescriptor(descriptor);
    }

    protected void buildDependantDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Dependant.class);
        Vector vector = new Vector();
        vector.addElement("DEPENDANT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("CUSTOMER_ID");
        descriptor.addPrimaryKeyFieldName("FIRST_NAME");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFirstName");
        directtofieldmapping.setSetMethodName("setFirstName");
        directtofieldmapping.setFieldName("FIRST_NAME");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("age");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getAge");
        directtofieldmapping1.setSetMethodName("setAge");
        directtofieldmapping1.setFieldName("AGE");
        descriptor.addMapping(directtofieldmapping1);

        addDescriptor(descriptor);
    }

    protected void buildEmployeeDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Employee.class);
        Vector vector = new Vector();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_EMP.EM_ADD");
        descriptor.addPrimaryKeyFieldName("AGG_EMP.EM_ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("EM_ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();

        // changed attribute name from "addressDescription" to "address" to reproduce bug 3566341,
        // which requires the same name for attribute mapped as an aggregate and an attribute
        // on the aggregate mapped 1 to 1.
        aggregateobjectmapping.setAttributeName("address");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getAddressDescription");
        aggregateobjectmapping.setSetMethodName("setAddressDescription");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.AddressDescription.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping1 = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping1.setAttributeName("projectDescription");
        aggregateobjectmapping1.setIsReadOnly(false);
        aggregateobjectmapping1.setGetMethodName("getProjectDescription");
        aggregateobjectmapping1.setSetMethodName("setProjectDescription");
        aggregateobjectmapping1.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.ProjectDescription.class);
        aggregateobjectmapping1.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFirstName");
        directtofieldmapping.setSetMethodName("setFirstName");
        directtofieldmapping.setFieldName("AGG_EMP.EM_FNAME");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("lastName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getLastName");
        directtofieldmapping1.setSetMethodName("setLastName");
        directtofieldmapping1.setFieldName("AGG_EMP.EM_LNAME");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildEvaluationClientDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.EvaluationClient.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.Client.class);
        Vector vector = new Vector();
        vector.addElement("AGG_ECNT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ECNT.CL_ID");

        // SECTION: PROPERTIES
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("evaluationPeriod");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Period.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_ECNT.EV_EDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_ECNT.EV_SDATE", "AGG_EMP.EM_SDATE");
        descriptor.addMapping(aggregateobjectmapping);
        addDescriptor(descriptor);
    }

    protected void buildGolfClubDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.GolfClub.class);
        descriptor.addTableName("GOLF_CLUB");
        descriptor.addPrimaryKeyFieldName("GOLF_CLUB.ID");

        // Descriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("GolfClub");

        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        // Query manager.
        descriptor.getDescriptorQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        org.eclipse.persistence.mappings.DirectToFieldMapping idMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        idMapping.setFieldName("GOLF_CLUB.ID");
        descriptor.addMapping(idMapping);

        org.eclipse.persistence.mappings.AggregateObjectMapping shaftMapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        shaftMapping.setAttributeName("shaft");
        shaftMapping.setGetMethodName("getShaft");
        shaftMapping.setSetMethodName("setShaft");
        shaftMapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.GolfClubShaft.class);
        shaftMapping.setIsNullAllowed(false);
        shaftMapping.addFieldNameTranslation("GOLF_CLUB.SHAFT_STIFFNESS", "SHAFT_STIFFNESS");
        // manual query key in aggregate
        shaftMapping.addFieldNameTranslation("GOLF_CLUB.SHAFT_STIFFNESS", "QUERY_KEY flexibility");
        descriptor.addMapping(shaftMapping);

        org.eclipse.persistence.mappings.OneToOneMapping manufacturerMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        manufacturerMapping.setAttributeName("manufacturer");
        manufacturerMapping.setGetMethodName("getManufacturer");
        manufacturerMapping.setSetMethodName("setManufacturer");
        manufacturerMapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Manufacturer.class);
        manufacturerMapping.dontUseIndirection();
        manufacturerMapping.addForeignKeyFieldName("GOLF_CLUB.MANUFACTURER_ID", "MANUFACTURER.ID");
        descriptor.addMapping(manufacturerMapping);

        addDescriptor(descriptor);
    }

    protected void buildGolfClubShaftDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.GolfClubShaft.class);

        // Descriptor properties.
        descriptor.setAlias("GolfClubShaft");

        // Query keys.
        descriptor.addDirectQueryKey("flexibility", "QUERY_KEY flexibility");
        
        // Query manager.
        //Named Queries
        // Event manager.
        // Mappings.
        org.eclipse.persistence.mappings.DirectToFieldMapping stiffnessRatingMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        stiffnessRatingMapping.setAttributeName("stiffnessRating");
        stiffnessRatingMapping.setFieldName("SHAFT_STIFFNESS");
        descriptor.addMapping(stiffnessRatingMapping);

        org.eclipse.persistence.mappings.OneToOneMapping manufacturerMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        manufacturerMapping.setAttributeName("manufacturer");
        manufacturerMapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Manufacturer.class);
        manufacturerMapping.dontUseIndirection();
        manufacturerMapping.addForeignKeyFieldName("GOLF_CLUB.SHAFT_MANUFACTURER_ID", "MANUFACTURER.ID");
        descriptor.addMapping(manufacturerMapping);

        addDescriptor(descriptor);
    }

    /**
     * An AggregateCollection where the primary key is actually the primary
     * key of its parent's parent.
     * This tests a case where a House must look beyond its direct owner
     * for a primary key.
     */
    protected void buildHouseDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.House.class);
        Vector vector = new Vector();
        vector.addElement("HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGENT_ID");
        descriptor.addPrimaryKeyFieldName("LOCATION");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();
        descriptor.useTimestampLocking("VERSION", false);
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.House.class, "H");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.TownHouse.class, "TH");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.SingleHouse.class, "SH");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("sellingPoints");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(false);
		aggregatecollectionmapping.useBatchReading();
        aggregatecollectionmapping.setGetMethodName("getSellingPoints");
        aggregatecollectionmapping.setSetMethodName("setSellingPoints");
        aggregatecollectionmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.SellingPoint.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("SELLING_POINT.AGENT_ID", "HOUSE.AGENT_ID");
        aggregatecollectionmapping.addTargetForeignKeyFieldName("SELLING_POINT.LOCATION", "HOUSE.LOCATION");

        descriptor.addMapping(aggregatecollectionmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        // For bug 2863721 test having an AggregateObject inside an
        // AggregateCollection. S.M.
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("insuranceId");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getInsuranceId");
        aggregateobjectmapping.setSetMethodName("setInsuranceId");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Oid.class);
        aggregateobjectmapping.addFieldNameTranslation("HOUSE.INS_ID", "ID");
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("location");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getLocation");
        directtofieldmapping.setSetMethodName("setLocation");
        directtofieldmapping.setFieldName("LOCATION");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("descriptions");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getDescriptions");
        directtofieldmapping2.setSetMethodName("setDescriptions");
        directtofieldmapping2.setFieldName("DESCRIPTIONS");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("version");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getVersion");
        directtofieldmapping3.setSetMethodName("setVersion");
        directtofieldmapping3.setFieldName("VERSION");
        descriptor.addMapping(directtofieldmapping3);
        addDescriptor(descriptor);
    }

    protected void buildJobDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Job.class);
        descriptor.setAmendmentClass(AggregateProject.class);
        descriptor.setAmendmentMethodName("amendJobDescriptor");
        Vector vector = new Vector();
        vector.addElement("WORKER");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("title");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getTitle");
        directtofieldmapping.setSetMethodName("setTitle");
        directtofieldmapping.setFieldName("WORKER.TITLE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: TRANSFORMATIONMAPPING
        org.eclipse.persistence.mappings.TransformationMapping transformationmapping = new org.eclipse.persistence.mappings.TransformationMapping();
        transformationmapping.setAttributeName("normalHours");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(false);
        transformationmapping.setGetMethodName("getNormalHours");
        transformationmapping.setSetMethodName("setNormalHours");
        transformationmapping.setAttributeTransformation("getNormalHoursFromRow");
        DatabaseField field = new DatabaseField("WORKER.END_TIME");
        field.setType(java.sql.Time.class);
        transformationmapping.addFieldTransformation(field, "getEndTime");
        field = new DatabaseField("WORKER.START_TIME");
        field.setType(java.sql.Time.class);
        transformationmapping.addFieldTransformation(field, "getStartTime");
        descriptor.addMapping(transformationmapping);
        addDescriptor(descriptor);
    }
    
    /**
     * The field types must be set in an amendment as the XML format does not support types.
     */
    public static void amendJobDescriptor(ClassDescriptor descriptor) {
        TransformationMapping transformationmapping = (TransformationMapping)descriptor.getMappingForAttributeName("normalHours");
        transformationmapping.getFieldTransformations().clear();
        DatabaseField field = new DatabaseField("WORKER.END_TIME");
        field.setType(java.sql.Time.class);
        transformationmapping.addFieldTransformation(field, "getEndTime");
        field = new DatabaseField("WORKER.START_TIME");
        field.setType(java.sql.Time.class);
        transformationmapping.addFieldTransformation(field, "getStartTime");
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildLanguageDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Language.class);
        Vector vector = new Vector();
        vector.addElement("AGG_LAN");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_LAN.ID");

        // SECTION: PROPERTIES
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();// A test depends on this...
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_LAN.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("language");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_LAN.LANG");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildManufacturerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Manufacturer.class);
        descriptor.addTableName("MANUFACTURER");
        descriptor.addPrimaryKeyFieldName("MANUFACTURER.ID");

        // Descriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Manufacturer");

        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");

        // Query manager.
        descriptor.getDescriptorQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        org.eclipse.persistence.mappings.DirectToFieldMapping idMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        idMapping.setFieldName("MANUFACTURER.ID");
        descriptor.addMapping(idMapping);

        org.eclipse.persistence.mappings.DirectToFieldMapping nameMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setGetMethodName("getName");
        nameMapping.setSetMethodName("setName");
        nameMapping.setFieldName("MANUFACTURER.NAME");
        descriptor.addMapping(nameMapping);

        addDescriptor(descriptor);
    }

    /**
     * This method is used to test shared aggregate as part of prim. key using Computer and Client Objects
     */
    protected void buildOidDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Oid.class);
        descriptor.descriptorIsAggregate();

        // SECTION: PROPERTIES
        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTMAPPING
        descriptor.addDirectMapping("id", "ID");

        addDescriptor(descriptor);
    }

    protected void buildPeriodDescriptionDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.PeriodDescription.class);
        Vector vector = new Vector();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("endPeriod");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Period.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_EMP.EM_EEDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_EMP.EM_ESDATE", "AGG_EMP.EM_SDATE");
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping1 = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping1.setAttributeName("period");
        aggregateobjectmapping1.setIsReadOnly(false);
        aggregateobjectmapping1.setGetMethodName("getPeriod");
        aggregateobjectmapping1.setSetMethodName("setPeriod");
        aggregateobjectmapping1.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Period.class);
        aggregateobjectmapping1.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping1);
        addDescriptor(descriptor);
    }

    protected void buildPeriodDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Period.class);
        Vector vector = new Vector();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("endDate");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_EMP.EM_EDATE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("startDate");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_EMP.EM_SDATE");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildProjectDescriptionDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.ProjectDescription.class);
        Vector vector = new Vector();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getDescription");
        directtofieldmapping.setSetMethodName("setDescription");
        directtofieldmapping.setFieldName("AGG_EMP.EM_PDESC");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_EMP.EM_ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: MANYTOMANYMAPPING
        org.eclipse.persistence.mappings.ManyToManyMapping manytomanymapping = new org.eclipse.persistence.mappings.ManyToManyMapping();
        manytomanymapping.setAttributeName("languages");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(true);
        manytomanymapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Language.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("EMP_LAN");
        manytomanymapping.addSourceRelationKeyFieldName("EMP_LAN.EMP_ID", "AGG_EMP.EM_ID");
        manytomanymapping.addTargetRelationKeyFieldName("EMP_LAN.LAN_ID", "AGG_LAN.ID");
        descriptor.addMapping(manytomanymapping);

        // SECTION: ONETOMANYMAPPING
        org.eclipse.persistence.mappings.OneToManyMapping onetomanymapping = new org.eclipse.persistence.mappings.OneToManyMapping();
        onetomanymapping.setAttributeName("responsibilities");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Responsibility.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("AGG_RES.EMP_ID", "AGG_EMP.EM_ID");
        descriptor.addMapping(onetomanymapping);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("computer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Computer.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("AGG_EMP.COMP_ID", "AGG_COM.ID");
        descriptor.addMapping(onetoonemapping);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildResponsibilityDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Responsibility.class);
        Vector vector = new Vector();
        vector.addElement("AGG_RES");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_RES.ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_RES.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("responsibility");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_RES.DUTY");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("AGG_RES.EMP_ID", "AGG_EMP.EM_ID");
        descriptor.addMapping(onetoonemapping);
        addDescriptor(descriptor);
    }

    // CR#2896
    protected void buildRoomSellingPointDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.RoomSellingPoint.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.SellingPoint.class);
        Vector vector = new Vector();
        vector.addElement("SELLING_POINT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.LOCATION");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AREA");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("squareFeet");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getSquareFeet");
        directtofieldmapping.setSetMethodName("setSquareFeet");
        directtofieldmapping.setFieldName("SELLING_POINT.SQUARE_FEET");
        descriptor.addMapping(directtofieldmapping);

        addDescriptor(descriptor);
    }

    protected void buildSellingPointDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.SellingPoint.class);
        Vector vector = new Vector();
        vector.addElement("SELLING_POINT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.LOCATION");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AREA");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();

        // CR#2896
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.SellingPoint.class, "SP");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.RoomSellingPoint.class, "R");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("area");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getArea");
        directtofieldmapping.setSetMethodName("setArea");
        directtofieldmapping.setFieldName("AREA");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("description");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getDescription");
        directtofieldmapping2.setSetMethodName("setDescription");
        directtofieldmapping2.setFieldName("SELLING_POINT.DESCRIPTION");
        descriptor.addMapping(directtofieldmapping2);

        addDescriptor(descriptor);
    }

    protected void buildSingleHouseDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.SingleHouse.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.House.class);
        Vector vector = new Vector();
        vector.addElement("SINGLE_HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SINGLE_HOUSE.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SINGLE_HOUSE.LOCATION");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("numberOfGarages");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getNumberOfGarages");
        directtofieldmapping.setSetMethodName("setNumberOfGarages");
        directtofieldmapping.setFieldName("SINGLE_HOUSE.GARAGE");
        descriptor.addMapping(directtofieldmapping);

        addDescriptor(descriptor);
    }

    protected void buildTownHouseDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.TownHouse.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.aggregate.House.class);
        Vector vector = new Vector();
        vector.addElement("HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("HOUSE.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("HOUSE.LOCATION");

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregateCollection();

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        addDescriptor(descriptor);
    }

    /**
     * This method was created in VisualAge.
     */
    protected void buildTransportDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Transport.class);
        Vector vector = new Vector();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGGVEHICLE.ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("vehicle");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getVehicle");
        aggregateobjectmapping.setSetMethodName("setVehicle");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Vehicle.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.ID");
        descriptor.addMapping(directtofieldmapping);
        addDescriptor(descriptor);
    }

    /**
     * This method was created in VisualAge.
     */
    public void buildVehicleDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Vehicle.class);
        Vector vector = new Vector();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.Car.class, new java.lang.Integer(1));
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.aggregate.Bicycle.class, new java.lang.Integer(2));

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("capacity");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.CAPACITY");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("colour");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGGVEHICLE.COLOUR");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    public void buildVersionDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Version.class);

        // Descriptor properties.
        descriptor.setAlias("Version");

        // Query manager.
        //Named Queries
        // Event manager.
        // Mappings.
        org.eclipse.persistence.mappings.DirectToFieldMapping versionNumberMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        versionNumberMapping.setAttributeName("versionNumber");
        versionNumberMapping.setFieldName("VERSION");
        descriptor.addMapping(versionNumberMapping);

        addDescriptor(descriptor);
    }

    /**
     * Insert the method's description here.
     * Creation date: (6/7/00 10:53:48 AM)
     */
    protected void buildWorkerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.aggregate.Worker.class);
        Vector vector = new Vector();
        vector.addElement("WORKER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("WORKER.ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("SEQ_WORKER");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping = new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("job");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getJob");
        aggregateobjectmapping.setSetMethodName("setJob");
        aggregateobjectmapping.setReferenceClass(org.eclipse.persistence.testing.models.aggregate.Job.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("fName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFName");
        directtofieldmapping.setSetMethodName("setFName");
        directtofieldmapping.setFieldName("WORKER.FNAME");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getId");
        directtofieldmapping1.setSetMethodName("setId");
        directtofieldmapping1.setFieldName("WORKER.ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLName");
        directtofieldmapping2.setSetMethodName("setLName");
        directtofieldmapping2.setFieldName("WORKER.LNAME");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }
}
