/*******************************************************************************
 * Copyright (c) 1998, 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.sessions.*;
import org.eclipse.persistence.descriptors.*;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

/**
 * This class was generated by the TopLink project class generator.
 * It stores the meta-data (descriptors) that define the TopLink mappings.
 * @see org.eclipse.persistence.sessions.factories.ProjectClassGenerator
 */
public class IsolatedEmployeeProject extends Project {
    public IsolatedEmployeeProject() {
        setName("IsolatedEmployee");
        applyLogin();

        addDescriptor(buildAddressDescriptor());
        addDescriptor(buildEmployeeDescriptor());
        addDescriptor(buildEmploymentPeriodDescriptor());
        addDescriptor(buildPhoneNumberDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        setLogin(login);
    }

    public RelationalDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress.class);
        descriptor.addTableName("ISOLATED_ADDRESS");
        descriptor.addPrimaryKeyFieldName("ISOLATED_ADDRESS.ADDRESS_ID");

        // Descriptor properties.
        descriptor.setSequenceNumberFieldName("ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Mappings.
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ISOLATED_ADDRESS.CITY");
        descriptor.addMapping(cityMapping);

        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ISOLATED_ADDRESS.COUNTRY");
        descriptor.addMapping(countryMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ISOLATED_ADDRESS.P_CODE");
        descriptor.addMapping(postalCodeMapping);

        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ISOLATED_ADDRESS.PROVINCE");
        descriptor.addMapping(provinceMapping);

        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ISOLATED_ADDRESS.STREET");
        descriptor.addMapping(streetMapping);

        return descriptor;
    }

    public RelationalDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee.class);
        descriptor.addTableName("ISOLATED_EMPLOYEE");
        descriptor.addTableName("ISOLATED_SALARY");
        descriptor.addPrimaryKeyFieldName("ISOLATED_EMPLOYEE.EMP_ID");

        // Descriptor properties.
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy(lockingPolicy);
        descriptor.setIsIsolated(true);
        // Tests depend on uow merge.
        descriptor.setUnitOfWorkCacheIsolationLevel(RelationalDescriptor.ISOLATE_NEW_DATA_AFTER_TRANSACTION);

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Mappings.
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("ISOLATED_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue("");
        descriptor.addMapping(firstNameMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("ISOLATED_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue("");
        descriptor.addMapping(lastNameMapping);

        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("ISOLATED_SALARY.SALARY");
        descriptor.addMapping(salaryMapping);

        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        ObjectTypeConverter genderConverter = new ObjectTypeConverter();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("ISOLATED_EMPLOYEE.GENDER");
        genderConverter.addConversionValue("M", "Male");
        genderConverter.addConversionValue("F", "Female");
        genderMapping.setConverter(genderConverter);
        descriptor.addMapping(genderMapping);

        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.setAttributeTransformation("buildNormalHours");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.END_TIME", "getEndTime");
        descriptor.addMapping(normalHoursMapping);

        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod.class);
        periodMapping.setIsNullAllowed(true);
        descriptor.addMapping(periodMapping);

        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useBasicIndirection();
        responsibilitiesListMapping.setReferenceTableName("ISOLATED_RESPONS");
        responsibilitiesListMapping.setDirectFieldName("ISOLATED_RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("ISOLATED_RESPONS.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(responsibilitiesListMapping);

        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.ADDR_ID", "ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping(addressMapping);

        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(IsolatedEmployee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(managerMapping);

        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(IsolatedEmployee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(managedEmployeesMapping);

        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(IsolatedPhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(phoneNumbersMapping);

        return descriptor;
    }

    public RelationalDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod.class);

        // Descriptor properties.
        // Query manager.
        // Event manager.
        // Mappings.
        DirectToFieldMapping endDateMapping = new DirectToFieldMapping();
        endDateMapping.setAttributeName("endDate");
        endDateMapping.setFieldName("END_DATE");
        descriptor.addMapping(endDateMapping);

        DirectToFieldMapping startDateMapping = new DirectToFieldMapping();
        startDateMapping.setAttributeName("startDate");
        startDateMapping.setFieldName("START_DATE");
        descriptor.addMapping(startDateMapping);

        return descriptor;
    }

    public RelationalDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedPhoneNumber.class);
        descriptor.addTableName("ISOLATED_PHONE");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.EMP_ID");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.TYPE");

        // Descriptor properties.
        descriptor.setIsIsolated(true);
        // Tests depend on uow merge.
        descriptor.setUnitOfWorkCacheIsolationLevel(RelationalDescriptor.ISOLATE_NEW_DATA_AFTER_TRANSACTION);

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Query keys.
        descriptor.addDirectQueryKey("id", "EMP_ID");

        // Mappings.
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("ISOLATED_PHONE.AREA_CODE");
        descriptor.addMapping(areaCodeMapping);

        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("ISOLATED_PHONE.P_NUMBER");
        descriptor.addMapping(numberMapping);

        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("ISOLATED_PHONE.TYPE");
        descriptor.addMapping(typeMapping);

        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(ownerMapping);

        descriptor.applyAmendmentMethod();
        return descriptor;
    }
}
