/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllMaxRowsVsRownumFilteringTest
extends PerformanceComparisonTestCase {
    public ReadAllMaxRowsVsRownumFilteringTest() {
        this.setDescription("This test compares the performance of Oracle rownum feature returning the first result vs a ReadAllQuery.");
        this.addReadAllRownumMaxRowsTest();
        this.addReadAllMaxRowsTest();
    }

    public void setup() throws Throwable {
        super.setup();
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void addReadAllRownumMaxRowsTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setMaxRows(1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllRownumMaxRowsTest");
        test.setAllowableDecrease(280.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllMaxRowsTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setMaxRows(1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }

            public void startTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(false);
            }

            public void endTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(true);
            }
        };
        test.setName("addReadAllMaxRowsTest");
        test.setAllowableDecrease(325.0);
        this.addTest((TestCase)test);
    }
}

