/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.inheritance.Engineer;
import org.eclipse.persistence.testing.models.inheritance.Person;
import org.eclipse.persistence.testing.models.inheritance.SalesRep;

public class ConformResultsSubclassesTest
extends TestCase {
    UnitOfWork uow;
    Vector people;
    Person result;

    public ConformResultsSubclassesTest() {
        this.setDescription("Test that ReadAllQuery and ReadObjectQuery don't return subclasses when conforming and don't read subclasses indicated.");
    }

    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        Engineer engineer = new Engineer();
        engineer.setName("e");
        SalesRep salesrep = new SalesRep();
        salesrep.setName("s");
        Person person = new Person();
        person.setName("p");
        this.uow.registerNewObject((Object)engineer);
        this.uow.registerNewObject((Object)salesrep);
        this.uow.registerNewObject((Object)person);
    }

    public void test() {
        ReadAllQuery raq = new ReadAllQuery(Person.class);
        raq.conformResultsInUnitOfWork();
        this.people = (Vector)this.uow.executeQuery((DatabaseQuery)raq);
        ReadObjectQuery roq = new ReadObjectQuery(Person.class);
        roq.conformResultsInUnitOfWork();
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("name").equal((Object)"s");
        roq.setSelectionCriteria(exp);
        Person result = (Person)this.uow.executeQuery((DatabaseQuery)roq);
        this.uow.release();
    }

    public void verify() {
        for (int i = 0; i < this.people.size(); ++i) {
            Person result = (Person)this.people.get(i);
            if (!result.name.equals("e") && !result.name.equals("s")) continue;
            this.throwError("ReadAllQuery with conform in unit of work returned subclasses despite descriptor indication not to.");
        }
        if (this.result != null) {
            this.throwError("ReadObjectQuery with conform in unit of work returned subclasses despite descriptor indication not to.");
        }
    }
}

