/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PrivateModifyTest
extends TestCase {
    protected Employee m_employeeFromDatabase;
    protected Number m_naddressId;
    protected Number m_nManagedEmployeeID;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.beginTransaction();
        ExpressionBuilder expBldr = new ExpressionBuilder();
        Expression whatWeWant = expBldr.get("lastName").equal((Object)"May");
        this.m_employeeFromDatabase = (Employee)this.getSession().readObject(Employee.class, whatWeWant);
    }

    public void test() {
        Address address = this.m_employeeFromDatabase.getAddress();
        String addressCity = address.getCity();
        this.m_naddressId = address.getId();
        address.setCity("Chelmsford");
        ((Employee)this.m_employeeFromDatabase.getManagedEmployees().elementAt(0)).setFirstName("MrFoobar");
        this.m_nManagedEmployeeID = ((Employee)this.m_employeeFromDatabase.getManagedEmployees().elementAt(0)).getId();
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject((Object)this.m_employeeFromDatabase);
        query.cascadePrivateParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        Expression expression = new ExpressionBuilder().get("id").equal(this.m_naddressId.intValue());
        Expression expression2 = new ExpressionBuilder().get("id").equal(this.m_nManagedEmployeeID.intValue());
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Address address = (Address)this.getSession().readObject(Address.class, expression);
        Employee managedEmployee = (Employee)this.getSession().readObject(Employee.class, expression2);
        if (!address.getCity().equals("Chelmsford")) {
            throw new TestErrorException("The private modify test failed.  The private owned relationship was not modified");
        }
        if (managedEmployee.getFirstName().equals("MrFoobar")) {
            throw new TestErrorException("The private modify test failed.  The not private owned relationship has been modified");
        }
    }
}

