/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class BatchReadValueholderTest
extends TestCase {
    protected Vector employees = null;
    BatchFetchType batchType;

    public BatchReadValueholderTest(BatchFetchType batchType) {
        this.setDescription("Ensure instantiated valueholders are not reset when a batch query runs.");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setBatchFetchType(this.batchType);
        query.addBatchReadAttribute("manager");
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Jim-bob");
        query.setSelectionCriteria(exp);
        Vector emps = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        for (Employee e : emps) {
            Employee m = (Employee)e.getManager();
            if (m == null) continue;
            m.hashCode();
        }
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addBatchReadAttribute("manager");
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        for (Employee emp : this.employees) {
            if (emp.getFirstName().equals("Jim-bob") && emp.getLastName().equals("Jefferson") && !emp.manager.isInstantiated()) {
                throw new TestErrorException("A batch read query changed an instantiated valueholder to uninstantiated.");
            }
            if (!emp.getFirstName().equals("John") || !emp.getLastName().equals("Way") || !emp.manager.isInstantiated()) continue;
            throw new TestErrorException("A valueholder was incorrectly instantiated by a batch read query.");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

