/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.queries.report.Bar;
import org.eclipse.persistence.testing.tests.queries.report.Beer;
import org.eclipse.persistence.testing.tests.queries.report.Brewer;
import org.eclipse.persistence.testing.tests.queries.report.Person;

public class BarBeerProject
extends Project {
    public BarBeerProject() {
        this.setName("barBeer_project");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildBarDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildBeerDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildBrewerDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPersonDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildBarDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bar.class);
        descriptor.addTableName("BAR");
        descriptor.addPrimaryKeyFieldName("BAR.KEY_BAR");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Bar");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BAR.KEY_BAR");
        descriptor.addMapping((DatabaseMapping)keyMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("BAR.TXT_NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        ManyToManyMapping beerCollectionMapping = new ManyToManyMapping();
        beerCollectionMapping.setAttributeName("beerCollection");
        beerCollectionMapping.setGetMethodName("getBeerCollection");
        beerCollectionMapping.setSetMethodName("setBeerCollection");
        beerCollectionMapping.setReferenceClass(Beer.class);
        beerCollectionMapping.setRelationshipPartnerAttributeName("barCollection");
        beerCollectionMapping.useTransparentCollection();
        beerCollectionMapping.useCollectionClass(IndirectList.class);
        beerCollectionMapping.setRelationTableName("BAR_BEER");
        beerCollectionMapping.addSourceRelationKeyFieldName("BAR_BEER.KEY_BAR", "BAR.KEY_BAR");
        beerCollectionMapping.addTargetRelationKeyFieldName("BAR_BEER.KEY_BEER", "BEER.KEY_BEER");
        descriptor.addMapping((DatabaseMapping)beerCollectionMapping);
        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("brewer");
        brewerMapping.setReferenceClass(Person.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("BAR.KEY_PERSON", "PERSON.KEY_PERSON");
        descriptor.addMapping((DatabaseMapping)brewerMapping);
        return descriptor;
    }

    public RelationalDescriptor buildBeerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Beer.class);
        descriptor.addTableName("BEER");
        descriptor.addPrimaryKeyFieldName("BEER.KEY_BEER");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Beer");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping brandMapping = new DirectToFieldMapping();
        brandMapping.setAttributeName("brand");
        brandMapping.setFieldName("BEER.TXT_BRAND");
        descriptor.addMapping((DatabaseMapping)brandMapping);
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BEER.KEY_BEER");
        descriptor.addMapping((DatabaseMapping)keyMapping);
        ManyToManyMapping barCollectionMapping = new ManyToManyMapping();
        barCollectionMapping.setAttributeName("barCollection");
        barCollectionMapping.setGetMethodName("getBarCollection");
        barCollectionMapping.setSetMethodName("setBarCollection");
        barCollectionMapping.setReferenceClass(Bar.class);
        barCollectionMapping.setRelationshipPartnerAttributeName("beerCollection");
        barCollectionMapping.useTransparentCollection();
        barCollectionMapping.useCollectionClass(IndirectList.class);
        barCollectionMapping.readOnly();
        barCollectionMapping.setRelationTableName("BAR_BEER");
        barCollectionMapping.addSourceRelationKeyFieldName("BAR_BEER.KEY_BEER", "BEER.KEY_BEER");
        barCollectionMapping.addTargetRelationKeyFieldName("BAR_BEER.KEY_BAR", "BAR.KEY_BAR");
        descriptor.addMapping((DatabaseMapping)barCollectionMapping);
        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("brewer");
        brewerMapping.setReferenceClass(Brewer.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("BEER.KEY_BREWER", "BREWER.KEY_BREWER");
        descriptor.addMapping((DatabaseMapping)brewerMapping);
        return descriptor;
    }

    public RelationalDescriptor buildBrewerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Brewer.class);
        descriptor.addTableName("BREWER");
        descriptor.addPrimaryKeyFieldName("BREWER.KEY_BREWER");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Brewer");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BREWER.KEY_BREWER");
        descriptor.addMapping((DatabaseMapping)keyMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("BREWER.TXT_NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        return descriptor;
    }

    public RelationalDescriptor buildPersonDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Person.class);
        descriptor.addTableName("PERSON");
        descriptor.addPrimaryKeyFieldName("PERSON.KEY_PERSON");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Person");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping brandMapping = new DirectToFieldMapping();
        brandMapping.setAttributeName("name");
        brandMapping.setFieldName("PERSON.TXT_NAME");
        descriptor.addMapping((DatabaseMapping)brandMapping);
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("PERSON.KEY_PERSON");
        descriptor.addMapping((DatabaseMapping)keyMapping);
        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("faviouriteBeer");
        brewerMapping.setReferenceClass(Beer.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("PERSON.KEY_BEER", "BEER.KEY_BEER");
        descriptor.addMapping((DatabaseMapping)brewerMapping);
        return descriptor;
    }
}

