/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.writing;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;

public class ComplexDeleteTest
extends ComplexUpdateTest {
    protected Vector dependants;

    public ComplexDeleteTest() {
        this(null, new Vector(2));
    }

    public ComplexDeleteTest(Object originalObject) {
        this(originalObject, new Vector(2));
    }

    public ComplexDeleteTest(Object originalObject, Vector dependants) {
        super(originalObject);
        this.dependants = dependants;
        this.usesUnitOfWork = true;
    }

    @Override
    protected void changeObject() {
        UnitOfWork uow = (UnitOfWork)this.getSession();
        Enumeration enumtr = this.getDependants().elements();
        while (enumtr.hasMoreElements()) {
            Object dependant = enumtr.nextElement();
            if (dependant instanceof ReadAllQuery) {
                uow.deleteAllObjects((Collection)((Vector)uow.executeQuery((DatabaseQuery)((ReadAllQuery)dependant))));
                continue;
            }
            if (dependant instanceof ReadObjectQuery) {
                uow.deleteObject(uow.executeQuery((DatabaseQuery)((ReadObjectQuery)dependant)));
                continue;
            }
            ReadObjectQuery query = new ReadObjectQuery(dependant.getClass());
            query.setSelectionObject(dependant);
            Object clone = uow.executeQuery((DatabaseQuery)query);
            uow.deleteObject(clone);
        }
        uow.deleteObject(this.workingCopy);
    }

    public Vector getDependants() {
        return this.dependants;
    }

    public void setDependents(Vector dependants) {
        this.dependants = dependants;
    }

    protected void verify() {
        this.objectToBeWritten = null;
        super.verify();
    }
}

