/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.JPAEntityListenerHolder;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class EntityListenerMetadata
extends ORMetadata
implements Cloneable {
    private MetadataClass m_entityListenerClass;
    protected EntityListener m_listener;
    private String m_className;
    private String m_postLoad;
    private String m_postPersist;
    private String m_postRemove;
    private String m_postUpdate;
    private String m_prePersist;
    private String m_preRemove;
    private String m_preUpdate;

    public EntityListenerMetadata() {
        super("<entity-listener>");
    }

    public EntityListenerMetadata(MetadataAnnotation entityListeners, MetadataClass entityListenerClass, MetadataAccessor accessor) {
        super(entityListeners, accessor);
        this.m_entityListenerClass = entityListenerClass;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException error) {
            throw new InternalError(error.getMessage());
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof EntityListenerMetadata) {
            EntityListenerMetadata entityListener = (EntityListenerMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_className, entityListener.getClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_postLoad, entityListener.getPostLoad())) {
                return false;
            }
            if (!this.valuesMatch(this.m_postPersist, entityListener.getPostPersist())) {
                return false;
            }
            if (!this.valuesMatch(this.m_postRemove, entityListener.getPostRemove())) {
                return false;
            }
            if (!this.valuesMatch(this.m_postUpdate, entityListener.getPostUpdate())) {
                return false;
            }
            if (!this.valuesMatch(this.m_prePersist, entityListener.getPrePersist())) {
                return false;
            }
            if (!this.valuesMatch(this.m_preRemove, entityListener.getPreRemove())) {
                return false;
            }
            return this.valuesMatch(this.m_preUpdate, entityListener.getPreUpdate());
        }
        return false;
    }

    protected Method getCallbackMethod(String methodName, Method[] methods) {
        Method method = this.getMethod(methodName, methods);
        if (method == null) {
            throw ValidationException.invalidCallbackMethod(this.m_listener.getListenerClass(), methodName);
        }
        return method;
    }

    Method[] getCandidateCallbackMethodsForEntityListener() {
        HashSet<Method> candidateMethods = new HashSet<Method>();
        Class listenerClass = this.m_listener.getListenerClass();
        Method[] declaredMethods = this.getDeclaredMethods(listenerClass);
        int i = 0;
        while (i < declaredMethods.length) {
            candidateMethods.add(declaredMethods[i]);
            ++i;
        }
        Method[] methods = this.getMethods(listenerClass);
        int i2 = 0;
        while (i2 < methods.length) {
            if (!candidateMethods.contains(methods[i2])) {
                candidateMethods.add(methods[i2]);
            }
            ++i2;
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    Class getClass(MetadataClass metadataClass, ClassLoader loader) {
        String classname = metadataClass.getName();
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    @Override
    public String getIdentifier() {
        return this.m_className;
    }

    protected Object getInstance(Class cls) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cls));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.errorInstantiatingClass(cls, exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(cls);
        }
        catch (IllegalAccessException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
        catch (InstantiationException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
    }

    Method getMethod(String methodName, Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    Method[] getMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(cls));
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_entityListenerClass = this.initXMLClassName(this.m_className);
    }

    public void process(ClassAccessor classAccessor, ClassLoader loader, boolean isDefaultListener) {
        if (this.m_entityListenerClass == null) {
            this.m_entityListenerClass = this.getMetadataFactory().getMetadataClass(this.m_className);
        }
        JPAEntityListenerHolder holder = new JPAEntityListenerHolder();
        holder.setIsDefaultListener(isDefaultListener);
        holder.listenerClassName = this.m_entityListenerClass.getName();
        if (this.m_entityListenerClass.extendsInterface(DescriptorEventListener.class)) {
            holder.listener = (DescriptorEventListener)this.getInstance(this.getClass(this.m_entityListenerClass, loader));
        } else {
            this.m_listener = new EntityListener(this.getClass(this.m_entityListenerClass, loader), this.getClass(classAccessor.getDescriptorJavaClass(), loader));
            this.processCallbackMethods(this.getCandidateCallbackMethodsForEntityListener(), classAccessor);
            holder.convertToSerializableMethods(this.m_listener.getAllEventMethods());
            holder.listener = this.m_listener;
            this.m_listener.setOwningSession(this.getProject().getSession());
        }
        classAccessor.getDescriptor().getClassDescriptor().getEventManager().addEntityListenerHolder(holder);
    }

    protected void processCallbackMethods(Method[] methods, ClassAccessor classAccessor) {
        if (this.m_postLoad != null) {
            this.setPostLoad(this.getCallbackMethod(this.m_postLoad, methods));
        }
        if (this.m_postPersist != null) {
            this.setPostPersist(this.getCallbackMethod(this.m_postPersist, methods));
        }
        if (this.m_postRemove != null) {
            this.setPostRemove(this.getCallbackMethod(this.m_postRemove, methods));
        }
        if (this.m_postUpdate != null) {
            this.setPostUpdate(this.getCallbackMethod(this.m_postUpdate, methods));
        }
        if (this.m_prePersist != null) {
            this.setPrePersist(this.getCallbackMethod(this.m_prePersist, methods));
        }
        if (this.m_preRemove != null) {
            this.setPreRemove(this.getCallbackMethod(this.m_preRemove, methods));
        }
        if (this.m_preUpdate != null) {
            this.setPreUpdate(this.getCallbackMethod(this.m_preUpdate, methods));
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            MetadataMethod metadataMethod = this.getMetadataClass(method.getDeclaringClass().getName(), false).getMethod(method.getName(), method.getParameterTypes());
            if (metadataMethod != null) {
                if (metadataMethod.isAnnotationPresent("javax.persistence.PostLoad", classAccessor) && this.m_postLoad == null) {
                    this.setPostLoad(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PostPersist", classAccessor) && this.m_postPersist == null) {
                    this.setPostPersist(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PostRemove", classAccessor) && this.m_postRemove == null) {
                    this.setPostRemove(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PostUpdate", classAccessor) && this.m_postUpdate == null) {
                    this.setPostUpdate(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PrePersist", classAccessor) && this.m_prePersist == null) {
                    this.setPrePersist(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PreRemove", classAccessor) && this.m_preRemove == null) {
                    this.setPreRemove(method);
                }
                if (metadataMethod.isAnnotationPresent("javax.persistence.PreUpdate", classAccessor) && this.m_preUpdate == null) {
                    this.setPreUpdate(method);
                }
            }
            ++n2;
        }
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    protected void setPostLoad(Method method) {
        this.m_listener.setPostCloneMethod(method);
        this.m_listener.setPostRefreshMethod(method);
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    protected void setPostPersist(Method method) {
        this.m_listener.setPostInsertMethod(method);
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    protected void setPostRemove(Method method) {
        this.m_listener.setPostDeleteMethod(method);
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    protected void setPostUpdate(Method method) {
        this.m_listener.setPostUpdateMethod(method);
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    protected void setPrePersist(Method method) {
        this.m_listener.setPrePersistMethod(method);
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    protected void setPreRemove(Method method) {
        this.m_listener.setPreRemoveMethod(method);
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    protected void setPreUpdate(Method method) {
        this.m_listener.setPreUpdateWithChangesMethod(method);
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }
}

