/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.StringWriter;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;

public class TableSequence
extends QuerySequence {
    public static final String defaultTableName = "SEQUENCE";
    protected DatabaseTable table;
    protected String counterFieldName = "SEQ_COUNT";
    protected String nameFieldName = "SEQ_NAME";

    public TableSequence() {
        super(false, true);
        this.setTableName("");
    }

    public TableSequence(String name) {
        super(name, false, true);
        this.setTableName("");
    }

    public TableSequence(String name, int size) {
        super(name, size, false, true);
        this.setTableName("");
    }

    public TableSequence(String name, int size, int initialValue) {
        super(name, size, initialValue, false, true);
        this.setTableName("");
    }

    public TableSequence(String name, String tableName) {
        this(name);
        this.setTableName(tableName);
    }

    public TableSequence(String name, String tableName, String nameFieldName, String counterFieldName) {
        this(name);
        this.setTableName(tableName);
        this.setNameFieldName(nameFieldName);
        this.setCounterFieldName(counterFieldName);
    }

    public TableSequence(String name, int size, String tableName) {
        this(name, size);
        this.setTableName(tableName);
    }

    public TableSequence(String name, int size, String tableName, String nameFieldName, String counterFieldName) {
        this(name, size);
        this.setTableName(tableName);
        this.setNameFieldName(nameFieldName);
        this.setCounterFieldName(counterFieldName);
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TableSequence) {
            TableSequence other = (TableSequence)obj;
            if (TableSequence.equalNameAndSize(this, other)) {
                return this.getTableName().equals(other.getTableName()) && this.getCounterFieldName().equals(other.getCounterFieldName()) && this.getNameFieldName().equals(other.getNameFieldName());
            }
            return false;
        }
        return false;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void setCounterFieldName(String name) {
        this.counterFieldName = name;
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String name) {
        this.nameFieldName = name;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public List<IndexDefinition> getTableIndexes() {
        return this.getTable().getIndexes();
    }

    public String getTableName() {
        return this.getTable().getQualifiedName();
    }

    public String getQualifiedTableName() {
        return this.getQualified(this.getTable().getName());
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public void setTableName(String name) {
        this.table = new DatabaseTable(name);
    }

    @Override
    public void onConnect() {
        if (this.table.getName().length() == 0) {
            this.table.setName(((DatabasePlatform)this.getDatasourcePlatform()).getDefaultSequenceTableName());
        }
        if ((this.qualifier == null || this.qualifier.length() == 0) && this.table.getTableQualifier() != null && this.table.getTableQualifier().length() != 0) {
            this.qualifier = this.table.getTableQualifier();
        }
        super.onConnect();
    }

    @Override
    protected ValueReadQuery buildSelectQuery() {
        ValueReadQuery query = new ValueReadQuery();
        query.addArgument(this.getNameFieldName());
        StringWriter writer = new StringWriter();
        writer.write("SELECT " + this.getCounterFieldName());
        writer.write(" FROM " + this.getQualifiedTableName());
        writer.write(" WHERE " + this.getNameFieldName());
        writer.write(" = #" + this.getNameFieldName());
        query.setSQLString(writer.toString());
        return query;
    }

    @Override
    protected DataModifyQuery buildUpdateQuery() {
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument(this.getNameFieldName());
        query.addArgument("PREALLOC_SIZE");
        StringWriter writer = new StringWriter();
        writer.write("UPDATE " + this.getQualifiedTableName());
        writer.write(" SET " + this.getCounterFieldName());
        writer.write(" = " + this.getCounterFieldName());
        writer.write(" + #PREALLOC_SIZE");
        writer.write(" WHERE " + this.getNameFieldName() + " = #" + this.getNameFieldName());
        query.setSQLString(writer.toString());
        return query;
    }
}

