/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.NamedQueryQueryCacheTest;

public class QueryCacheChangedParameterTest
extends NamedQueryQueryCacheTest {
    public QueryCacheChangedParameterTest() {
        this.setDescription("Ensure the query cache is cleared when a setting is changed.");
        this.expectedSQLCount = 1;
        this.expectedResults = 3;
    }

    @Override
    public void test() {
        ReadQuery query = (ReadQuery)this.getSessionForQueryTest().getQuery("cachedResultsQuery");
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like("J%");
        query.setSelectionCriteria(exp);
        this.results = this.getSessionForQueryTest().executeQuery((DatabaseQuery)query);
    }

    @Override
    public void verify() {
        super.verify();
        Iterator employees = ((Vector)this.results).iterator();
        while (employees.hasNext()) {
            if (((Employee)employees.next()).getFirstName().startsWith("J")) continue;
            throw new TestErrorException("Query results were not registered in the UOW  after being returned from a query with cached results");
        }
    }
}

