/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryAcrossOneToManyMapping
extends TestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector employees;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.allEmployees = new Vector();
        this.employees = new Vector();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("phoneNumbers").get("areaCode").equal((Object)"613"));
        this.getSession().removeQuery("getAllEmployees");
        this.getSession().addQuery("getAllEmployees", (DatabaseQuery)this.queryAll);
        this.allEmployees = (Vector)this.getSession().executeQuery("getAllEmployees");
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            Vector phones = ((Employee)enumtr.nextElement()).getPhoneNumbers();
            this.employees.addAll(phones);
        }
    }

    public void test() {
        this.queryObject = new ReadObjectQuery();
        this.queryObject.setReferenceClass(Employee.class);
        this.queryObject.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        this.queryObject.setSelectionCriteria(exp);
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
    }
}

