/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import org.eclipse.persistence.oxm.XMLNameTransformer;

public class DefaultXMLNameTransformer
implements XMLNameTransformer {
    private static final String EMPTY_STRING = "";
    private static final Character DOT_CHAR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHAR = Character.valueOf('$');

    @Override
    public String transformRootElementName(String className) {
        int idx;
        String elementName = null;
        elementName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        if (elementName.length() >= 3 && Character.isDigit(elementName.charAt((idx = elementName.length() - 1) - 1))) {
            elementName = String.valueOf(elementName.substring(0, idx)) + Character.toUpperCase(elementName.charAt(idx));
        }
        return elementName;
    }

    @Override
    public String transformTypeName(String className) {
        String typeName = EMPTY_STRING;
        typeName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        boolean inBreak = false;
        StringBuilder toReturn = new StringBuilder(typeName.length());
        int i = 0;
        while (i < typeName.length()) {
            char next = typeName.charAt(i);
            if (Character.isDigit(next)) {
                if (!inBreak) {
                    inBreak = true;
                }
                toReturn.append(next);
            } else if (inBreak) {
                toReturn.append(Character.toUpperCase(next));
                inBreak = false;
            } else {
                toReturn.append(next);
            }
            ++i;
        }
        return toReturn.toString();
    }

    private String decapitalize(String javaName) {
        char[] name = javaName.toCharArray();
        int i = 0;
        while (i < name.length && Character.isUpperCase(name[i])) {
            ++i;
        }
        if (i > 0) {
            if (name.length > i && Character.isLetter(name[i])) {
                --i;
            }
            name[0] = Character.toLowerCase(name[0]);
            int j = 1;
            while (j < i) {
                name[j] = Character.toLowerCase(name[j]);
                ++j;
            }
            return new String(name);
        }
        return javaName;
    }

    @Override
    public String transformElementName(String name) {
        return name;
    }

    @Override
    public String transformAttributeName(String name) {
        return name;
    }
}

