/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Address;
import org.eclipse.persistence.testing.models.mapping.CompanyCard;

public class OneToOnePKTest
extends AutoVerifyTestCase {
    public Address emp;

    public OneToOnePKTest() {
        this.setDescription("Check that objects with foreign keys as PK can be queries correctly.");
    }

    public void setup() {
        CompanyCard card = CompanyCard.example1();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.emp = (Address)uow.readObject(Address.class);
        card = (CompanyCard)uow.registerObject((Object)card);
        card.setOwner(this.emp);
        uow.commit();
    }

    public void test() {
        ExpressionBuilder card = new ExpressionBuilder();
        Expression expression = card.get("owner").equal((Object)this.emp);
        try {
            CompanyCard companyCard = (CompanyCard)this.getSession().readObject(CompanyCard.class, expression);
        }
        catch (ConversionException ex) {
            throw new TestErrorException("Failed to resolve PK's in OneToOneMapping: " + ex.toString());
        }
    }
}

