/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.stream.StreamSupport;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectListTestAPI
extends ZTestCase {
    private Vector<String> list;
    private IndirectList<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectList> cls;
    private boolean useListener;

    public IndirectListTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectListTestAPI(String name, Class<? extends IndirectList> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectList> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        Enumeration tests = ts.methodNamesStartingWithTestFor(IndirectListTestAPI.class);
        while (tests.hasMoreElements()) {
            ts.addTest((Test)new IndirectListTestAPI((String)tests.nextElement(), cls, useListener));
        }
        return ts;
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        Vector<String> temp = new Vector<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectList();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    public void testSort() {
        this.assertElementsEqual(this.list, (Vector)this.testList);
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        this.list.sort(c);
        this.testList.sort((Comparator)c);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertNoEvents();
    }

    public void testSpliterator() {
        IndirectListTestAPI.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(item -> this.list.contains(item)));
        IndirectListTestAPI.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(item -> this.testList.contains(item)));
        IndirectListTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testStream() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.stream().allMatch(item -> this.list.contains(item)));
        IndirectListTestAPI.assertTrue((boolean)this.list.stream().allMatch(item -> this.testList.contains(item)));
        IndirectListTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testParallelStream() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.parallelStream().allMatch(item -> this.list.contains(item)));
        IndirectListTestAPI.assertTrue((boolean)this.list.parallelStream().allMatch(item -> this.testList.contains(item)));
        IndirectListTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    public void testRemoveIf() {
        IndirectListTestAPI.assertTrue((boolean)this.list.removeIf(item -> item.startsWith("s")));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeIf(item -> item.startsWith("s")));
        IndirectListTestAPI.assertEquals((String)"size do not match", (int)8, (int)this.testList.size());
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertRemoveEvents(2);
    }

    public void testReplaceAll() {
        this.list.replaceAll(String::toUpperCase);
        this.testList.replaceAll(String::toUpperCase);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertRemoveAddEvents(this.testList.size());
    }

    public void testForEach() {
        StringWriter sw1 = new StringWriter();
        StringWriter sw2 = new StringWriter();
        this.list.forEach(sw1::append);
        this.testList.forEach(sw2::append);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        IndirectListTestAPI.assertEquals((String)sw1.toString(), (String)sw2.toString());
        this.assertNoEvents();
    }

    private void assertNoEvents() {
        if (this.useListener) {
            IndirectListTestAPI.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.REMOVE, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)totalEvents, (int)this.testListLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                CollectionChangeEvent removeEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                CollectionChangeEvent addEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                IndirectListTestAPI.assertEquals((String)"expected remove event", (int)CollectionChangeEvent.REMOVE, (int)removeEvent.getChangeType());
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)addEvent.getChangeType());
                IndirectListTestAPI.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }
}

