/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.stream.StreamSupport;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectSetTestAPI
extends ZTestCase {
    private Vector<String> list;
    private IndirectSet<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectSet> cls;
    private boolean useListener;

    public IndirectSetTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectSetTestAPI(String name, Class<? extends IndirectSet> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectSet> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        Enumeration tests = ts.methodNamesStartingWithTestFor(IndirectSetTestAPI.class);
        while (tests.hasMoreElements()) {
            ts.addTest((Test)new IndirectSetTestAPI((String)tests.nextElement(), cls, useListener));
        }
        return ts;
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        HashSet<String> temp = new HashSet<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectSet();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    public void testSpliterator() {
        IndirectSetTestAPI.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(item -> this.list.contains(item)));
        IndirectSetTestAPI.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(item -> this.testList.contains(item)));
        IndirectSetTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testStream() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.stream().allMatch(item -> this.list.contains(item)));
        IndirectSetTestAPI.assertTrue((boolean)this.list.stream().allMatch(item -> this.testList.contains(item)));
        IndirectSetTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testParallelStream() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.parallelStream().allMatch(item -> this.list.contains(item)));
        IndirectSetTestAPI.assertTrue((boolean)this.list.parallelStream().allMatch(item -> this.testList.contains(item)));
        IndirectSetTestAPI.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    public void testRemoveIf() {
        IndirectSetTestAPI.assertTrue((boolean)this.list.removeIf(item -> item.startsWith("s")));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.removeIf(item -> item.startsWith("s")));
        IndirectSetTestAPI.assertEquals((String)"size do not match", (int)8, (int)this.testList.size());
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        this.assertRemoveEvents(2);
    }

    public void testForEach() {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        this.list.forEach(v1::add);
        this.testList.forEach(v2::add);
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        this.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    private void assertNoEvents() {
        if (this.useListener) {
            IndirectSetTestAPI.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectSetTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectSetTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectSetTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectSetTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.REMOVE, (int)cce.getChangeType());
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }
}

