/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups.BaseFetchGroupTests;

public class SimpleFetchGroupTests
extends BaseFetchGroupTests {
    public SimpleFetchGroupTests() {
    }

    public SimpleFetchGroupTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SimpleFetchGroupTests");
        suite.addTest((Test)new SimpleFetchGroupTests("testSetup"));
        suite.addTest((Test)new SimpleFetchGroupTests("findNoFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("singleResultNoFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("resultListNoFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("singleResultEmptyFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("resultListEmptyFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("resultListPeriodFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("managerFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("managerFetchGroupWithJoinFetch"));
        suite.addTest((Test)new SimpleFetchGroupTests("employeeNamesFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("joinFetchEmployeeAddressWithDynamicFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("joinFetchEmployeeAddressPhoneWithDynamicFetchGroup"));
        suite.addTest((Test)new SimpleFetchGroupTests("verifyFetchedRelationshipAttributes"));
        suite.addTest((Test)new SimpleFetchGroupTests("detachedByClosingEntityManagerObjectWithFetchGroup"));
        if (!SimpleFetchGroupTests.isJPA10()) {
            suite.addTest((Test)new SimpleFetchGroupTests("findEmptyFetchGroup"));
            suite.addTest((Test)new SimpleFetchGroupTests("findEmptyFetchGroup_setUnfetchedSalary"));
            suite.addTest((Test)new SimpleFetchGroupTests("verifyUnfetchedAttributes"));
            suite.addTest((Test)new SimpleFetchGroupTests("explicitlyDetachedObjectWithFetchGroup"));
        }
        return suite;
    }

    @org.junit.Test
    public void findNoFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        int minId = SimpleFetchGroupTests.minimumEmployeeId(em);
        Employee emp = (Employee)em.find(Employee.class, (Object)minId);
        SimpleFetchGroupTests.assertNotNull((Object)emp);
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "firstName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "lastName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "gender");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "startTime");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "endTime");
        if (emp.getPeriod() != null) {
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
        }
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
        SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
    }

    @org.junit.Test
    public void singleResultNoFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleFetchGroupTests.minimumEmployeeId(em));
        Employee emp = (Employee)query.getSingleResult();
        SimpleFetchGroupTests.assertNotNull((Object)emp);
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "firstName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "lastName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "gender");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "startTime");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "endTime");
        if (emp.getPeriod() != null) {
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
        }
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
        SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
    }

    public void resultListNoFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleFetchGroupTests.minimumEmployeeId(em));
        List emps = query.getResultList();
        SimpleFetchGroupTests.assertNotNull((Object)emps);
        SimpleFetchGroupTests.assertEquals((int)1, (int)emps.size());
        Employee emp = (Employee)emps.get(0);
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "firstName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "lastName");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "gender");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "startTime");
        SimpleFetchGroupTests.assertFetchedAttribute(emp, "endTime");
        if (emp.getPeriod() != null) {
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
            SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
        }
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
        SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void findEmptyFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            int minId = SimpleFetchGroupTests.minimumEmployeeId(em);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            HashMap<String, FetchGroup> properties = new HashMap<String, FetchGroup>();
            FetchGroup emptyFG = new FetchGroup();
            properties.put("eclipselink.fetch-group", emptyFG);
            Employee emp = (Employee)em.find(Employee.class, (Object)minId, properties);
            SimpleFetchGroupTests.assertNotNull((Object)emp);
            SimpleFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            emp.getSalary();
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            emp.getAddress();
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            emp.getPhoneNumbers().size();
            SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
            }
            if (emp.getManager() != null) {
                SimpleFetchGroupTests.assertEquals((int)6, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void findEmptyFetchGroup_setUnfetchedSalary() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            int minId = SimpleFetchGroupTests.minimumEmployeeId(em);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            HashMap<String, FetchGroup> properties = new HashMap<String, FetchGroup>();
            FetchGroup emptyFG = new FetchGroup();
            properties.put("eclipselink.fetch-group", emptyFG);
            Employee emp = (Employee)em.find(Employee.class, (Object)minId, properties);
            SimpleFetchGroupTests.assertNotNull((Object)emp);
            SimpleFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            emp.setSalary(1);
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            emp.getAddress();
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            emp.getPhoneNumbers().size();
            SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void singleResultEmptyFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleFetchGroupTests.minimumEmployeeId(em));
            FetchGroup emptyFG = new FetchGroup();
            query.setHint("eclipselink.fetch-group", (Object)emptyFG);
            Employee emp = (Employee)query.getSingleResult();
            SimpleFetchGroupTests.assertNotNull((Object)emp);
            SimpleFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            emp.getSalary();
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            emp.getAddress();
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            emp.getPhoneNumbers().size();
            SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void resultListEmptyFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleFetchGroupTests.minimumEmployeeId(em));
            FetchGroup emptyFG = new FetchGroup();
            query.setHint("eclipselink.fetch-group", (Object)emptyFG);
            List emps = query.getResultList();
            SimpleFetchGroupTests.assertNotNull((Object)emps);
            SimpleFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getPeriod() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getSalary();
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
            }
            SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void resultListPeriodFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleFetchGroupTests.minimumEmployeeId(em));
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("period");
            query.setHint("eclipselink.fetch-group", (Object)fg);
            List emps = query.getResultList();
            SimpleFetchGroupTests.assertNotNull((Object)emps);
            SimpleFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetched((Object)emp, fg);
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getSalary();
            SimpleFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
            }
            SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @org.junit.Test
    public void managerFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            SimpleFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleFetchGroupTests.assertFetched((Object)emp, managerFG);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            int nSqlToAdd = 0;
            if (emp.getManager() != null) {
                SimpleFetchGroupTests.assertFetchedAttribute(emp, "manager");
                ++nSqlToAdd;
            }
            SimpleFetchGroupTests.assertEquals((int)(1 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getLastName();
            SimpleFetchGroupTests.assertEquals((int)(2 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleFetchGroupTests.assertEquals((int)(3 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void managerFetchGroupWithJoinFetch() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            SimpleFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleFetchGroupTests.assertFetched((Object)emp, managerFG);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getManager();
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getLastName();
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @org.junit.Test
    public void employeeNamesFetchGroup() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            int minId = SimpleFetchGroupTests.minimumEmployeeId(em);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)minId);
            FetchGroup namesFG = new FetchGroup();
            namesFG.addAttribute("firstName");
            namesFG.addAttribute("lastName");
            query.setHint("eclipselink.fetch-group", (Object)namesFG);
            SimpleFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleFetchGroupTests.assertSame((Object)namesFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getId();
            emp.getFirstName();
            emp.getLastName();
            emp.getVersion();
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getGender();
            emp.getSalary();
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
                SimpleFetchGroupTests.assertNoFetchGroup(emp.getManager());
            } else {
                SimpleFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressWithDynamicFetchGroup() {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleFetchGroupTests.assertNotNull((Object)emps);
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup() {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT p.owner.id FROM PhoneNumber p)");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleFetchGroupTests.assertNotNull((Object)emps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void verifyUnfetchedAttributes() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            TypedQuery q = em.createQuery("SELECT e FROM Employee e WHERE e.id IN (SELECT MIN(p.owner.id) FROM PhoneNumber p)", Employee.class);
            FetchGroup fg = new FetchGroup("Employee.empty");
            q.setHint("eclipselink.fetch-group", (Object)fg);
            Employee emp = (Employee)q.getSingleResult();
            SimpleFetchGroupTests.assertNotNull((Object)emp);
            SimpleFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            IndirectList phonesIL = (IndirectList)emp.getPhoneNumbers();
            SimpleFetchGroupTests.assertFalse((boolean)phonesIL.isInstantiated());
            SimpleFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleFetchGroupTests.assertTrue((emp.getPhoneNumbers().size() > 0 ? 1 : 0) != 0);
            SimpleFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void verifyFetchedRelationshipAttributes() throws Exception {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        FetchGroup fg = new FetchGroup("Employee.relationships");
        fg.addAttribute("address");
        fg.addAttribute("phoneNumbers");
        fg.addAttribute("manager");
        fg.addAttribute("projects");
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("eclipselink.fetch-group", fg);
        Employee emp = SimpleFetchGroupTests.minimumEmployee(em, hints);
        SimpleFetchGroupTests.assertNotNull((Object)emp);
    }

    @org.junit.Test
    public void detachedByClosingEntityManagerObjectWithFetchGroup() {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("eclipselink.fetch-group", fg);
        Employee emp = SimpleFetchGroupTests.minimumEmployee(em, hints);
        SimpleFetchGroupTests.assertFetched((Object)emp, fg);
        this.closeEntityManager(em);
        emp.getSalary();
        SimpleFetchGroupTests.assertNoFetchGroup(emp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void explicitlyDetachedObjectWithFetchGroup() {
        EntityManager em = SimpleFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            HashMap<String, Object> hints = new HashMap<String, Object>();
            hints.put("eclipselink.fetch-group", fg);
            Employee emp = SimpleFetchGroupTests.minimumEmployee(em, hints);
            em.detach((Object)emp);
            SimpleFetchGroupTests.assertFetched((Object)emp, fg);
            emp.getSalary();
            SimpleFetchGroupTests.assertNoFetchGroup(emp);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

