/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Child;
import org.eclipse.persistence.testing.models.aggregate.Parent;

public class AggregateRelationshipsOneToManyTestCase
extends TestCase {
    protected Parent originalParent;
    protected Parent readParent;

    public AggregateRelationshipsOneToManyTestCase() {
        this.setDescription("AggregateRelationships: test OneToManyMapping");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalParent = new Parent();
        Child child1 = new Child();
        Child child2 = new Child();
        Child child3 = new Child();
        this.originalParent.addChild(child1);
        this.originalParent.addChild(child2);
        this.originalParent.addChild(child3);
        uow.registerObject((Object)this.originalParent);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        int id = this.originalParent.getId();
        try {
            this.readParent = (Parent)this.getSession().readObject(Parent.class, new ExpressionBuilder().get("id").equal(id));
        }
        catch (EclipseLinkException exception) {
            this.throwError("An exception occurred whilst reading back a Parent object with id " + id, exception);
        }
    }

    public void verify() {
        AggregateRelationshipsOneToManyTestCase.assertNotNull((String)"Parent read back should not be null", (Object)this.readParent);
        this.compareObjects(this.originalParent, this.readParent);
        AggregateRelationshipsOneToManyTestCase.assertEquals((int)this.originalParent.getAggregate().getChildren().size(), (int)this.readParent.getAggregate().getChildren().size());
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteAllObjects(this.originalParent.getAggregate().getChildren());
        uow.deleteObject((Object)this.originalParent);
        uow.commit();
    }
}

