/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Iterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.DirectEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;

public class TestUpdateDirectEntityMapMapping
extends TestCase {
    private DirectEntityMapHolder holder = null;
    protected ManyToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldPrivateOwnedValue = false;
    protected DirectEntityMapHolder changedHolder = null;

    public TestUpdateDirectEntityMapMapping() {
    }

    public TestUpdateDirectEntityMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateDirectEntityMapMapping privateOwned=" + usePrivateOwned);
    }

    public void setup() {
        this.mapping = (ManyToManyMapping)this.getSession().getProject().getDescriptor(DirectEntityMapHolder.class).getMappingForAttributeName("directToEntityMap");
        this.oldPrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = new DirectEntityMapHolder();
        EntityMapValue value = new EntityMapValue();
        value.setId(1);
        this.holder.addDirectToEntityMapItem(new Integer(11), value);
        EntityMapValue value2 = new EntityMapValue();
        value2.setId(2);
        this.holder.addDirectToEntityMapItem(new Integer(22), value2);
        uow.registerObject((Object)this.holder);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.holder);
        if (!this.compareObjects(this.holder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.changedHolder = (DirectEntityMapHolder)uow.readObject((Object)this.holder);
        EntityMapValue value = new EntityMapValue();
        value.setId(3);
        this.changedHolder.addDirectToEntityMapItem(new Integer(33), value);
        this.changedHolder.getDirectToEntityMap().remove(new Integer(11));
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.holder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.holder = (DirectEntityMapHolder)this.getSession().readObject((Object)this.holder);
        if (!this.compareObjects(this.holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (this.holder.getDirectToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        EntityMapValue value = (EntityMapValue)this.holder.getDirectToEntityMap().get(new Integer(33));
        if (value.getId() != 3) {
            throw new TestErrorException("MapEntityValue was not added properly.");
        }
        value = (EntityMapValue)this.holder.getDirectToEntityMap().get(11);
        if (value != null) {
            throw new TestErrorException("Deleted EntityMapValue still around.");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EntityMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned EntityMapValue was not deleted.");
            }
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Iterator j = this.holder.getDirectToEntityMap().keySet().iterator();
        while (j.hasNext()) {
            uow.deleteObject(this.holder.getDirectToEntityMap().get(j.next()));
        }
        uow.deleteObject((Object)this.holder);
        uow.commit();
        this.mapping.setIsPrivateOwned(this.oldPrivateOwnedValue);
    }
}

