/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.mappings;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleTypes_ManyToMany {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;
    static DynamicType aType = null;
    static DynamicType bType = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class simpleTypeA = dcl.createDynamicClass("simple.mappings.SimpleA");
        DynamicTypeBuilder aFactory = new DynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aFactory.setPrimaryKeyFields(new String[]{"SID"});
        aType = aFactory.getType();
        Class simpleTypeB = dcl.createDynamicClass("simple.mappings.SimpleB");
        DynamicTypeBuilder bFactory = new DynamicTypeBuilder(simpleTypeB, null, new String[]{"SIMPLE_TYPE_B"});
        bFactory.setPrimaryKeyFields(new String[]{"SID"});
        bType = bFactory.getType();
        bFactory.addDirectMapping("id", Integer.TYPE, "SID");
        bFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addDirectMapping("id", Integer.TYPE, "SID");
        aFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addManyToManyMapping("b", bFactory.getType(), "SIMPLE_A_B");
        dynamicHelper.addTypes(true, true, new DynamicType[]{aFactory.getType(), bFactory.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_A_B");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_A");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDynamicTables() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_A_B");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_A");
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = session.getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)aType);
        Assert.assertEquals((Object)descriptorA, (Object)aType.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = session.getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)bType);
        Assert.assertEquals((Object)descriptorB, (Object)bType.getDescriptor());
        DirectToFieldMapping b_id = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)b_id.getAttributeClassification());
        DirectToFieldMapping b_value1 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)b_value1.getAttributeClassification());
        ManyToManyMapping a_b = (ManyToManyMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertEquals((Object)descriptorB, (Object)a_b.getReferenceDescriptor());
    }

    @Test
    public void createSimpleA() {
        DynamicEntity simpleInstance = aType.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void createSimpleB() {
        DynamicEntity simpleInstance = bType.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"B1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery(bType.getName(), new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void createAwithB() {
        DynamicEntity simpleInstanceB = bType.newDynamicEntity();
        simpleInstanceB.set("id", (Object)1);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = aType.newDynamicEntity();
        simpleInstanceA.set("id", (Object)1);
        simpleInstanceA.set("value1", (Object)"A2");
        ((Collection)simpleInstanceA.get("b")).add(simpleInstanceA);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstanceB);
        uow.registerNewObject((Object)simpleInstanceA);
        uow.commit();
        ReportQuery countQueryB = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQueryB.addCount();
        countQueryB.setShouldReturnSingleValue(true);
        int simpleCountB = ((Number)session.executeQuery((DatabaseQuery)countQueryB)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountB);
        ReportQuery countQueryA = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQueryA.addCount();
        countQueryA.setShouldReturnSingleValue(true);
        int simpleCountA = ((Number)session.executeQuery((DatabaseQuery)countQueryA)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
    }

    @Ignore
    public void createAwithExistingB() {
    }

    @Test
    public void removeRelationshop() {
        this.createAwithB();
        UnitOfWork uow = session.acquireUnitOfWork();
        ReadObjectQuery roq = dynamicHelper.newReadObjectQuery("SimpleA");
        roq.setSelectionCriteria(roq.getExpressionBuilder().get("id").equal(1));
        DynamicEntity a = (DynamicEntity)session.executeQuery((DatabaseQuery)roq);
        Assert.assertNotNull((Object)a);
        List bs = (List)a.get("b");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((long)1L, (long)bs.size());
        bs.remove(0);
        uow.commit();
    }

    @Ignore
    public void addAtoB() {
    }
}

